## Synopsis

The `operfact` package enables the modeling and solution of structured low-rank operator recovery problems using nuclear norms.

My thesis discusses these problems in more detail. (link pending final publication)

## Code Example

The following code demonstrates the creation and solution of a synthetic operator denoising problem.

```python
import numpy as np
from operfact import operators, measurements, solvers
from operfact import regularizers as regs

shape = (m, n, p, q)
nfactors = r
sigma = 0.1

# Create the true operator and noisy measurements
oper = operators.RandomDyadsOperator(shape, nfactors)
measobj = measurements.IdentityMeasurement(shape)
measvec = measobj.apply(oper) + sigma*np.random.normal(size=measobj.nmeas)

# Create the problem instance
prob = solvers.Problem()
prob.shape = shape
prob.measurementobj = measobj
prob.measurementvec = measvec
prob.norm = regs.NucNorm_Prod(regs.norm_l2, regs.norm_l2)
prob.penconst = regs.penconst_denoise(shape, sigma, prob.norm)
prob.solver = cvxpy.SCS
prob.rank = r  # altminsolve only

# Solve the problem
out = solvers.altminsolve(prob)
```

## Installation

The easiest way to obtain this package is from PyPI:

```
pip install operfact
```

It requires CVXPY, NumPy, and SciPy.

## API Reference

Documentation is included in the `doc` folder (autogenerated from docstrings). Background information is available in my thesis.

## License

While appropriate licensing to this software is pending, the author reserves all rights.

