# -*- coding: utf-8 -*-
import cvxpy
import denoise_experiment_parallel as exp
import itertools
import numpy as np
from operfact import regularizers as regs
from operfact import utils


def rand_gaussianmat(shape):
    return utils.rand_gaussianmat(shape, False)


def rand_sparsemat(shape):
    return utils.rand_sparsemat(shape, 1.0/np.prod(shape))


def rand_signmat(shape):
    return utils.rand_signmat(shape, False)


def rand_lowrankmat(shape):
    return utils.rand_lowrankmat(shape, 1)


def rand_orthmat(shape):
    return utils.rand_orthmat(shape)


types = [rand_sparsemat, rand_gaussianmat, rand_signmat,
         rand_lowrankmat, rand_orthmat]
inner_types = itertools.combinations_with_replacement(types, 2)

norms = [regs.norm_l1, regs.norm_l2, regs.norm_linf,
         regs.norm_s1, regs.norm_sinf]
sum_norms = [regs.NucNorm_Sum(*tup)
             for tup in itertools.product(norms, norms)]
prod_norms = [regs.NucNorm_Prod(*tup)
              for tup in itertools.product(norms, norms)]
for nns in sum_norms:
    nns.norm_mat = None  # don't bother running matsolve on these again
sq_norms = [regs.norm_l2, regs.norm_linf]
sdr_norms = [regs.NucNorm_SDR(*tup)
             for tup in itertools.product(sq_norms, sq_norms)]
regularizers = prod_norms + sum_norms + sdr_norms

PARAMS = {'shape': [(16, 16, 16, 16), ],
          'rank': [1, 2, 4, 8, 16],
          'inner_type': inner_types,
          'db': [10.0, ],
          'penconst_offset': [-np.Inf, -3, -2, -1, 0, 1],
          'solve_rank': [1, 4, 16],
          'relconvergetol': [1e-1, 5e-2, 1e-2, 5e-3, 1e-3],
          'outer_iters': [25, ],
          'inner_solver': [cvxpy.SCS, ],
          'regularizer': regularizers,
          'solveropts': {'verbose': False}}

if __name__ == '__main__':
    exp.run_experiment('denoise_16all.csv.gz', PARAMS, ntrials=4, nprocs=12,
                       seed=None, return_rows=False)
