# -*- coding: utf-8 -*-
import cvxpy
import itertools
import matplotlib.pyplot as plt
import numpy as np
import operfact
from operfact import regularizers as regs
from operfact import measurements, operators, solvers, utils
from osgeo import gdal


## Load HSI
tiff = gdal.Open("Hyperspectral_Project/dc.tif", gdal.GA_ReadOnly)
_temp = tiff.GetRasterBand(1).ReadAsArray()
Y = np.empty((tiff.RasterYSize, tiff.RasterXSize, tiff.RasterCount), dtype=_temp.dtype)
del _temp
for i in range(1, tiff.RasterCount + 1):
    band = tiff.GetRasterBand(i)
    Y[:,:,i-1] = band.ReadAsArray()

Yfloat = Y.astype(float)

## Generate Figure 6.4
# clip 2% each band individually
Yclip = np.empty_like(Yfloat)
for i in range(Yfloat.shape[2]):
    _temp = Yfloat[:,:,i]
    qtiles = np.percentile(_temp, (1, 99))
    _temp[_temp < qtiles[0]] = qtiles[0]
    _temp[_temp > qtiles[1]] = qtiles[1]
    Yclip[:,:,i] = _temp

#normalize only the bands we use individually
Ynorm = Yclip[:,:,(59,26,16)]
for i in range(Ynorm.shape[2]):
    Ynorm[:,:,i] = (Ynorm[:,:,i] - np.min(Ynorm[:,:,i]))/(np.max(Ynorm[:,:,i])-np.min(Ynorm[:,:,i]))

fig, ax = plt.subplots(figsize=np.array(Y[:,:,0].shape)[::-1]/plt.rcParams['figure.dpi'])
ax.imshow(Ynorm)
ax.axis("off")

plt.imsave('figures/hsi-dc.png', Ynorm, dpi=300)
