library(dplyr)
library(ggplot2)
library(tidyr)

## Load data
identmeas_df <- tbl_df(read.csv('splib_identmeas.csv.gz'))

## Summarize
identmeas_df.avg <- identmeas_df %>%
  filter(hsisolver == 'opersolve') %>%
  group_by(snr, regularizer, solve_rank, opersolver, max_outer_iters, max_inner_iters, relconvergetol, penconst_offset) %>%
  summarize(avg_error=mean(rel_error), max_error=max(rel_error), min_error=min(rel_error), time=mean(time), avg_rsdr=-20*log10(avg_error), avg_iters=mean(outer_iters))
# Pick empirically best penconst_offset
identmeas_df.bestmse <- identmeas_df.avg %>%
  filter(row_number(avg_error)==1)

## Results from opersolve
identmeas_df.bestmse %>% filter(opersolver == 'altminsolve_noquad') %>%
  select(snr, regularizer, solve_rank, penconst_offset, avg_rsdr) %>%
  mutate(avg_gain=avg_rsdr-snr) %>%
  write.csv("tables/oper_errors.csv")

## Results from kpsvd
identmeas_df %>%
  filter(hsisolver == 'kpsvdsolve') %>%
  group_by(solve_rank) %>%
  summarize(avg_rsdr=-20*log10(mean(rel_error)), avg_gain=avg_rsdr-mean(snr), time=mean(time)) %>%
  write.csv("tables/kpsvd_errors.csv")

## Results from splr
identmeas_df %>%
  filter(hsisolver == 'splrsolve') %>%
  group_by(solve_rank) %>%
  summarize(avg_rsdr=-20*log10(mean(rel_error)), avg_gain=avg_rsdr-mean(snr), time=mean(time)) %>%
  write.csv("tables/splr_errors.csv")
