import cvxpy
import itertools
import selfcalib_experiment as exp
from operfact import utils
from operfact import regularizers as regs

# 2D signals
klist = [i+1 for i in range(5)]
nlist = [i+1 for i in range(5)]
params_2d = []
for (k, n) in itertools.product(klist, nlist):
    params = exp.PARAMS.copy()
    params['L'] = 2048
    params['N'] = 64
    params['M'] = 64
    params['signal_is_2d'] = True
    params['ndyads'] = 1
    params['generate_fn'] = exp.lowrank_signal
    params['reg'] = regs.NucNorm_Prod(regs.norm_l2, regs.norm_s1)
    params['snr'] = 15.0
    params['penconst_offset'] = [-2, -1, 0, 1]
    params['solve_rank'] = [1, ]
    params['inner_solver'] = cvxpy.SCS
    params['relconvergetol'] = 1e-3
    params['max_outer_iters'] = 10
    # Variable
    params['k'] = k
    params['n'] = n
    # Append
    params_2d.append(params)

# Mixtures


## Run the experiments
if __name__ == '__main__':
    NPROCS = 12
    NTRIALS = 10
    SEED = None

    fieldnames = list(exp.ROW.keys())

    print('Starting {0}, {1} jobs'.format('2d', len(params_2d)*NTRIALS))
    rows = utils.experiment_csv('selfcalib_2d.csv.gz', fieldnames, exp.solve_problem, params_2d,
                                ntrials=NTRIALS, nprocs=NPROCS, seed=SEED, return_rows=False)
