library(ggplot2)
library(dplyr)
library(broom)
library(stringr)

## Load the data
selfcalib_2d <- tbl_df(read.csv("selfcalib_2d.csv.gz"))

## Summarize the data
selfcalib_2d.summarized <- selfcalib_2d %>%
  group_by(L, N, k, n, M, snr, reg, outer_solver, inner_solver,
           solve_rank, relconvergetol, max_outer_iters, penconst_offset) %>%
  summarize(mean_error=mean(rel_error), success=mean(rsdr > snr), maxouteriters=max(outer_iters))

## For each group, choose the empirically best penconst_offset
selfcalib_2d.bestsuccess <- selfcalib_2d.summarized %>%
  filter(row_number(desc(success)) == 1)

## Generate Figure 7.5
selfcalib_2d.bestsuccess %>%
  filter(solve_rank == 1) %>%
  ggplot(aes(x=n, y=k)) +
  geom_raster(hjust=0, vjust=0, aes(fill=success*100), interpolate=FALSE) +
  scale_fill_gradient(limits=c(0,100), low="black", high="white") +
  coord_cartesian(xlim=c(0,5), ylim=c(0,5)) +
  labs(x = 'r: rank(Y)', y = 'm: length of x', fill = 'success (%)') +
  theme_bw() +
  theme(aspect.ratio=1, text = element_text(size=10))
ggsave('figures/2d.pdf', width=3, height=2.5, units='in', scale=1.5, device=cairo_pdf)
