import cvxpy
import itertools
import numpy as np
import selfcalib_experiment as exp
from operfact import utils
from operfact import regularizers as regs

# Multiple snapshots
klist = [i+1 for i in range(15)]
nlist = [i+1 for i in range(15)]
Mlist = [8, ]
genlist = [exp.sparse_nonidentical, exp.sparse_identical_entries, exp.sparse_identical_locs]
reglist = [regs.NucNorm_Prod(regs.norm_l2, regs.norm_l1),
           regs.NucNorm_Prod(regs.norm_l2, regs.norm_l1l2),
           regs.NucNorm_Prod(regs.norm_l2, regs.norm_l1linf)]
params_new = []
for (k, n, M, genfn, reg) in itertools.product(klist, nlist, Mlist, genlist, reglist):
    params = exp.PARAMS.copy()
    params['L'] = 128
    params['N'] = 256
    params['signal_is_2d'] = False
    params['ndyads'] = 1
    params['snr'] = 15.0
    params['penconst_offset'] = [-4, -3, -2, -1, 0]
    params['solve_rank'] = [4,]
    params['inner_solver'] = cvxpy.SCS
    params['relconvergetol'] = 1e-3
    params['max_outer_iters'] = 10
    # Variable
    params['k'] = k
    params['n'] = n
    params['M'] = M
    params['generate_fn'] = genfn
    params['reg'] = reg
    # Append
    params_new.append(params)

Mlist = [2, 4]
genlist = [exp.sparse_nonidentical, ]
reglist = [regs.NucNorm_Prod(regs.norm_l2, regs.norm_l1), ]
for (k, n, M, genfn, reg) in itertools.product(klist, nlist, Mlist, genlist, reglist):
    params = exp.PARAMS.copy()
    params['L'] = 128
    params['N'] = 256
    params['signal_is_2d'] = False
    params['ndyads'] = 1
    params['snr'] = 15.0
    params['penconst_offset'] = [-4, -3, -2, -1, 0]
    params['solve_rank'] = [4,]
    params['inner_solver'] = cvxpy.SCS
    params['relconvergetol'] = 1e-3
    params['max_outer_iters'] = 10
    # Variable
    params['k'] = k
    params['n'] = n
    params['M'] = M
    params['generate_fn'] = genfn
    params['reg'] = reg
    # Append
    params_new.append(params)

Mlist = [2, 4]
genlist = [exp.sparse_identical_entries, ]
reglist = [regs.NucNorm_Prod(regs.norm_l2, regs.norm_l1linf), ]
for (k, n, M, genfn, reg) in itertools.product(klist, nlist, Mlist, genlist, reglist):
    params = exp.PARAMS.copy()
    params['L'] = 128
    params['N'] = 256
    params['signal_is_2d'] = False
    params['ndyads'] = 1
    params['snr'] = 15.0
    params['penconst_offset'] = [-4, -3, -2, -1, 0]
    params['solve_rank'] = [4,]
    params['inner_solver'] = cvxpy.SCS
    params['relconvergetol'] = 1e-3
    params['max_outer_iters'] = 10
    # Variable
    params['k'] = k
    params['n'] = n
    params['M'] = M
    params['generate_fn'] = genfn
    params['reg'] = reg
    # Append
    params_new.append(params)

Mlist = [2, 4]
genlist = [exp.sparse_identical_locs, ]
reglist = [regs.NucNorm_Prod(regs.norm_l2, regs.norm_l1l2), ]
for (k, n, M, genfn, reg) in itertools.product(klist, nlist, Mlist, genlist, reglist):
    params = exp.PARAMS.copy()
    params['L'] = 128
    params['N'] = 256
    params['signal_is_2d'] = False
    params['ndyads'] = 1
    params['snr'] = 15.0
    params['penconst_offset'] = [-4, -3, -2, -1, 0]
    params['solve_rank'] = [4,]
    params['inner_solver'] = cvxpy.SCS
    params['relconvergetol'] = 1e-3
    params['max_outer_iters'] = 10
    # Variable
    params['k'] = k
    params['n'] = n
    params['M'] = M
    params['generate_fn'] = genfn
    params['reg'] = reg
    # Append
    params_new.append(params)

## Run the experiments
if __name__ == '__main__':
    NPROCS = 12
    NTRIALS = 10
    SEED = None

    fieldnames = list(exp.ROW.keys())

    print('Starting {0}, {1} jobs'.format('multiple', len(params_new) * NTRIALS))
    rows = utils.experiment_csv('selfcalib_multiple.csv.gz', fieldnames, exp.solve_problem, params_new,
                                ntrials=NTRIALS, nprocs=NPROCS, seed=np.Inf, return_rows=False)
