import cvxpy
import itertools
import selfcalib_experiment as exp
from operfact import utils
from operfact import regularizers as regs

# Single snapshot results
klist = [i+1 for i in range(15)]
nlist = [i+1 for i in range(15)]
reglist = [regs.NucNorm_Prod(regs.norm_l1, regs.norm_l1),
           regs.NucNorm_Prod(regs.norm_l2, regs.norm_l1)]
for reg in reglist:
    reg.norm_mat = None
params_single = []
for (k, n, reg) in itertools.product(klist, nlist, reglist):
    params = exp.PARAMS.copy()
    params['L'] = 128
    params['N'] = 256
    params['M'] = 1
    params['signal_is_2d'] = False
    params['ndyads'] = 1
    params['generate_fn'] = exp.sparse_signal
    params['snr'] = 15.0
    params['penconst_offset'] = [-2, -1, 0, 1]
    params['solve_rank'] = [1, 2, 4, 16]
    params['inner_solver'] = cvxpy.SCS
    params['relconvergetol'] = 1e-3
    params['max_outer_iters'] = 10
    # Variable
    params['k'] = k
    params['n'] = n
    params['reg'] = reg
    # Append
    params_single.append(params)


## Run the experiments
if __name__ == '__main__':
    NPROCS = 12
    NTRIALS = 10
    SEED = None

    fieldnames = list(exp.ROW.keys())

    print('Starting {0}, {1} jobs'.format('single_altmin', len(params_single)*NTRIALS))
    rows = utils.experiment_csv('selfcalib_single_altmin.csv.gz', fieldnames, exp.solve_problem, params_single,
                                ntrials=NTRIALS, nprocs=NPROCS, seed=SEED, return_rows=False)
