import cvxpy
import itertools
import numpy as np
import selfcalib_experiment as exp
from operfact import utils
from operfact import regularizers as regs

# Single snapshot results
snrlist = [np.Inf, ]
klist = [i+1 for i in range(15)]
nlist = [i+1 for i in range(15)]
reglist = [regs.NucNorm_Prod(regs.norm_l1, regs.norm_l1),
           regs.NucNorm_Prod(regs.norm_l2, regs.norm_l1)]
for reg in reglist:
    reg.norm_altmin = None
params_single = []
for (snr, k, n, reg) in itertools.product(snrlist, klist, nlist, reglist):
    params = exp.PARAMS.copy()
    params['L'] = 128
    params['N'] = 256
    params['M'] = 1
    params['signal_is_2d'] = False
    params['ndyads'] = 1
    params['generate_fn'] = exp.sparse_signal
    params['penconst_offset'] = [np.Inf, ]
    params['solve_rank'] = [2, ]
    params['inner_solver'] = cvxpy.SCS
    params['relconvergetol'] = 1e-3
    params['max_outer_iters'] = 10
    # Variable
    params['snr'] = snr
    params['k'] = k
    params['n'] = n
    params['reg'] = reg
    # Append
    params_single.append(params)

## Run the experiments
if __name__ == '__main__':
    NPROCS = 12
    NTRIALS = 10
    SEED = None

    fieldnames = list(exp.ROW.keys())

    print('Starting {0}, {1} jobs'.format('single_matnoiseless', len(params_single)*NTRIALS))
    rows = utils.experiment_csv('selfcalib_single_matnoiseless.csv.gz', fieldnames, exp.solve_problem, params_single,
                                ntrials=NTRIALS, nprocs=NPROCS, seed=SEED, return_rows=False)
