--------------------------- MODULE StepComparison ------------------------------
(* Comparison of the strictly causal and causal controllable step operators.


Author:  Ioannis Filippidis

--------------------------------------------------------------------------------
Copyright 2016-2017 by California Institute of Technology.
All rights reserved. Licensed under 3-clause BSD.
*)
CONSTANT SysNext(_, _, _), EnvNext(_, _, _), Target(_, _)


(* SysNext by syntax is independent of u, so of x' *)
Step(x, y) ==
    \E v:  \A u:
        /\ SysNext(x, y, v)
        /\ EnvNext(x, y, u) => Target(u, v)

StepU(x, y) ==
    \E v:  \A u:
        EnvNext(x, y, u) => /\ SysNext(x, y, v)
                            /\ Target(u, v)


THEOREM
    ASSUME
        VARIABLE x, VARIABLE y
    PROVE
        Step(x, y) <=> /\ \E v:  SysNext(x, y, v)
                       /\ StepU(x, y)
    BY DEF Step, StepU


(* Detailed proof because it is instructive. *)
THEOREM SameThmWithDetailedProof ==
    ASSUME
        VARIABLE x, VARIABLE y
    PROVE
        Step(x, y) <=> /\ \E v:  SysNext(x, y, v)
                       /\ StepU(x, y)
PROOF
    <1> DEFINE
        A(u, v) ==
            /\ SysNext(x, y, v)
            /\ EnvNext(x, y, u) => Target(u, v)
        B(u, v) ==
            /\ SysNext(x, y, v)
            /\ EnvNext(x, y, u) => /\ SysNext(x, y, v)
                                   /\ Target(u, v)
        F == \E v:  \A u:  B(u, v)
        EnabledEnv == \E u:  EnvNext(x, y, u)
        EnabledSys == \E v:  SysNext(x, y, v)
    <1>1. /\ F <=> \E v:  \A u:  B(u, v)
          /\ Step(x, y) <=> \E v:  \A u:  A(u, v)
          BY DEF A, B, F, Step
    <1>2. Step(x, y) <=> F
        <2>1. SUFFICES ASSUME NEW u, NEW v
                       PROVE A(u, v) <=> B(u, v)
            BY <2>1, <1>1
        <2> QED
            BY DEF A, B
    <1>3. Step(x, y) <=>
            \E v:  /\ SysNext(x, y, v)
                   /\ \A u:  EnvNext(x, y, u) => /\ SysNext(x, y, v)
                                                 /\ Target(u, v)
        BY <1>2 DEF F
    <1>4. Step(x, y) => /\ EnabledSys
                        /\ StepU(x, y)
        <2>1. Step(x, y) => \E v:  SysNext(x, y, v)
            BY <1>3
        <2>2. Step(x, y) => StepU(x, y)
            BY <1>3 DEF StepU
        <2> QED
            BY <2>1, <2>2 DEF EnabledSys
    <1>5. (EnabledSys /\ StepU(x, y)) => Step(x, y)
        <2>1. CASE ~ EnabledEnv
            <3>1. EnabledSys => \E v:  /\ SysNext(x, y, v)
                BY DEF EnabledSys
            <3>2. \A v:  \A u:  EnvNext(x, y, u) => /\ SysNext(x, y, v)
                                                    /\ Target(u, v)
                BY <2>1
            <3>3. EnabledSys =>
                \E v:  /\ SysNext(x, y, v)
                       /\ \A u:  EnvNext(x, y, u) => /\ SysNext(x, y, v)
                                                     /\ Target(u, v)
                BY <3>1, <3>2
            <3> QED
                BY <3>3, <1>3
        <2>2. CASE EnabledEnv
            <3>1. SUFFICES ASSUME EnabledSys /\ StepU(x, y)
                           PROVE Step(x, y)
                OBVIOUS
            <3>2. PICK v:  \A u:  EnvNext(x, y, u) => /\ SysNext(x, y, v)
                                                      /\ Target(u, v)
                BY <3>1 DEF StepU
            <3>3. SysNext(x, y, v)
                <4>1. PICK r:  EnvNext(x, y, r)
                    BY <2>2 DEF EnabledEnv
                <4>2. EnvNext(x, y, r) => SysNext(x, y, v)
                    BY <3>2
                <4> QED
                    BY <4>1, <4>2
            <3> QED
                BY <3>2, <3>3 DEF Step
        <2> QED
            BY <2>1, <2>2
    <1> QED
        BY <1>4, <1>5


(* EnvNext here depends on y' *)
THEOREM
    ASSUME
        CONSTANT EnvNextR(_, _, _, _),
        VARIABLE x, VARIABLE y
    PROVE
        LET
            StepR(x, y) == \E v:  \A u:
                /\ SysNext(x, y, v)
                /\ EnvNextR(x, y, u, v) => Target(u, v)
            StepUR(x, y) == \E v:  \A u:
                EnvNextR(x, y, u, v)
                    => /\ SysNext(x, y, v)
                       /\ Target(u, v)
        IN
            StepR(x, y) <=> /\ \E v:  SysNext(x, y, v)
                            /\ StepUR(x, y)
================================================================================
