------------------------- MODULE TemporalQuantification ------------------------
(* Proof rules for temporal quantifiers \EE, \AA in TLA+.


References
==========

[1] L. Lamport, The temporal logic of actions, TOPLAS, 1994
    10.1145/177492.177726

[2] L. Lamport, Specifying systems, Addison-Wesley, 2002

--------------------------------------------------------------------------------
Copyright 2016-2017 by California Institute of Technology.
All rights reserved. Licensed under 3-clause BSD.
*)
EXTENDS Naturals, NaturalsInduction, TLASemantics


(* Proof rule E1 from [1, Fig.9 on p.905]. *)
THEOREM RuleE1 ==
    ASSUME
        TEMPORAL F(_),
        STATE f
    PROVE
        F(f)  =>  (\EE x:  F(x))

--------------------------------------------------------------------------------
(* Proof rule (schema) for instantiating universal temporal quantification. *)

THEOREM InstantiateAA ==
    ASSUME
        TEMPORAL F(_),
        STATE f
    PROVE
        (\AA x:  F(x))  =>  F(f)
    PROOF
    <1>1. SUFFICES
            ASSUME
                ~ ((\AA x:  F(x))  =>  F(f))
            PROVE
                FALSE
        OBVIOUS
    <1>2. /\ \AA x:  F(x)
          /\ ~ F(f)
        BY <1>1
    <1>3. ~ \EE x:  ~ F(x)
        <2>1. \AA x:  F(x)
            BY <1>2
        <2> QED
            BY <2>1 DEF \AA  (* \AA x:  P == ~ (\EE x: ~ P) [2, p.315] *)
    <1>4. \EE x:  ~ F(x)
        <2>1. ~ F(f)
            BY <1>2
        <2>2. (~ F(f))  =>  \EE x:  ~ F(x)
            BY RuleE1
        <2> QED
            BY <2>1, <2>2
    <1> QED
        BY <1>3, <1>4

--------------------------------------------------------------------------------

THEOREM UniversalClosure ==
    ASSUME
        TEMPORAL G(_),
        ASSUME VARIABLE x
        PROVE G(x)
    PROVE
        \AA u:  G(u)
    PROOF
    <1>1. SUFFICES ~ \EE u:  ~ G(u)
        BY <1>1 DEF \AA
    <1>2. SUFFICES
            ASSUME \EE u:  ~ G(u)
            PROVE FALSE
        OBVIOUS  (* goal from <1>1 *)
    <1>3. ASSUME VARIABLE u
          PROVE G(u)
        OBVIOUS  (* BY UniversalClosure!assumption *)
    <1>4. \EE u:  G(u) /\ ~ G(u)
        BY <1>2, <1>3
    <1>5. \EE u:  FALSE
        BY <1>4
    <1> QED
        BY <1>5

================================================================================
