%% Calibration - Correction demo on tetR repression data
% April 22, 2018 
% Vipul Singhal, CIT
% The data plotted here was generated by the .m script:
% /Users/vipulsinghal/Dropbox/Documents/vipul_repo/mcmc/code_mcmc/examples
% /test015_tetRdata_simpleModel/main_v1.m
% 
% As always, the posterior distributions were stored in .mat files with
% names of the sort 't015_calib_yyyymmdd_HHMMSS_#_MBP'. 
% 
% This file differs from its parent file plot_main_v1.m in that it picks
% the ESPs for the reference extract by first fixing the CSPs in the 
% constitutive model.
% Because the CSPs for the tetR model (correction circuit) have already
% been estimated, and at least for this file we want to avoid reestimating
% those, we do the following: 
% 
% First note that the calib step, candidate extract (extract # 3, eSG, in the
% calibration step) paramters were estimated, and the median ESP values
% were fixed. The dataset used was 't015_calib_20171023_151627_5_MBP'
% and the median values computed were kc_calib = -0.28209, P_calib = 1.3714
% 
% Then, with these values fixed, correction step 1 was performed. 
% 
% For correction step 2, instead of taking median values in the reference
% extract, it is better (maybe) to get ESP values which share CSPs with the
% candidate ESP values. 
%
% We do all this here. 
%

% First load the ESPs that share a common CSP
load('t015_calib_20171023_151627_5_MBP', 'm')
mstacked = m(:,:)';
medn = median(mstacked);
kc_calib3 = medn(5) %use medians
P_calib3 = medn(6) %use medians

%%

% the corresponding CSPs are: 
tol = 0.044; % 0.04377298...

bb = intersect(find(mstacked(:, 6)>P_calib3-tol),...
    find(mstacked(:, 6)<P_calib3+tol));
aa = intersect(find(mstacked(:, 5)>kc_calib3-tol),...
    find(mstacked(:, 5)<kc_calib3+tol));
cc = intersect(aa, bb);
% exp(mstacked(cc(1), :))
commoncalib = mstacked(cc(1), :)

% Ok, so now in calib step 2, instead of using medians for extract 1, we
% use commoncalib([1, 2])

%%
% The test circuit (Correction Step)
% We start with a circuit description
% tetR_repression: tet repression model, single step, first 3 hours. 
% D_T + P <-> D_T:P -> D_T + P + T
% D_G + P <-> D_G:P -> D_G + P + G
% 2 T <-> T2
% D_G + T2 <-> D_G:T2
corr_SD2 = {    't015_corr1_20171023_151627_11_MBP'
    't015_corr1_20171023_151627_12_MBP'
    't015_corr1_20171023_151627_13_MBP'
    't015_corr1_20171023_151627_14_MBP'
    't015_corr1_20171023_151627_15_MBP'
    't015_corr1_20171023_151627_16_MBP'
    't015_corr1_20171023_151627_17_MBP'}
nW = 600;
legends = {'kfPT'    'krPT'  'kfPG'    'krPG'   'kfdim' ...
    'krdim', 'kfrep', 'krrep'};

mcat_converged= catMC(corr_SD2);
plotChains(mcat_converged(:,1:30:end, :), nW, legends );
figure
 ecornerplot_vse(mcat_converged(:,:, 1:10:end),...
    'scatter', true,'transparency',0.25, 'color',[.6 .35 .3], ...
    'names', legends);

 ecornerplot_vse(mcat_converged(:,:, 1:10:end),...
    'scatter', false, 'color',[.6 .35 .3], ...
    'names', legends);
%% 
% Next we create the correction demo figure. This figure is arranged into 3
% columns and nICs number of rows. Each row corresponds to one dose
% (initial condition). Within each row, the subplot corresponding to the first
% column has the test circuit behavior in the two environments of interest, 
% the candidate environment eSG and the reference environment (eVS). The
% second column has the same two trajectories, bu in addition has the model
% fit to the candidate environment data. The third column has the
% 'corrected' behavior, along with the two data trajectories. 

envrefID = 1; % can be changed to 2 to generate the correction from 3 to 2. 
envcandID = 3; 

m_rearranged = mcat_converged(:,:)';
nptstotal = size(m_rearranged, 1);
npts = 500;
paramid = randperm(nptstotal, npts);
params_to_use_corr = m_rearranged(paramid, :);
envname = {'VS', 'MP', 'SG'};
load(  't015_corr1_20171023_151627_11_MBP', 'tvec', 'nW', 'model_corr',...
    'dosevals_corr','dosemap_corr', 'correction_data', 'pmap_corr',...
    'nSp_corr', 'idMS_corr' )

nMS = size(correction_data, 2); % nMS = 1 here, since only GFP is measured
nICs = size(dosevals_corr,2); % ICs, tetR DNA = [0 0.25 0.5 0.75 1 2 5 10] (nM)

nEnv_total = size(correction_data, 4); 
% the total number of environments for which we have data. 

nEnv_used = 2; 
% the number of environments considered to demonstrate the correction procedure.

nEnv_estimated = 1; 
% the number of environments on which the parameter estimation was performed. 

espIX = pmap_corr{1};
esspIX = pmap_corr{2};
cspIX = pmap_corr{3};

nESP = length(espIX); % the ESP indices in the model (not in logpjoint)
nESSP = length(esspIX);
% the Env specific species indices in the model (not in logpjoint)
nCSP = length(cspIX); % the CSP indices in the model (not in logpjoint)

icvec = zeros(nSp_corr, 1);

%%
% we will have 2 sets of simulated trajectories, one for the candidate env
% and one for the reference. Therefore, the number of environments used is
% nEnv_used (= 2). 
simulatedtraj_corrstep1 = zeros(length(tvec(1:13)),nMS, nICs , npts); 
simulatedtraj_corrstep2 = zeros(length(tvec(1:13)),nMS, nICs , npts);
%%
% simulate the correction model for all the randomly picked points from
% the posterior distribution, fixing the ESPs and ESSPs to the candidate
% environments values. 
for kk = 1:npts
    logpjoint_corr1 = [kc_calib3 P_calib3 params_to_use_corr(kk, :)];
    cspindices = ((nESSP + nESP)*nEnv_estimated+1):length(logpjoint_corr1);
    paramvec = zeros(nESP+nCSP, 1);
    logpcsp = logpjoint_corr1(cspindices);
    paramvec(cspIX) = logpcsp;
    logpesp = logpjoint_corr1(1:nESP);
    paramvec(espIX) = logpesp;
    esspindices = (nESP + 1):(nESP+nESSP);
    
    % set the values of the initial condition vector to the parameters
    icvec(esspIX) = exp(logpjoint_corr1(esspindices));
    
    for doseID = 1:nICs
        icvec(dosemap_corr) = dosevals_corr(:, doseID);
        % simulate the model
        [~, simudata] = model_corr(paramvec, icvec, tvec(1:13));
        for msid = 1:nMS
            simulatedtraj_corrstep1(:,msid, doseID, kk) =...
                simudata(:, idMS_corr(msid));
        end
    end
end

%%
% Compute the mean and standard deviations for correction step 1
meanvals_corrstep1 = mean(simulatedtraj_corrstep1, 4); 
sdvals_corrstep1= std(simulatedtraj_corrstep1,0, 4);
maxvals_corrstep1 = squeeze(max(max(max(meanvals_corrstep1+sdvals_corrstep1,...
    [], 1), [], 3), [], 5)); % 1 by nMS array. 
%%
% Also, simulate the trajectories in the reference environment. here we
% randomly mix and match points from the reference environments environment
% specific parameters and species, and the CSP from correction step 1. 


% THIS IS THE MAIN LINE THAT IS CHANGED from plot_main_v1
% refmedians = ...
%     medians_converged_calib(((envrefID-1)*(nESSP + nESP)+1):
% (envrefID*(nESSP + nESP)));

% CHANGED TO THIS:
refmedians = ...
    commoncalib(((envrefID-1)*(nESSP + nESP)+1):(envrefID*(nESSP + nESP)));


% other option: params_to_use_calib(kk, ((envrefID-1)*(nESSP + nESP)+1):
% (envrefID*(nESSP + nESP))), though this is a
% bit buggy tight now
for kk = 1:npts
    logpjoint_corrstep2 = [refmedians  params_to_use_corr(kk, :)];
    cspindices = ((nESSP + nESP)+1):length(logpjoint_corrstep2);
    paramvec = zeros(nESP+nCSP, 1);
    logpcsp = logpjoint_corrstep2(cspindices);
    paramvec(cspIX) = logpcsp;
        logpesp = logpjoint_corrstep2(1:nESP);
        paramvec(espIX) = logpesp;
        esspindices = (nESP + 1):(nESP+nESSP);
        
        % set the values of the initial condition vector to the parameters
        icvec(esspIX) = exp(logpjoint_corrstep2(esspindices));
        
        for doseID = 1:nICs
            icvec(dosemap_corr) = dosevals_corr(:, doseID);
            
            % simulate the model
            [~, simudata] = model_corr(paramvec, icvec, tvec(1:13));
            for msid = 1:nMS
                simulatedtraj_corrstep2(:,msid, doseID, kk) =...
                    simudata(:, idMS_corr(msid));
            end
        end
    
end


%%
% Compute the mean and standard deviations for correction step 1
meanvals_corrstep2 = mean(simulatedtraj_corrstep2, 4); 
sdvals_corrstep2= std(simulatedtraj_corrstep2,0, 4);
maxvals_corrstep2 = squeeze(max(max(max(meanvals_corrstep2+sdvals_corrstep2,...
    [], 1), [], 3), [], 5)); % 1 by nMS array. 

%% 
% compute the max of the axis jointly for corrstep 1 and 2. 
maxvals_corr = max([maxvals_corrstep1; maxvals_corrstep2], [], 1);

%%
% Inialize arrays for handles to the graphics objects. 
lineStyles = linspecer(2*nICs,'sequential');
hd_cand = zeros(nICs, 3); % data trajectory handles for candidate environment
hd_ref = zeros(nICs, 3); % data trajectory handles for reference environment
hm_cand = zeros(nICs, 1); % model fit mean trajectory handles
hsd_cand = zeros(nICs, 1); % model fit sd trajectory handles (patch objects)
hm_ref = zeros(nICs, 1); % model prediction mean trajectory handles
hsd_ref = zeros(nICs, 1); % model prediction sd trajectory handles (patch objects)

%% 
% create the 3 column subplot 
nICs = 4
for msid = 1:nMS
    maxvals_corr(msid) = 1500
    figure
    ss = get(0, 'screensize');
    set(gcf, 'Position', [50 100 ss(3)/1.2 ss(4)/1.2]);
    
% for each initial condition row
    for i = 1:nICs
        % column 1: just the experimental data
        linearidx = 3*(i-1)+1;
        subplot(nICs, 3,linearidx);
        
        hd_ref(i, 1)=plot(tvec(1:13)/3600,1000*correction_data(1:13,msid, i,...
            envrefID),'color',lineStyles(i, :) ,'linewidth',0.8);
        hold on
        hd_cand(i, 1)=plot(tvec(1:13)/3600,1000*correction_data(1:13,msid, i,...
            envcandID ),'color',lineStyles(nICs+i, :) ,'linewidth',0.8);
        hold on
        set(gca, 'Ylim', [0, round(maxvals_corr(msid))])
        set(gca, 'Xlim', [0, 1.6])
        title(sprintf('Experimental data, tetR DNA = %0.2g',...
            dosevals_corr(2, i)), 'FontSize', 12)
        xlabel('time, hours')
        ylabel('GFP, nM')
        legend([hd_ref(i, 1), hd_cand(i, 1)], {'Reference Extract',...
            'Candidate Extract'}, 'Location', 'NorthWest')
        
        % column 2: overlay correction step 1 fit (CSP estimation)
        linearidx = 3*(i-1)+2;
        subplot(nICs, 3,linearidx);
        hd_ref(i, 2)=plot(tvec(1:13)/3600,1000*correction_data(1:13,msid, i,...
            envrefID),'color',lineStyles(i, :) ,'linewidth',0.8);
        hold on
        hd_cand(i, 2)=plot(tvec(1:13)/3600,1000*correction_data(1:13,msid, i,...
            envcandID ),'color',lineStyles(nICs+i, :) ,'linewidth',0.8);
        hold on
        [hm_cand(i), hsd_cand(i)] = boundedline(tvec(1:13)/3600, ...
            meanvals_corrstep1(:, msid, i, 1), sdvals_corrstep1(:, msid, i, 1));
        set(hsd_cand(i), 'FaceColor', lineStyles(nICs+i, :).^4, 'FaceAlpha', 0.1);
        set(hm_cand(i), 'Color', lineStyles(nICs+i, :).^4, 'LineStyle', ':');
        hold on
        set(hm_cand(i), 'LineWidth', 1)
        set(gca, 'Ylim', [0, round(maxvals_corr(msid))])
        set(gca, 'Xlim', [0, 1.6])
        title(sprintf('Correction Step 1, tetR DNA = %0.2g', dosevals_corr(2, i)),...
            'FontSize', 12)
        xlabel('time, hours')
        legend([hd_ref(i, 2), hd_cand(i, 2), hm_cand(i)], ...
            {'Reference Extract', 'Candidate Extract', 'Model Fit (mean, sd)'},...
            'Location', 'NorthWest')
%         ylabel('GFP, nM')
        
        % column 3: overlay correction step 2 prediction istead of
        % correction step 1 fit. ("corrected behavior")
        linearidx = 3*(i-1)+3;
        subplot(nICs, 3,linearidx);
        hd_ref(i, 3)=plot(tvec(1:13)/3600,1000*correction_data(1:13,msid, i,...
            envrefID),'color',lineStyles(i, :) ,'linewidth',0.8);
        hold on
        hd_cand(i, 3)=plot(tvec(1:13)/3600,1000*correction_data(1:13,msid,...
            i,envcandID ),'color',lineStyles(nICs+i, :) ,'linewidth',0.8);
        hold on
        [hm_ref(i), hsd_ref(i)] = boundedline(tvec(1:13)/3600,...
            meanvals_corrstep2(:, msid, i, 1), sdvals_corrstep2(:, msid, i, 1));
        set(hsd_ref(i), 'FaceColor', lineStyles(i, :).^4, 'FaceAlpha', 0.1);
        set(hm_ref(i), 'Color', lineStyles(i, :).^4, 'LineStyle', ':');
        hold on
        set(hm_ref(i), 'LineWidth', 1)
        set(gca, 'Ylim', [0, round(maxvals_corr(msid))])
        set(gca, 'Xlim', [0, 1.6])
        title(sprintf('Correction Step 2, tetR DNA = %0.2g',...
            dosevals_corr(2, i)), 'FontSize', 12)
        xlabel('time, hours')
        legend([hd_ref(i, 3), hd_cand(i, 3), hm_ref(i)], ...
            {'Reference Extract', 'Candidate Extract',...
            '''Corrected'' Trajectories (mean, sd)'}, 'Location', 'NorthWest')
%         ylabel('GFP, nM')   

      % Compute the \% correction 
      normorig = norm(1000*correction_data(1:13,msid, i,...
          envrefID) - 1000*correction_data(1:13,msid, i,envcandID ))
      normreduced = norm(1000*correction_data(1:13,msid, i,...
          envrefID) - meanvals_corrstep2(:, msid, i, 1))

    end
end




