function [h] = plot_platereader_errorbars(d,t, Ix, titls, legs, ylab, xlab, figsz, legFnt, lablFnt, titFnt)
%plot_platereader_errorbars Plot errorbars, and explicitly specify the column indexes to plot. 
%   Ix here is a cell array containing #curves by #repeats arrays of
%   indices. 
%
% TODO: create help documentation for this, and create function defaults.
% set checks that the sizes of various inputs are compatible, especially in cell mode 
if iscell(d)
    cellmode = true;
else
    cellmode = false;
end

if ~cellmode
    nr = size(Ix, 1);
    nc = size(Ix, 2);
    h = cell(size(Ix));
    ptch = cell(size(Ix));
    currmax = zeros(nr, 1);
    % compute max limits for the Y axis
    for i = 1:nr
        for j = 1:nc
            for k = 1:size(Ix{i,j}, 1)
                means(:,k) = mean(d(:,Ix{i,j}(k,:)),2);
                stds(:,k) = std(d(:,Ix{i,j}(k,:)),0,2);
                currmax(i) = max([currmax(i) max(means(:,k)+stds(:,k))]);
            end
            
%             currmax(i) = max([currmax(i) max(max(d(:,reshape(Ix{i,j}, 1, numel(Ix{i,j})))))]);
        end
        ord = order(2*currmax(i));
        scaledval = 2*currmax(i)/10^(ord);
        currmax(i) = 0.5*10^ord*ceil(scaledval);
    end
    
    
%     currmax = currmax*1.1;
    
    
    figure('Position',figsz) %[left bottom width height].
    for i = 1:nr
        for j = 1:nc
            ind = (i-1)*nc + j; % count indexes row wise, as required by subplot.
            subplot(nr, nc, ind );
            % compute the mean curves and standard deviation curves of the
            % data
            means = zeros(length(t),size(Ix{i,j}, 1)); 
            stds =  zeros(length(t),size(Ix{i,j}, 1)); 
            for k = 1:size(Ix{i,j}, 1)
                means(:,k) = mean(d(:,Ix{i,j}(k,:)),2);
                stds(:,k) = std(d(:,Ix{i,j}(k,:)),0,2);
                [h{i, j}(k), ptch{i,j}(k)] = boundedline(t, means(:,k), stds(:,k));
                hold on
                
            end
            
            colorz = parula(length(h{i, j})+1);
            
            % set line and patch properties
            for k = 1:length(h{i, j})
                set(ptch{i,j}(k), 'FaceColor', colorz(k, :), 'FaceAlpha', 0.5);
                set(h{i, j}(k), 'Color', colorz(k, :), 'LineStyle', '-');% .^2
                hold on
                set(h{i, j}(k), 'LineWidth', 2)
            end
            
%           Set axes, titles, legends, and labels
            axx = axis;
            axis([axx(1:2),0, currmax(i)]);
            title(titls{i,j}, 'FontSize', titFnt);
            if j==1
                legend(h{i,j}, legs{i}, 'Location', 'NorthEast', 'FontSize', legFnt);
            end
            %         if j==1
            ylabel(ylab{i}, 'FontSize', lablFnt);
            %         end
            xlabel(xlab, 'FontSize', lablFnt);
            set(gca, 'FontSize', lablFnt)
            % removed suplabel because it does not scale properly with figure resizing. Should edit suplabel.
        end
    end
else
    % CELLMODE
%     First compute the subplot structure of the figure: # rows = sum(#rows
%     per cell), # columns determined using the individual cell elements.
%     (usually this will be the same in all the  rows, and really has no
%     reason to ever be different)
    nrows = 0;
    for cc = 1:length(d)
        nrows = nrows + size(Ix{cc}, 1);
    end
    
            
    figure('Position',figsz) %[left bottom width height].
    numrowsPlotted = 0; % varialble gets updated in the main for loob below. 
    
    for cc = 1:length(d) % main cell loop, here we just plot the rows of the current cell. 
        
        dc = d{cc};
        tc = t{cc};
        Ixc = Ix{cc};
        
        titlsc = titls{cc};
        legsc = legs{cc};
        ylabc = ylab{cc};
        xlabc = xlab{cc};
        
        nr = size(sIxc, 1); % this is the number of rows in this block
        nc = size(sIxc, 2);
%         cell(size(sIxc)); % !TODO deal with creating the handle later -- not sure how to do columns yet. 
        currmax = zeros(nr, 1); % each row has a max. 
        % compute max limits for the Y axis
        for i = 1:nr
            for j = 1:nc
                currmax(i) = max([currmax(i) max(max(dc(:,Ixc{i,j})))]);
            end
            ord = order(currmax(i));
            scaledval = currmax(i)/10^ord;
            currmax(i) = 10^ord*ceil(scaledval);
        end
        
        
        currmax = currmax*1.1;
        

        for i = 1:nr
            for j = 1:nc
                ind = (numrowsPlotted + i-1)*nc + j; % count indexes row wise, as required by subplot.
                subplot(nrows, nc, ind );
                h{i,j} = plot(tc, dc(:,Ixc{i,j}), 'LineWidth', 2);
                colorz = distinguishable_colors(length(h{i, j}));
                for k = 1:length(h{i, j})
                    set(h{i, j}(k), 'Color', colorz(k, :));
                end
                axx = axis;
                axis([axx(1:3), currmax(i)]);
                title(titlsc{i,j}, 'FontSize', titFnt);
                if j==nc
                    legend(h{i,j}, legsc{i}, 'Location', 'Best', 'FontSize', legFnt);
                end
                %         if j==1
                ylabel(ylabc{i}, 'FontSize', lablFnt);
                %         end
                xlabel(xlabc, 'FontSize', lablFnt);
                % removed suplabel because it does not scale properly with figure resizing. Should edit suplabel.
            end
        end
        numrowsPlotted = numrowsPlotted + nr;
    end
    
    
    
end


end

