function [h] = plot_platereader_subplots(d,t, sIx, eIx, titls, legs, ylab, xlab, figsz, legFnt, lablFnt, titFnt)
%UNTITLED3 Summary of this function goes here
%   Detailed explanation goes here
% TODO: create help documentation for this, and create function defaults.
% set checks that the sizes of various inputs are compatible, especially in cell mode
if iscell(d)
    cellmode = true;
else
    cellmode = false;
end

if ~cellmode
    nr = size(sIx, 1);
    nc = size(sIx, 2);
    h = cell(size(sIx));
    currmax = zeros(nr, 1);
    % compute max limits for the Y axis
    for i = 1:nr
        for j = 1:nc
            currmax(i) = max([currmax(i) max(max(d(:,sIx(i,j):eIx(i, j))))]);
        end
        ord = order(currmax(i));
        scaledval = currmax(i)/10^ord;
        currmax(i) = 10^ord*ceil(2*scaledval)/2;
    end
    
    
    currmax = currmax*1.1;
    
    
    figure('Position',figsz) %[left bottom width height].
    for i = 1:nr
        for j = 1:nc
            ind = (i-1)*nc + j; % count indexes row wise, as required by subplot.
            subplot(nr, nc, ind );
            
            h{i, j} = plot(t, d(:,sIx(i,j):eIx(i, j)), 'LineWidth', 2);
            %             colorz = distinguishable_colors(length(h{i, j}));
            colorz = parula(length(h{i, j})+1);
            for k = 1:length(h{i, j})
                set(h{i, j}(k), 'Color', colorz(k, :));
            end
            
            %             set(h{i, j},
            axx = axis;
            axis([axx(1:3), currmax(i)]);
            title(titls{i,j}, 'FontSize', titFnt);
            if j==1
                legend(h{i,j}, legs{i}, 'Location', 'NorthEast', 'FontSize', legFnt);
            end
            %         if j==1
            ylabel(ylab{i}, 'FontSize', lablFnt);
            %         end
            xlabel(xlab, 'FontSize', lablFnt);
            
            set(gca, 'FontSize', lablFnt)
            % removed suplabel because it does not scale properly with figure resizing. Should edit suplabel.
        end
    end
else
    % CELLMODE
    %     First compute the subplot structure of the figure: # rows = sum(#rows
    %     per cell), # columns determined using the individual cell elements.
    %     (usually this will be the same in all the  rows, and really has no
    %     reason to ever be different)
    nrows = 0;
    for cc = 1:length(d)
        nrows = nrows + size(sIx{cc}, 1);
    end
    
    
    figure('Position',figsz) %[left bottom width height].
    numrowsPlotted = 0; % varialble gets updated in the main for loob below.
    
    for cc = 1:length(d) % main cell loop, here we just plot the rows of the current cell.
        
        dc = d{cc};
        tc = t{cc};
        sIxc = sIx{cc};
        eIxc = eIx{cc};
        titlsc = titls{cc};
        legsc = legs{cc};
        ylabc = ylab{cc};
        xlabc = xlab{cc};
        
        nr = size(sIxc, 1); % this is the number of rows in this block
        nc = size(sIxc, 2);
        %         cell(size(sIxc)); % !TODO deal with creating the handle later -- not sure how to do columns yet.
        currmax = zeros(nr, 1); % each row has a max.
        % compute max limits for the Y axis
        for i = 1:nr
            for j = 1:nc
                currmax(i) = max([currmax(i) max(max(dc(:,sIxc(i,j):eIxc(i, j))))]);
            end
            ord = order(currmax(i));
            scaledval = currmax(i)/10^ord;
            currmax(i) = 10^ord*ceil(2*scaledval)/2;
        end
        
        
        currmax = currmax*1.02;
        
        
        for i = 1:nr
            for j = 1:nc
                ind = (numrowsPlotted + i-1)*nc + j; % count indexes row wise, as required by subplot.
                subplot(nrows, nc, ind );
                h{i,j} = plot(tc, dc(:,sIxc(i,j):eIxc(i, j)), 'LineWidth', 2);
%                 colorz = distinguishable_colors(length(h{i, j}));
                colorz = parula(length(h{i, j})+1);
                for k = 1:length(h{i, j})
                    set(h{i, j}(k), 'Color', colorz(k, :));
                end
                axx = axis;
                axis([axx(1:3), currmax(i)]);
                title(titlsc{i,j}, 'FontSize', titFnt);
                if j==1
                    legend(h{i,j}, legsc{i}, 'Location', 'NorthEast', 'FontSize', legFnt);
                end
                %         if j==1
                ylabel(ylabc{i}, 'FontSize', lablFnt);
                %         end
                xlabel(xlabc, 'FontSize', lablFnt);
                
                set(gca, 'FontSize', lablFnt)
                % removed suplabel because it does not scale properly with figure resizing. Should edit suplabel.
            end
        end
        numrowsPlotted = numrowsPlotted + nr;
    end
    
    
    
end


end

