function d_sp = tetR_repression( t, sp, logp)
% tetR_repression: tet repression model, single step, first 3 hours. 
% D_T + P <-> D_T:P -> D_T + P + T
% D_G + P <-> D_G:P -> D_G + P + G
% 2 T <-> T2
% D_G + T2 <-> D_G:T2

p = exp(logp);

% parameters
%ESP 
kc = p(1);

%CSP
kfPT = p(2);
krPT = p(3);
kfPG = p(4);
krPG = p(5);
kfdim =  p(6);
krdim =  p(7);
kfrep =  p(8);
krrep =  p(9);

%initial conditions
D_T = sp(1); % dosed
P =sp(2); % ESSP
D_T__P =sp(3);
D_G__P =sp(4);
T = sp(5);
D_G = sp(6); %dosed
T2 = sp(7);
D_G__T2 = sp(8);
G = sp(9);  %measured

% equations
dD_T = -kfPT*D_T*P + (krPT + kc)*D_T__P;

dP = -kfPT*D_T*P + (krPT + kc)*D_T__P -kfPG*D_G*P + ...
    (krPG + kc)*D_G__P;

dD_T__P = kfPT*D_T*P - (krPT + kc)*D_T__P;

dD_G__P = kfPG*D_G*P - (krPG + kc)*D_G__P;

dT = kc*D_T__P - 2*kfdim*T^2 + 2*krdim*T2;

dD_G = -kfPG*D_G*P + (krPG+ kc)*D_G__P - kfrep*D_G*T2 +...
    krrep*D_G__T2;

dT2 = kfdim*T^2 - krdim*T2 - kfrep*D_G*T2 + krrep*D_G__T2;

dD_G__T2 = kfrep*D_G*T2 - krrep*D_G__T2;

dG = kc*D_G__P;
% ODEs
d_sp = [dD_T; dP; dD_T__P; dD_G__P; dT; dD_G; dT2; dD_G__T2; dG];

end

