function di = data_dsg2014_full
% Dan ACS 2014 full dataset. MGaptamer, deGFP and RNA deg. 

% Copyright (c) 2018, Vipul Singhal, Caltech
% Permission is hereby granted, free of charge, to any person obtaining a copy
% of this software and associated documentation files (the "Software"), to deal
% in the Software without restriction, including without limitation the rights
% to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
% copies of the Software, and to permit persons to whom the Software is
% furnished to do so, subject to the following conditions:
%
% The above copyright notice and this permission notice shall be included in all
% copies or substantial portions of the Software.
%
% THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
% IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
% FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
% AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
% LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
% OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
% SOFTWARE.



%%
% define the doses: DNA at 0.5, 2, 5 and 20nM
dosedNames = {'GFP DNA'};
dv = [0.5, 2, 5, 20]; % dose vals of the dna in nM

% get the data and the time vector (in seconds)
[tmg, ymg, metamg] = load_ACSDSG2014('MGapt'); % y is ntimepoints x ndoses
[tgfp, ygfp, metagfp] = load_ACSDSG2014('deGFP');
[trnadeg, yrnadeg, metarnadeg] = load_ACSDSG2014('RNAdeg');
[tgfp_deriv, ygfp_deriv, metagfp_deriv] = load_ACSDSG2014('deGFP_deriv');
ygfp = ygfp(:,[2 4 5 6]);

tv = tmg;
da = zeros(length(tv), 4, 2, 1);
da(:, :, 1, 1) = ymg; % the mg aptameter data
da(:, :, 2, 1) = ygfp; % the gfp data
%%
mn = {'MG aptamer', 'deGFP'};
% final order is time x species x replicates x doses
da = permute(da, [1, 3, 4, 2]); 

dimlabels = {'time points', 'measured species', 'replicates', 'doses'};
datadescription = ...
['Data from ACSDSG 2014 \n '...
'MG aptamer as the first measured species, \n' ...
'GFP as the second measured species. Dosing at 0.5, 2, 5, 20nM'...
];

di1 = struct('dataInfo', {datadescription}, ...
			'timeVector', {tv}, ...
			'timeUnits', {'seconds'},...
			'dataArray', {da},...
			'measuredNames', {mn},...
			'dataUnits', {{'nM', 'nM'}},...
			'dimensionLabels', {dimlabels}, ...
			'dosedNames', {dosedNames},...
			'dosedVals', {dv}, ...
			'doseUnits', 'nM');
        
ygfp_deriv = ygfp_deriv(:,[2 4 5 6]);

da = zeros(length(tgfp_deriv), 4, 1, 1);
da(:, :, 1, 1) = ygfp_deriv; % the gfp data
da = permute(da, [1, 3, 4, 2]);

datadescription = ...
['Data from ACSDSG 2014, \n '...
'dGFP/dt as the measured species. Dosing at 0.5, 2, 5, 20nM'...
];

di2 = struct('dataInfo', {datadescription}, ...
			'timeVector', {tgfp_deriv}, ...
			'timeUnits', {'seconds'},...
			'dataArray', {da},...
			'measuredNames', {mn},...
			'dataUnits', {{'nM'}},...
			'dimensionLabels', {dimlabels}, ...
			'dosedNames', {dosedNames},...
			'dosedVals', {dv}, ...
			'doseUnits', 'nM');           
        
 mn = {'MG aptamer'};
dv = [37.5 75 150 200 600 700 800 900 1000];
dosedNames = {'Purified RNA'};
da = zeros(length(trnadeg), 9, 1, 1);
da = yrnadeg;
da = permute(da, [1, 3, 4, 2]); 
datadescription = ...
['Data from ACSDSG 2014, modified according to VNPRL 2011, \n '...
'MG aptamer as the measured species, \n' ...
'Purified mRNA added. Degradation of mRNA observed. '...
'Dosing: 37.5 75 150 200 600 700 800 900 1000 nM of mRNA'...
];

di3 = struct('dataInfo', {datadescription}, ...
			'timeVector', {trnadeg}, ...
			'timeUnits', {'seconds'},...
			'dataArray', {da},...
			'measuredNames', {mn},...
			'dataUnits', {{'nM'}},...
			'dimensionLabels', {dimlabels}, ...
			'dosedNames', {dosedNames},...
			'dosedVals', {dv}, ...
			'doseUnits', 'nM'); 
        
 di = [di1, di2, di3];
 
end





