function data_info
% data_info.m - Documentation file describing the data_info struct. 
% The data_info struct is a struct array containing the experimental data
% to be used in the parameter inference problem. 
% 
% Each individual element of the array (i.e., data_info(1),
% data_info(2),...) has the following fields: 
% 
% 'dataInfo': A human readable text description of the data. 
% 
% 'timeVector': vector of timepoints
% 
% 'timeUnits': units of the time Vector
% 
% 'dataArray': An array contianing the raw data that is generated by 
% simulating the data according to the mcmc_info struct. Typically has 
% dimensions corresponding to 
% timepoints x measured outputs x replicates x doses. 
% 
% 'measuredNames': A 1 x nMeasuredSpecies, where nMeasuredSpecies is the 
% number of measured species in this dataset, cell array of the strings 
% specifying which species are measured. These need not be exactly the same 
% strings as the strings used to specify the species in the model in the 
% mcmc_info.model_info.measuredSpecies field. They can be more descriptive
% or human readable. 
% 
% 'dataUnits': A 1 x number measured species cell array of units 
% corresponding to the raw data in the dataArray
%
% 'dimensionLabels': a 1 by length(size(data_info.dataArray)) cell array of 
% labels for the dimensions of the dataArray. Values are 
% {'time points', 'measured species', 'replicates', 'doses'}
% or even a 5D array: 
% {'time points', 'measured species', 'replicates', 'doses', 'extracts'} etc. 
% It is important that these labels be exactly these strings and be in the 
% correct order These are used in, for example, the function 
% mcmc_trajectories. 
% 
% 'dosedNames': A 1 x nDosedSpecies, where nDosedSpecies is the number of 
% dosed species, cell array of the strings 
% specifying which species are dosed. These need not be exactly the same 
% strings as the strings used to specify the species in the model in the 
% mcmc_info.model_info.dosedNames field. They can be more descriptive
% or human readable.  
% 
% 'dosedVals': A matrix of (numerical) dose values, of size nDosedSpecies by 
% nDoseCombinations. Here nDosedSpecies is the length of the dosedNames
% (cell) array of strings. nDoseCombinations is the number of different
% doses (initial conditions) the experiment was performed for. Each dose
% combination column vector corresponds to one experimental condition that 
% was used to set the initial values of the species
% specified in the dosedNames array, from which a data trajectory was generated.
% Thus, there is one trajectory associated with each dose combination. We
% note that in the model specification (defined in the mcmc_info struct 
% array), there must be a corresponding number of dose combinations. 
% 
% 'doseUnits': A 1 x number of dosed species cell array of strings 
% specifying the units of the dosed species. 

end

