#pragma rtGlobals=3		// Use modern global access method and strict wave access.


// Make matrix to hold recorded data from a given measurement campaign
// values will be read from input data to populate the "DMAmeasParams" wave
function makedatamatrix()
	make/o/n=(1,12) datamatrix
	setdimlabel 1,0,iScan, datamatrix
	setdimlabel 1,1,Qa_lpm, datamatrix
	setdimlabel 1,2,Qm_lpm, datamatrix
	setdimlabel 1,3,Qsh_lpm, datamatrix
	setdimlabel 1,4,Qex_lpm, datamatrix
	setdimlabel 1,5,HVset_V, datamatrix
	setdimlabel 1,6,Counts, datamatrix
	setdimlabel 1,7,tsample_s, datamatrix
	setdimlabel 1,8,Tamb_K, datamatrix
	setdimlabel 1,9,Pamb_Pa, datamatrix
	setdimlabel 1,10,dTdet_C, datamatrix
	setdimlabel 1,11,Qdet_lpm, datamatrix
end

// Make input wave to specify parameters for DMA operation
// input values will be read to the "DMAgeomParams" wave; called by dimension labels
function makeWvDMAparams2specify()
	make/o/n=6 DMAparams2specify
	setdimlabel 0,0,R1dma_m, DMAparams2specify
	setdimlabel 0,1,R2dma_m, DMAparams2specify
	setdimlabel 0,2,Ldma_m, DMAparams2specify
	setdimlabel 0,3,Leq_DMA_m, DMAparams2specify
	setdimlabel 0,4,Leq_other_m, DMAparams2specify
	setdimlabel 0,5,particleDensity_kgm3, DMAparams2specify
end

// Make input wave to specify parameters for kernel matrix calculations
// parameters called from this wave by dimension labels
function makeWvcalcresponsematrixParams()
	make/o/n=6 calcresponsematrixParams
	setdimlabel 0,0,ndias2nchanRatio, calcresponsematrixParams
	setdimlabel 0,1,ZfactorLower, calcresponsematrixParams
	setdimlabel 0,2,ZfactorUpper, calcresponsematrixParams
	setdimlabel 0,3,nSub4Kernel, calcresponsematrixParams
	setdimlabel 0,4,chargemax4Kernel, calcresponsematrixParams
	setdimlabel 0,5,extrapMeasChan, calcresponsematrixParams	// enter 1 for yes; 0 for no
	
	make/o/t/n=1 CalcTFformula		// text wave to call form of transfer function
	make/o/t/n=1 InvMethod			// text wave to call solution computation algorithm
end
//======================================================================

// Make matrix to hold equivalent pipe lengths and flow parameters to account for losses in
// system components/tubing where flow rate may differ from DMA flow rate
// (i.e., sample line splitting to different instruments)
// **Account for losses thru DMA inlet/outlet, and other components with same DMA flow rate,
//	in "DMAparams2specify" input wave
// See Wiedensohler 2012 for discussion of method of equivalent pipe length for DMA systems
//
// diffLossMatrix columns:
//	0:	effective length of device/component of system where diffusional losses occur [m]
//	1:	corresponding flow rate of aerosol through device/component/tubing [lpm]
// Create as many rows as needed
function makeDiffLossMatrix()
	make/o/n=(1,2) diffLossMatrix
	setdimlabel 0,-1,Component, diffLossMatrix
	setdimlabel 1,0,Leq_m, diffLossMatrix
	setdimlabel 1,1,Q_lpm, diffLossMatrix
end

// Make waves to hold parameters from given measurement campaign
// calculations call from these waves to use these parameters; called by dimension labels
function makeWvDMAmeasParams()
	make/o/n=10 DMAmeasParams
	setdimlabel 0,0,Qa_lpm, DMAmeasParams
	setdimlabel 0,1,Qsh_lpm, DMAmeasParams
	setdimlabel 0,2,betaDMA, DMAmeasParams
	setdimlabel 0,3,deltaDMA, DMAmeasParams
	setdimlabel 0,4,tsample_s, DMAmeasParams
	setdimlabel 0,5,dTdet_C, DMAmeasParams
	setdimlabel 0,6,Qdet_lpm, DMAmeasParams
	setdimlabel 0,7,Tamb_K, DMAmeasParams
	setdimlabel 0,8,Pamb_Pa, DMAmeasParams
	setdimlabel 0,9,particleDensity_kgm3, DMAmeasParams
end
function makeWvDMAgeomParams()
	make/o/n=7 DMAgeomParams
	setdimlabel 0,0,R1dma_m, DMAgeomParams
	setdimlabel 0,1,R2dma_m, DMAgeomParams
	setdimlabel 0,2,Ldma_m, DMAgeomParams
	setdimlabel 0,3,f_dma, DMAgeomParams
	setdimlabel 0,4,G_dma, DMAgeomParams
	setdimlabel 0,5,Leq_DMA_m, DMAgeomParams
	setdimlabel 0,6,Leq_other_m, DMAgeomParams
end
//======================================================================

// Calculate kernel matrix
// Input options and waves:
//	calcresponsematrixParams - options for kernel matrix setup
//	TFformula - string to call form of transfer function
//
// Output is kernel matrix "Kernel_inv" and Bspline knot waves
function calcresponsematrix(calcresponsematrixParams,TFformula)
	wave calcresponsematrixParams
	string TFformula
	
	// [Read channel settings from DMA setup function]
	wave ZstarChan, DstarChan, VstarChan
	nvar numchan
	nvar ZmaxDMA,ZminDMA
	duplicate/o VstarChan, VchanSet
	
	duplicate/o ZstarChan, lnZstarChan				// log-linear channel spacing
	lnZstarChan=ln(ZstarChan)
	duplicate/o DstarChan, lnDstarChan
	lnDstarChan=ln(DstarChan)
	
	// Define mobility grid for kernel integration
	// read input parameters defining kernel setup
	variable numdias2numchan_ratio,Zfactor_lower,Zfactor_upper
	variable nSub4CalcKernel,chargemax4calcKernel,extrapYorN
	numdias2numchan_ratio=calcresponsematrixParams[%ndias2nchanRatio]
	Zfactor_lower=calcresponsematrixParams[%ZfactorLower]
	Zfactor_upper=calcresponsematrixParams[%ZfactorUpper]
	nSub4CalcKernel=calcresponsematrixParams[%nSub4Kernel]
	chargemax4calcKernel=calcresponsematrixParams[%chargemax4Kernel]
	extrapYorN=calcresponsematrixParams[%extrapMeasChan]
	
	// find upper and lower mobility beyond measurement range
	variable/g numdias=ceil(numchan*numdias2numchan_ratio)
	variable/d/g dlnZstarChan,ZstarL,nZextrL,ZstarU,nZextrU
	dlnZstarChan = abs(lnZstarChan[0]-lnZstarChan[numchan-1])/(numdias-1)
	ZstarL = ZmaxDMA*Zfactor_lower
	nZextrL = Zfactor_lower==1 ? 0 : ceil((ln(ZstarL)-lnZstarChan[0])/dlnZstarChan)
	make/o/n=(nZextrL) lnZstarChanLwv; lnZstarChanLwv=lnZstarChan[0]+dlnZstarChan*(x+1)
	ZstarU = ZminDMA/Zfactor_upper
	nZextrU = Zfactor_upper==1 ? 0 : ceil((lnZstarChan[numchan-1]-ln(ZstarU))/dlnZstarChan)
	make/o/n=(nZextrU) lnZstarChanUwv
	lnZstarChanUwv=lnZstarChan[numchan-1]-dlnZstarChan*(x+1)
	concatenate/np/o {lnZstarChan,lnZstarChanLwv,lnZstarChanUwv}, lnZstarChanExtr
	sort/r lnZstarChanExtr, lnZstarChanExtr
	
	duplicate/o lnZstarChanExtr, ZstarChanExtr
	ZstarChanExtr=exp(lnZstarChanExtr)
	
	duplicate/o ZstarChanExtr, VstarChanExtr, DstarChanExtr, lnDstarChanExtr
	VstarChanExtr=VCalc_Zdma(ZstarChanExtr)
	DstarChanExtr=DpCalc_Zdma(ZstarChanExtr)
	lnDstarChanExtr=ln(DstarChanExtr)
	
	variable/g nChan,nDias
	nChan = numchan
	nDias = numdias+nZextrL+nZextrU
	
	// Set up kernel matrix for inversion:
	// define grids for discretizing kernel matrix and evaluating inversion solution
	duplicate/o lnDstarChanExtr, lnDpbin_inv
	duplicate/o lnDstarChan, lnDpbin_invmeas
	if (extrapYorN)	// extrapolate channel dimension if input "extrapYorN" set to 1
		duplicate/o ZstarChanExtr, ChanZ_inv
		duplicate/o VstarChanExtr, ChanV_inv
		duplicate/o DstarChanExtr, ChanDp_inv
	else
		duplicate/o ZstarChan, ChanZ_inv
		duplicate/o VstarChan, ChanV_inv
		duplicate/o DstarChan, ChanDp_inv
	endif
	
	variable/g mKern=numpnts(ChanZ_inv), nKern=0
	variable nSub=nSub4CalcKernel
	nvar bbeta,ddelta
	
	CalcKernel_cubicBspline(ChanZ_inv,ChanV_inv,lnDpbin_inv,nSub,bbeta,ddelta,chargemax4calcKernel,TFformula)
	wave KernelS3
	wave BsplineKnotWave, BsplineCoeffKnots_j, BsplineCoeffKnots, BsplineControlptKnots
	duplicate/o KernelS3, Kernel_inv
	
	nKern=dimsize(Kernel_inv,1)
	duplicate/o BsplineKnotWave, BsplineKnotWave_inv
	duplicate/o BsplineCoeffKnots_j, BsplineCoeffKnots_j_inv
	duplicate/o BsplineCoeffKnots, BsplineCoeffKnots_inv
	duplicate/o BsplineControlptKnots, BsplineControlptKnots_inv
end
//======================================================================

// Solve inverse problem with cubic B-spline setup
// Input options and waves [dimensions in brackets]:
//	KernelMatrix				[m x ncoeff]		kernel matrix, describing measurement collection
//	ModelDataBinning		[nDias]			binning for size distribution solution, model
//	MeasDataBinning		[m_raw]			binning for measured signals (raw data)
//	SplineCoeffKnots		[ncoeff=n+d-1]	binning for coefficients of size distribution solution
//	SplineControlptKnots	[n=nDias+2]		binning for control points of size distribution solution
//	SplineKnotWave		[n+2d]				wave of knot values needed to calulate Bsplines
//	precalcBdata			[m]					vector of [extrapolated] measured signals (raw data)
//	Buncertainties			[m]					vector of uncertainty/error values associated with
//														[extrapolated] measured signals (raw data)
//	InvSolnMethod - string to call solution computation algorithm
//
// Output:
//	dN/dlnDp [cm-3]		size distribution inverse solution(s) in "invsoln_xxx" waves
//	Dp [m]					corresponding particle diameters in "dpwave_xxx" waves
function invsoln_Bspline(Kernelmatrix,ModelDataBinning,MeasDataBinning,SplineCoeffKnots,SplineControlptKnots,SplineKnotWave,precalcBdata,Buncertainties,InvSolnMethod)
	wave Kernelmatrix,ModelDataBinning,MeasDataBinning
	wave SplineCoeffKnots,SplineControlptKnots,SplineKnotWave
	wave precalcBdata,Buncertainties
	string InvSolnMethod
	
	variable ncoeffs=dimsize(Kernelmatrix,1)
	variable nptsControl=numpnts(SplineControlptKnots)
	variable nptsModel=numpnts(ModelDataBinning)
	variable nptsmeasrange=numpnts(MeasDataBinning)
	make/o/n=(ncoeffs) invsoln_coeffs
	make/o/n=(nptsControl) invsoln_controlpts
	make/o/n=(nptsModel) invsoln_model
	make/o/n=(nptsmeasrange) invsoln_meas
	
	cSplineInv(Kernelmatrix,SplineCoeffKnots,SplineControlptKnots,SplineKnotWave,invsoln_controlpts,SplineControlptKnots,precalcBdata,Buncertainties,InvSolnMethod)
	wave invsoln_controlpts
	wave M_x=root:Packages:cSplineInv:M_x
	duplicate/o M_x, invsoln_coeffs
	cubicBspline(M_x,SplineControlptKnots,SplineKnotWave,ModelDataBinning,invsoln_model)
	wave invsoln_model
	cubicBspline(M_x,SplineControlptKnots,SplineKnotWave,MeasDataBinning,invsoln_meas)
	wave invsoln_meas
	
	duplicate/o SplineControlptKnots, dpwave_controlptdistbin
	dpwave_controlptdistbin=exp(SplineControlptKnots)
	duplicate/o ModelDataBinning, dpwave_modeldistbin
	dpwave_modeldistbin=exp(ModelDataBinning)
	duplicate/o MeasDataBinning, dpwave_measdistbin
	dpwave_measdistbin=exp(MeasDataBinning)
end
//======================================================================

// Extrapolate measured counts using exponential function; see Hagen 1983 
function extrapolateCounts_exp(ChanCounts,ChanMobility,ExtrMobility,numFitPts)
	wave ChanCounts,ChanMobility,ExtrMobility
	variable numFitPts
	
	variable nChanCounts=numpnts(ChanCounts)
	duplicate/o ChanMobility, Zk
	duplicate/o ChanCounts, Yk
	Zk=ChanMobility
	Yk=ChanCounts==0 ? 0 : ln(ChanCounts)
	matrixop/o ZkYk=Zk*Yk
	matrixop/o Zksq=Zk*Zk
	variable gamma_lo,kstart,kend
	kstart=0
	kend=numFitPts-1
	gamma_lo=(numFitPts*sum(ZkYk,kstart,kend)-sum(Zk,kstart,kend)*sum(Yk,kstart,kend))
	gamma_lo*=((sum(Zk,kstart,kend))^2-numFitPts*(sum(Zksq,kstart,kend)))^(-1)
	variable gamma_hi
	kstart=nChanCounts-numFitPts
	kend=nChanCounts-1
	gamma_hi=(numFitPts*sum(ZkYk,kstart,kend)-sum(Zk,kstart,kend)*sum(Yk,kstart,kend))
	gamma_hi*=((sum(Zk,kstart,kend))^2-numFitPts*(sum(Zksq,kstart,kend)))^(-1)
	
	duplicate/o ChanCounts, ExtrCounts
	extract/o ExtrMobility, ExtrMobility_hi, ExtrMobility/ChanMobility[nChanCounts-1]>1.01
	duplicate/o ExtrMobility_hi, ExtrCounts_hi; ExtrCounts_hi=0
	variable nExtr_hi=numpnts(ExtrCounts_hi)
	if(nExtr_hi>0)
		ExtrCounts_hi=ChanCounts[nChanCounts-1]
		ExtrCounts_hi*=exp(-gamma_hi*(ExtrMobility_hi(p)-ChanMobility[nChanCounts-1]))
		insertpoints nChanCounts,nExtr_hi,ExtrCounts
		ExtrCounts[nChanCounts,(nChanCounts+nExtr_hi-1)]=ExtrCounts_hi(p-nChanCounts)
	endif
	extract/o ExtrMobility, ExtrMobility_lo, ExtrMobility/ChanMobility[0]<0.99
	duplicate/o ExtrMobility_lo, ExtrCounts_lo; ExtrCounts_lo=0
	variable/g nExtr_lo=numpnts(ExtrCounts_lo)
	if(nExtr_lo>0)
		ExtrCounts_lo=ChanCounts[0]*exp(-gamma_lo*(ExtrMobility_lo(p)-ChanMobility[0]))
		insertpoints 0,nExtr_lo,ExtrCounts
		ExtrCounts[0,(nExtr_lo-1)]=ExtrCounts_lo(p)
	endif
end
//======================================================================