function y=RMGImport(filenam)

mu0=4*pi*1e-7;
GaussConvert=1e-4;
OerstedConvert=1e-4/mu0;
emuConvert=1e-3;
cmConvert=0.01;
gramConvert=1e-3;

fid=fopen(filenam);
datarows=textscan(fid,'%s','delimiter','\n');
fclose(fid);

y.datrows=datarows{1};
y.titlerow=y.datrows{1};
y.headerrow=y.datrows{2};
y.datarows={y.datrows{3:length(y.datrows)}};

k=1;
rem=y.titlerow;
done=0;
while done==0
   [y.titledat{k},rem]=strtok(rem,',');
   if isempty(y.titledat{k})
       done=1;
   end
   if findstr('Vol:',y.titledat{k})
       y.volume=str2num(strtok(y.titledat{k},'Vol:'));
   end
   k=k+1;
end
y.samplename=y.titledat{1};
y.sampledesc=y.titledat{2};

k=1;
done=0;
rem=y.headerrow;
while done==0
   [y.headerdat{k},rem]=strtok(rem,',');
   if isempty(y.headerdat{k})
       done=1;
   end
   if findstr('Level',y.headerdat{k})
       y.col.level=k;
   end
   if findstr('Bias',y.headerdat{k})
       y.col.bias=k;
   end
   if findstr('Spin',y.headerdat{k})
       y.col.spin=k;
   end
   if findstr('Mz ',y.headerdat{k})
       y.col.mz=k;
   end
   if findstr('Mx',y.headerdat{k})
       y.col.mx=k;
   end
   if findstr('My',y.headerdat{k})
       y.col.my=k;
   end
   if findstr('Suscep',y.headerdat{k})
       y.col.suscep=k;
   end
   if findstr('Mz/Vol',y.headerdat{k})
       y.col.mzvol=k;
   end
   if findstr('emu',y.headerdat{k})
       y.usecgs=1;
   end

   k=k+1;
end

[y.steptypes,rem]=strtok(y.datarows,',');
y.stepcol=strvcat(y.steptypes{:});
for k=1:length(y.headerdat)
   [y.datstrings{k},rem]=strtok(rem,',');
end
y.levels=str2num([y.datstrings{y.col.level}{:}]);
y.bias=str2num([y.datstrings{y.col.bias}{:}]);
y.spin=str2num([y.datstrings{y.col.spin}{:}]);
y.mz=str2num([y.datstrings{y.col.mz}{:}]);
y.mzvol=str2num([y.datstrings{y.col.mzvol}{:}]);

y.mx=y.mz*0;
y.my=y.mz*0;

if isfield(y.col,'mx')
    y.mx=str2num([y.datstrings{y.col.mx}{:}]);    
end
if isfield(y.col,'my')
    y.my=str2num([y.datstrings{y.col.my}{:}]);    
end
if isfield(y.col,'suscep')
    y.suscep=str2num([y.datstrings{y.col.suscep}{:}]);    
end

y.stepsAFmax=strmatch('AFmax',y.stepcol);
y.stepsAFz=strmatch('AFz',y.stepcol);
y.stepsAFxyz=strmatch('AF',y.stepcol,'exact');
y.stepsAF=sort(union(y.stepsAFz,y.stepsAFxyz));
y.stepsIRM=strmatch('IRM',y.stepcol);
y.stepsARM=strmatch('ARM',y.stepcol);
y.stepsRRM=strmatch('RRM',y.stepcol);
y.stepsThermal=union(strmatch('TT',y.stepcol),strmatch('TRM',y.stepcol));
y.stepsNRM=strmatch('NRM',y.stepcol);

y.treatmentTemps=298*ones(1,length(y.levels));
y.treatmentTemps(y.stepsThermal)=y.levels(y.stepsThermal);
lN2Steps=intersect(y.stepsThermal,find(y.levels==77));
y.treatmentTemps(lN2Steps)=77;

y.treatmentAFFields=zeros(1,length(y.levels));
stepsWithAF=union(y.stepsAF,y.stepsARM);
stepsWithAF=union(stepsWithAF,y.stepsRRM);
y.treatmentAFFields(stepsWithAF)=y.levels(stepsWithAF);

y.treatmentDCFields=y.bias;
y.treatmentDCFields(y.stepsIRM)=y.treatmentDCFields(y.stepsIRM)+y.levels(y.stepsIRM);

if y.usecgs
    y.treatmentAFFields=y.treatmentAFFields*GaussConvert;
    y.treatmentDCFields=y.treatmentDCFields*GaussConvert;
    y.bias=y.bias*GaussConvert;
    y.mx=y.mx*emuConvert;
    y.my=y.my*emuConvert;
    y.mz=y.mz*emuConvert;
    y.mzvol=y.mzvol*emuConvert;
end

y.mvector=[y.mx;y.my;y.mz];

