function y=RmgARMCurve(RmgData,varargin)

if nargin>1
    AFLevel=varargin{1};
else
    AFLevel=RmgAFLevelFind(RmgData);
end

mu0=4*pi*1e-7;

candidateSteps=intersect(RmgData.stepsARM,find(RmgData.treatmentAFFields==AFLevel));
candidateSteps=intersect(candidateSteps,find(RmgData.treatmentDCFields==0));

if length(candidateSteps)==0
    y.doesExist=0;
    return
end

y.doesExist=1;
stepnum=candidateSteps(end);



subsequentSteps=[stepnum+1:length(RmgData.levels)];
subsequentARM=intersect(subsequentSteps,RmgData.stepsARM);
subsequentNonARM=setdiff(subsequentSteps,subsequentARM);
firstNonARM=subsequentNonARM(1);
subsequentARM=[stepnum:firstNonARM-1];

y.ARMsteps=subsequentARM;
y.bias=RmgData.bias(subsequentARM);
y.treatmentDCFields=RmgData.treatmentDCFields(subsequentARM);
y.treatmentACField=AFLevel;
y.mvectorUnsub=RmgData.mvector(:,subsequentARM);
y.mvector=y.mvectorUnsub-repmat(y.mvectorUnsub(:,1),1,length(subsequentARM));

%y.MzInterp=fit(y.treatmentDCFields',abs(y.mvector(3,:))','linearinterp');
%y.ARMsusceptibility=y.MzInterp(1e-4)/(1e-4/mu0);
y.ARMsusceptibility=interpolate(y.treatmentDCFields,abs(y.mvector(3,:)),1e-4)/(1e-4/mu0);


candidateIRMSteps=intersect(RmgData.stepsIRM,find(RmgData.treatmentDCFields==AFLevel));
if length(candidateIRMSteps)>0
    stepnumIRM=candidateIRMSteps(end);




    y.mvectorIRM=RmgData.mvector(:,stepnumIRM)-y.mvectorUnsub(:,1);
    y.fracmags=abs(y.mvector(3,:)/y.mvectorIRM(3));
    y.ARMsusceptibilityToIRM=y.ARMsusceptibility/abs(y.mvectorIRM(3));
    y.ARMtoIRMat100uT=y.ARMsusceptibilityToIRM*(1e-4/mu0);
    y.ARMtoIRMat500uT=interpolate(y.treatmentDCFields,abs(y.mvector(3,:)),5e-4)/abs(y.mvectorIRM(3));
    y.ARMtoIRMat500uTDeviationfromTanh=y.ARMtoIRMat500uT-tanh((5e-4/mu0)*y.ARMsusceptibilityToIRM);

    %y.fracmagsinterp=fit(y.treatmentDCFields',y.fracmags','linearinterp');
    %y.fracmagsderiv=differentiate(y.fracmagsinterp,y.treatmentDCFields);
    dfields=diff(y.treatmentDCFields);
    y.derivfields=y.treatmentDCFields(1:length(dfields))+.5*dfields;
    y.fracmagsderiv=diff(y.fracmags)./dfields;
else
    y.mvectorIRM=[NaN NaN NaN];
    y.fracmags=repmat(NaN,length(y.mvector(3,:)));
    y.ARMsusceptibilityToIRM=NaN;
    y.ARMtoIRMat100uT=NaN;
    y.ARMtoIRMat500uT=NaN;
    y.ARMtoIRMat500uTDeviationfromTanh=NaN;
        dfields=diff(y.treatmentDCFields);
    y.derivfields=y.treatmentDCFields(1:length(dfields))+.5*dfields;
    y.fracmagsderiv=diff(y.mvector(3,:))./dfields;
end
