function y=RmgARMPlot(RmgData,varargin)

if nargin==1
    AFLevel=RmgAFLevelFind(RmgData);
else
    AFLevel=varargin{1};
    if AFLevel==0
        AFLevel=RmgAFLevelFind(RmgData);
    end

end

if AFLevel==0
    AFLevel=RmgAFLevelFind(RmgData);
end

if length(AFLevel)<length(RmgData)
    AFLevel=repmat(AFLevel,1,length(RmgData));
end

emuConvert=1e-3;
GaussConvert=1e-4;

chiton.ARM.treatmentDCFields=GaussConvert*[0:20];
chiton.ARM.mz=emuConvert*[1.02E-06 0.00001745 0.00003845 0.00005815 0.00007521 0.00009431 0.0001107 0.0001297 0.0001466 0.0001596 0.0001751 0.0001916 0.0002064 0.0002214 0.0002379 0.000252 0.0002652 0.0002832 0.0002941 0.0003066 0.000319];
chiton.IRM100=0.001936*emuConvert;

MS1.ARM.treatmentDCFields=GaussConvert*[0:20];
MS1.ARM.mz=emuConvert*[0.0004002,0.01099,0.02553,0.03462,0.04089,0.0456,0.04913,0.05138,0.05335,0.05458,0.05582,0.05672,0.05742,0.05808,0.05862,0.05909,0.05947,0.05977,0.06013,0.0604,0.06072];
MS1.IRM100=0.06725*emuConvert;

linecolors={'k','g','b','r','c','m','y'};
linesyms={'.','x','o','+','*','s','d','v','^','>','<'};

legendstr={};

for i=1:length(RmgData)
    ARM(i)=RmgARMCurve(RmgData(i),AFLevel(i));
    if ARM(i).doesExist
        plot(ARM(i).treatmentDCFields*1000,ARM(i).fracmags,[linecolors{mod(i,7)+1} linesyms{mod(i,11)+1} '-']);
        legendstr={legendstr{:} RmgData(i).samplename};
        hold on;
       % labelField=max(ARM(i).treatmentDCFields)*.8;
       % ARM(i).fracmagsinterp(labelField)+.05
       % text(1000*labelField,ARM(i).fracmagsinterp(labelField)+.05,RmgData(i).samplename);
    end
end

if sum([ARM.doesExist])>0
    if length(RmgData)>1
        legend(legendstr,'Location','NorthWest');
        titleSuffix='';
    else
        titleSuffix=[': ' RmgData(1).samplename];
    end
    plot(chiton.ARM.treatmentDCFields*1000,chiton.ARM.mz/chiton.IRM100,'r:');
    plot(MS1.ARM.treatmentDCFields*1000,MS1.ARM.mz/MS1.IRM100,'b:');
    xlabel ('B (mT)');
    ylabel (['f_{IRM' num2str(AFLevel(i)*1000) '}']);
    maxField=max([ARM.treatmentDCFields]);
    xlim([0 1000*maxField]);
    title(['ARM' titleSuffix]);
else
    axis off;
end