function y=RmgBackfieldPlot(RmgData)


linecolors={'k','g','b','r','c','m','y'};
linesyms={'.','x','o','+','*','s','d','v','^','>','<'};


legendstr={};

for i=1:length(RmgData)
    IRM(i)=RmgIRMBackfieldCurve(RmgData(i));
    if IRM(i).doesExist
        semilogx(IRM(i).treatmentDCFields*-1000,IRM(i).mvector(3,:),[linecolors{mod(i,7)+1} linesyms{mod(i,11)+1} '-']);
        legendstr={legendstr{:} RmgData(i).samplename};
        hold on;
    end
end

if sum([IRM.doesExist])>0
    if length(RmgData)>1
        legend(legendstr,'Location','Best');
        titleSuffix='';
    else
        titleSuffix=[': ' RmgData(1).samplename];
    end
    xlabel('-B (mT)');
    ylabel( 'emu');
    title (['Backfield IRM' titleSuffix]);
else
    axis off;
end
