function y=RmgExtractAFOfStep(RmgData,stepnum,varargin)

if stepnum+1>length(RmgData.levels)
    y.doesExist=0;
    return;
end

subtractAFMax = 1;

if nargin > 2
    if strcmp(varargin(1),'noAFMaxSubtract')
		subtractAFMax = 0;
	elseif strcmp(varargin(1),'AFMaxSubtract')
		subtractAFMax = 1;
	end
end

subsequentSteps=[stepnum+1:length(RmgData.levels)];
subsequentAF=intersect(subsequentSteps,RmgData.stepsAF);
subsequentNonAF=setdiff(subsequentSteps,subsequentAF);
firstNonAF=subsequentNonAF(1);

subsequentAFmax=intersect(subsequentSteps,RmgData.stepsAFmax);
priorAFmax=intersect([1:stepnum-1],RmgData.stepsAFmax);

if priorAFmax
    magBaselineStep=priorAFmax(length(priorAFmax));
elseif subsequentAFmax
    magBaselineStep=subsequentAFmax(1);
else
    magBaselineStep=0;
end

if magBaselineStep>0
    y.baselineVector=RmgData.mvector(:,magBaselineStep);
else
    y.baselineVector=[0 0 0];
end

y.AFSteps=[stepnum subsequentAF(1):firstNonAF-1];

if length(y.AFSteps)==0
    y.doesExist=0;
    return
end

y.doesExist=1;

y.mvectorUnsub=RmgData.mvector(:,y.AFSteps);

if subtractAFMax==1
	y.mvector=y.mvectorUnsub-repmat(y.baselineVector,1,length(y.AFSteps));
else
	y.mvector=y.mvectorUnsub;
end

y.mmag=sqrt(sum(y.mvector.^2));
y.dmmag=sqrt(sum((diff(y.mvector,1,2)).^2));
c=cumsum(y.dmmag(end:-1:1));
y.mdirectional=[c(end:-1:1) 0]+y.mmag(end);
y.mz=y.mvector(3,:);
y.mzNormalized=y.mvector(3,:)/y.mvector(3,1);
y.mmagNormalized=y.mmag/y.mmag(1);
y.mdirectionalNormalized=y.mdirectional/y.mdirectional(1);
y.treatmentAFFields=RmgData.treatmentAFFields(y.AFSteps);

y.treatmentAFFields(1)=1e-7;

dfields=diff(y.treatmentAFFields);
dlogfields=diff(log10(y.treatmentAFFields));
y.treatmentAFderivFields=y.treatmentAFFields(1:length(y.treatmentAFFields)-1)+.5*dfields;
y.log10treatmentAFderivFields=log10(y.treatmentAFFields(1:length(y.treatmentAFFields)-1))+.5*dlogfields;

%y.mzInterp=fit(y.treatmentAFFields',y.mzNormalized','linearinterp');
%y.mzlogInterp=fit(log10(y.treatmentAFFields'),y.mzNormalized','linearinterp');
%y.mzlogderiv=-differentiate(y.mzlogInterp,y.log10treatmentAFderivFields);
y.mzlogderiv=-diff(y.mzNormalized)./diff(log10(y.treatmentAFFields));

smoothSpan=double(int32(length(y.log10treatmentAFderivFields)*.03)*2+1);
%y.mzlogderivSmooth=smooth(y.mzlogderiv,smoothSpan,'rlowess');
y.mzlogderivSmooth=moving(y.mzlogderiv,smoothSpan)';

%interpFracVsField=fit(y.mzNormalized',y.treatmentAFFields','linearinterp');
%y.MDF=interpFracVsField(0.5);
y.MDF=interpolate(y.mzNormalized,y.treatmentAFFields,0.5);
y.MDFdirectional=interpolate(y.mdirectionalNormalized,y.treatmentAFFields,0.5);

y.meanlogfield=trapz(y.log10treatmentAFderivFields,y.mzlogderivSmooth.*y.log10treatmentAFderivFields)/trapz(y.log10treatmentAFderivFields,y.mzlogderivSmooth);
y.dispersion=sqrt(trapz(y.log10treatmentAFderivFields,((y.log10treatmentAFderivFields-y.meanlogfield).^2).*y.mzlogderivSmooth)/trapz(y.log10treatmentAFderivFields,y.mzlogderivSmooth));
y.skewness=trapz(y.log10treatmentAFderivFields,((y.log10treatmentAFderivFields-y.meanlogfield).^3).*y.mzlogderivSmooth)/(y.dispersion^3);

y.targetStep.steptype=RmgData.steptypes{stepnum};
y.targetStep.level=RmgData.levels(stepnum);
y.targetStep.bias=RmgData.bias(stepnum);
y.targetStep.spin=RmgData.spin(stepnum);
y.targetStep.mvector=RmgData.mvector(:,stepnum);
y.targetStep.treatmentDCField=RmgData.treatmentDCFields(stepnum);
y.targetStep.treatmentAFField=RmgData.treatmentAFFields(stepnum);
y.targetStep.treatmentTemp=RmgData.treatmentTemps(stepnum);
