function y=RmgFullerCurves(RmgData,varargin);

if nargin>1
    AFLevel=varargin{1};
else
    AFLevel=RmgAFLevelFind(RmgData);
end

if length(RmgData.stepsNRM)==0
    y.doesExist=0;
    return
end

y.doesExist=1;

y.NRM=RmgExtractAFOfStep(RmgData,RmgData.stepsNRM(1));
y.IRM=RmgSIRMCurve(RmgData);
y.ARMCurve=RmgARMCurve(RmgData,AFLevel);

y.doesExist=y.doesExist*y.IRM.doesExist*y.ARMCurve.doesExist;
if y.doesExist==0
    return;
end

y.ARM=RmgExtractAFOfStep(RmgData,y.ARMCurve.ARMsteps(length(y.ARMCurve.ARMsteps)));

%y.interpIRM=fit(y.IRM.AF.treatmentAFFields',y.IRM.AF.mmag','linearinterp');
%y.interpARM=fit(y.ARM.treatmentAFFields',y.ARM.mmag','linearinterp');
%y.interpNRM=fit(y.NRM.treatmentAFFields',y.NRM.mmag','linearinterp');

y.trialFields=y.IRM.AF.treatmentAFFields;
y.calcIRM=abs(y.IRM.AF.mvector(3,:)');
%y.calcARM=abs(y.interpARM(y.trialFields));
%y.calcNRM=abs(y.interpNRM(y.trialFields));

y.calcARM=abs(interpolate(y.ARM.treatmentAFFields,y.ARM.mmag,y.trialFields));
y.calcNRM=abs(interpolate(y.NRM.treatmentAFFields,y.NRM.mmag,y.trialFields));

y.NRMtoIRM=y.calcNRM(1)/y.calcIRM(1);
y.ARMtoIRM=y.calcARM(1)/y.calcIRM(1);