function y=RmgFullerPlot(RmgData,varargin)

if nargin==1
    AFLevel=RmgAFLevelFind(RmgData);
else
    AFLevel=varargin{1};
    if AFLevel==0
        AFLevel=RmgAFLevelFind(RmgData);
    end
end

if AFLevel==0
    AFLevel=RmgAFLevelFind(RmgData);
end


if length(AFLevel)<length(RmgData)
    AFLevel=repmat(AFLevel,1,length(RmgData));
end


linecolorsNRM={'g','b','r'};
linecolorsARM={'y','c','m'};
linesyms={'.','+','*','^'};

legendstr={};

if length(RmgData)==1
    titleSuffix=[': ' RmgData(1).samplename];
    RmgData(1).samplename='';
else
        titleSuffix='';
    
end


for i=1:length(RmgData)

    FullerCurves(i)=RmgFullerCurves(RmgData(i),AFLevel(i));
    
    if FullerCurves(i).doesExist

        loglog(FullerCurves(i).calcIRM,FullerCurves(i).calcNRM,[linecolorsNRM{mod(i,3)+1} linesyms{mod((i-1)*2+1,4)+1} '-']);
        hold on;
        loglog(FullerCurves(i).calcIRM,FullerCurves(i).calcARM,[linecolorsARM{mod(i,3)+1} linesyms{mod((i-1)*2,4)+1} '-']);
        legendstr={legendstr{:} [RmgData(i).samplename ' NRM'] [RmgData(i).samplename ' ARM'] };
        hold on;
    end

end


if sum([FullerCurves.doesExist])>0
    legend(legendstr,'Location','Best');
    axis manual;
    stdvector=[1e-15 1];
    minIRM=min(min([FullerCurves.calcIRM]));
    maxIRM=max(max([FullerCurves.calcIRM]));
    
    minARM=min(min([FullerCurves.calcARM]));
    maxARM=max(max([FullerCurves.calcARM]));
    
    minNRM=min(min([FullerCurves.calcNRM]));
    maxNRM=max(max([FullerCurves.calcNRM]));
    miny=min(minNRM,minARM);
    maxy=max(maxNRM,maxARM);
    
    meany=10^(.5*log10(miny)+.5*log10(maxy));
    
    loglog(stdvector,stdvector*1e-4,'k:');
    if ((1.2e-4*maxIRM>miny) *(1.2e-4*maxIRM<maxy))
        text(maxIRM,maxIRM*1.2e-4,'1:10^{-4}');
    end
    loglog(stdvector,stdvector*1e-3,'k:');
    if ((1.2e-3*maxIRM>miny) *(1.2e-4*maxIRM<maxy))
        text(maxIRM,maxIRM*1.2e-3,'1:1000');
    end
    loglog(stdvector,stdvector*1e-2,'k:');
    if ((1.2e-2*maxIRM>miny) *(1.2e-4*maxIRM<maxy))
        text(maxIRM,maxIRM*1.2e-2,'1:100');
    end
    loglog(stdvector,stdvector*1e-1,'k:');
    if ((1.2e-1*maxIRM>miny) *(1.2e-1*maxIRM<maxy))
        text(maxIRM,maxIRM*1.2e-1,'1:10');
    end
    loglog(stdvector,stdvector,'k:');
    if ((1.2*maxIRM>miny) *(1.2*maxIRM<maxy))
        text(maxIRM,maxIRM*1.2,'1:1');
    end
    xlabel ('IRM (Am^2)');
    ylabel ('m {Am^2}');
    title(['Fuller' titleSuffix]);
else
    axis off;
end