function y=RmgIRMBackfieldCurve(RmgData)

    candidateSIRM=intersect(find(RmgData.treatmentDCFields==max(RmgData.treatmentDCFields)),RmgData.stepsIRM);

    y.doesExist=-1;

    while y.doesExist==-1
        if length(candidateSIRM)==0
            y.doesExist=0;
            return;
        end

        stepnum=candidateSIRM(length(candidateSIRM));

        priorSteps=[1:stepnum-1];
        priorIRM=intersect(priorSteps,RmgData.stepsIRM);
        priorNonIRM=setdiff(priorSteps,priorIRM);
        preIRMStep=priorNonIRM(length(priorNonIRM));



        if RmgData.levels(stepnum+1)<0 & (strmatch('IRM',RmgData.steptypes{stepnum+1}))
            y.doesExist=1;
        else
            candidateSIRM(length(candidateSIRM))=[];
        end
    end

    y=ExtractDCDemagOfStep(RmgData,stepnum);

    y.SIRM.step=stepnum;
    y.SIRM.treatmentDCField=RmgData.treatmentDCFields(stepnum);
    y.SIRM.mvectorUnsub=RmgData.mvector(:,stepnum);
    y.SIRM.mvector=y.SIRM.mvectorUnsub-y.baselineVector;
    y.SIRM.sIRMperVol=RmgData.mzvol(stepnum);

    y.fracmags=y.mvector(3,:)/y.SIRM.mvector(3);

    %y.interp=fit(y.treatmentDCFields',y.fracmags','linearinterp');
    %y.derivFracmags=differentiate(y.interp,y.treatmentDCFields);

    dfields=diff(y.treatmentDCFields);
    y.derivfields=y.treatmentDCFields(1:length(dfields))+.5*dfields;
    y.fracmagsderiv=diff(y.fracmags)./dfields;

    
end



function y=ExtractDCDemagOfStep(RmgData,stepnum)

    if stepnum+1>length(RmgData.levels)
        y.doesExist=0;
        return;
    end

    subsequentSteps=[stepnum+1:length(RmgData.levels)];
    subsequentIRM=intersect(subsequentSteps,RmgData.stepsIRM);
    subsequentNonIRM=setdiff(subsequentSteps,subsequentIRM);
    firstNonIRM=subsequentNonIRM(1);

    subsequentAFmax=intersect(subsequentSteps,RmgData.stepsAFmax);
    priorAFmax=intersect([1:stepnum-1],RmgData.stepsAFmax);

    if priorAFmax
        magBaselineStep=priorAFmax(length(priorAFmax));
    elseif subsequentAFmax
        magBaselineStep=subsequentAFmax(1);
    else
        magBaselineStep=0;
    end

    magBaselineStep
    
    if magBaselineStep>0
        y.baselineVector=RmgData.mvector(:,magBaselineStep);
    else
        y.baselineVector=[0 0 0]';
    end

    y.DCSteps=[subsequentIRM(1):firstNonIRM-1];

    if length(y.DCSteps)==0
        y.doesExist=0;
        return
    end

    y.doesExist=1;

    y.mvectorUnsub=RmgData.mvector(:,y.DCSteps);
    y.mvector=y.mvectorUnsub-repmat(y.baselineVector,1,length(y.DCSteps));
    y.mmag=sqrt(sum(y.mvector.^2));
    y.mzNormalized=y.mvector(3,:)/y.mvector(3,1);
    y.mmagNormalized=y.mmag/y.mmag(1);
    y.treatmentDCFields=RmgData.treatmentDCFields(y.DCSteps);

    y.targetStep.steptype=RmgData.steptypes{stepnum};
    y.targetStep.level=RmgData.levels(stepnum);
    y.targetStep.bias=RmgData.bias(stepnum);
    y.targetStep.spin=RmgData.spin(stepnum);
    y.targetStep.mvector=RmgData.mvector(:,stepnum);
    y.targetStep.treatmentDCFields=RmgData.treatmentDCFields(stepnum);
    y.targetStep.treatmentAFFields=RmgData.treatmentAFFields(stepnum);
    y.targetStep.treatmentTemp=RmgData.treatmentTemps(stepnum);

end