function y=RmgLowrieFullerCurves(RmgData,varargin)

if nargin>1
    AFLevel=varargin{1};
else
    AFLevel=RmgAFLevelFind(RmgData);
end

ARMstep=intersect(RmgData.stepsARM,find(RmgData.treatmentAFFields==AFLevel));
if length(ARMstep)>0
    maxDCField=max(RmgData.treatmentDCFields(ARMstep));
    ARMstep=ARMstep(find(RmgData.treatmentDCFields(ARMstep)==maxDCField));
    ARMstep=ARMstep(end);
    y.ARMAF=RmgExtractAFOfStep(RmgData,ARMstep);
else
    y.ARMAF=[];
    y.ARMAF.doesExist=0;
end
    
IRMstep=intersect(RmgData.stepsIRM,find(RmgData.treatmentDCFields==AFLevel));
if length(IRMstep)>0
    IRMstep=IRMstep(length(IRMstep));
    y.IRMAF=RmgExtractAFOfStep(RmgData,IRMstep);
else
    y.IRMAF=[];
    y.IRMAF.doesExist=0;
    
end
y.doesExist=y.ARMAF.doesExist*y.IRMAF.doesExist;

if (y.doesExist)
	y.deltaMDF = y.ARMAF.MDF-y.IRMAF.MDF;
else
	y.deltaMDF=NaN;
end	