function y=RmgLowrieFullerDerivativePlot(RmgData,varargin)

if nargin==1
    AFLevel=RmgAFLevelFind(RmgData);
else
    AFLevel=varargin{1};
    if AFLevel==0
        AFLevel=RmgAFLevelFind(RmgData);
    end
end

if AFLevel==0
    AFLevel=RmgAFLevelFind(RmgData);
end

if length(AFLevel)<length(RmgData)
    AFLevel=repmat(AFLevel,1,length(RmgData));
end
    
linecolorsIRM={'g','b','r'};
linecolorsARM={'y','c','m'};
linecolorsNRM={'b','r','g'};
linecolorsRRM={'m','y','c'};
linecolorsSingle={'g','b','r','y','c','m'};
linesyms={'.','x','o','+','*','s','d','v','^','>','<'};

legendstr={};

doMultiAF=0;
doARMOnly=0;
useFits=0;

if nargin>2
    for i=2:nargin-1
        if strcmp(varargin{i},'MultiAF')
            doMultiAF=1;
            doARMOnly=0;
        elseif strcmp(varargin{i},'ARMOnly')
            doMultiAF=0;
            doARMOnly=1;
        elseif strcmp(varargin{i},'Lowrie-Fuller')
            doMultiAF=0;
            doARMOnly=0;
        elseif strcmp(varargin{i},'Fit')
            useFits=1;
        else
            doMultiAF=0;
            doARMOnly=0;
        end
    end
end

if length(RmgData)==1
    titleSuffix=[': ' RmgData(1).samplename];
    RmgData(1).samplename='';
else
    titleSuffix='';
end
 
% first do symbols, then do lines

minlogAF=0;
maxlogAF=-3;


for i=1:length(RmgData)
    Curves(i)=RmgLowrieFullerCurves(RmgData(i),AFLevel(i));
    numcurves(i)=2;
    if doMultiAF
        FullerCurves(i)=RmgFullerCurves(RmgData(i),AFLevel(i));
        RRMCurve(i)=RmgRRMCurve(RmgData(i),AFLevel(i));
        numcurves(i)=2*Curves(i).doesExist+FullerCurves(i).doesExist+RRMCurve(i).doesExist;
    end
    if Curves(i).doesExist
        ARMAF(i)=Curves(i).ARMAF;
        IRMAF(i)=Curves(i).IRMAF;
        minlogAF=min([ARMAF(i).log10treatmentAFderivFields minlogAF]);
        maxlogAF=max([ARMAF(i).log10treatmentAFderivFields maxlogAF]);


        if doARMOnly
            plot(ARMAF(i).log10treatmentAFderivFields+3,ARMAF(i).mzlogderiv,[linecolorsSingle{mod(i,6)+1} linesyms{mod((i-1)*numcurves(i)+1,11)+1}]);
            hold on;
            legendstr={legendstr{:} [RmgData(i).samplename] };
        else
            plot(ARMAF(i).log10treatmentAFderivFields+3,ARMAF(i).mzlogderiv,[linecolorsARM{mod(i,3)+1} linesyms{mod((i-1)*numcurves(i)+1,11)+1}]);
            hold on;
            plot(IRMAF(i).log10treatmentAFderivFields+3,IRMAF(i).mzlogderiv,[linecolorsIRM{mod(i,3)+1} linesyms{mod((i-1)*numcurves(i),11)+1}]);
            legendstr={legendstr{:} [RmgData(i).samplename ' ARM'] [RmgData(i).samplename ' IRM'] };
        end
    end
    if doMultiAF
        if FullerCurves(i).doesExist
            plot(FullerCurves(i).NRM.log10treatmentAFderivFields+3,FullerCurves(i).NRM.mzlogderiv,[linecolorsNRM{mod(i,3)+1} linesyms{mod((i-1)*numcurves(i)+2,11)+1}]);
            hold on;
            legendstr={legendstr{:} [RmgData(i).samplename ' NRM'] };
        end
        if RRMCurve(i).doesExist
            RRMstep=intersect(RmgData.stepsRRM,find(RmgData.treatmentAFFields==AFLevel(i)));
            RRMstep=RRMstep(length(RRMstep));
            RRMAF(i)=RmgExtractAFOfStep(RmgData,RRMstep);
            if RRMAF(i).doesExist
                includeRRM(i)=1;
                plot(RRMAF(i).log10treatmentAFderivFields+3,RRMAF(i).mzlogderiv,[linecolorsRRM{mod(i,3)+1} linesyms{mod((i-1)*numcurves(i)+3,11)+1}]);
                legendstr={legendstr{:} [RmgData(i).samplename ' RRM'] };
            end
        end
    end
end

if sum([Curves.doesExist])>0
    if length(legendstr) > 1
        legend(legendstr,'Location','Best');
    end
    xlabel('log_{10} B (mT)');
    ylabel('derivative frac. mag.');
    if doMultiAF
        title(['AF' titleSuffix]); 
    elseif doARMOnly
        title(['AF of ARM' titleSuffix]);
    else
        title(['Lowrie-Fuller Derivative' titleSuffix]);
    end
else
    axis off;
end


if useFits
    for i=1:length(RmgData)
        if Curves(i).doesExist
            y.fits(i).ARM=RmgAFDerivativeCurveFits(ARMAF(i));
            y.fits(i).IRM=RmgAFDerivativeCurveFits(IRMAF(i));
        end
        if doMultiAF
            if FullerCurves(i).doesExist
                y.fits(i).NRM=RmgAFDerivativeCurveFits(FullerCurves(i).NRM);
            end
            if RRMCurve(i).doesExist
                y.fits(i).RRM=RmgAFDerivativeCurveFits(RRMAF(i));
            end
        end
       if Curves(i).doesExist     
            if doARMOnly
                plot((minlogAF:.01:maxlogAF)+3,y.fits(i).ARM.mzlogderivbestfit.fit(minlogAF:.01:maxlogAF),[linecolorsSingle{mod(i,6)+1} '-']);
                hold on;
            else
                plot((minlogAF:.01:maxlogAF)+3,y.fits(i).ARM.mzlogderivbestfit.fit(minlogAF:.01:maxlogAF),[linecolorsARM{mod(i,3)+1} '-']);
                hold on;
                plot((minlogAF:.01:maxlogAF)+3,y.fits(i).IRM.mzlogderivbestfit.fit(minlogAF:.01:maxlogAF),[linecolorsIRM{mod(i,3)+1} '-']);
            end
        end
        if doMultiAF
            if FullerCurves(i).doesExist
                plot((minlogAF:.01:maxlogAF)+3,y.fits(i).NRM.mzlogderivbestfit.fit(minlogAF:.01:maxlogAF),[linecolorsNRM{mod(i,3)+1} '-']);
                hold on;
            end
            if RRMCurve(i).doesExist
                if RRMAF(i).doesExist
                    plot((minlogAF:.01:maxlogAF)+3,y.fits(i).RRM.mzlogderivbestfit.fit(minlogAF:.01:maxlogAF),[linecolorsRRM{mod(i,3)+1} '-']);
                end
            end
        end
    end

else
    for i=1:length(RmgData)
       if Curves(i).doesExist     
            if doARMOnly
                plot(ARMAF(i).log10treatmentAFderivFields+3,ARMAF(i).mzlogderivSmooth,[linecolorsSingle{mod(i,6)+1} '-']);
                hold on;
            else
                plot(ARMAF(i).log10treatmentAFderivFields+3,ARMAF(i).mzlogderivSmooth,[linecolorsARM{mod(i,3)+1} '-']);
                hold on;
                plot(IRMAF(i).log10treatmentAFderivFields+3,IRMAF(i).mzlogderivSmooth,[linecolorsIRM{mod(i,3)+1} '-']);
            end
        end
        if doMultiAF
            if FullerCurves(i).doesExist
                plot(FullerCurves(i).NRM.log10treatmentAFderivFields+3,FullerCurves(i).NRM.mzlogderivSmooth,[linecolorsNRM{mod(i,3)+1} '-']);
                hold on;
            end
            if RRMCurve(i).doesExist
                if RRMAF(i).doesExist
                    includeRRM(i)=1;
                    plot(RRMAF(i).log10treatmentAFderivFields+3,RRMAF(i).mzlogderivSmooth,[linecolorsRRM{mod(i,3)+1} '-']);
                end
            end
        end
    end
end

