function y=RmgLowrieFullerPlot(RmgData,varargin)

if nargin==1
    AFLevel=RmgAFLevelFind(RmgData);
else
    AFLevel=varargin{1};
    if AFLevel==0
        AFLevel=RmgAFLevelFind(RmgData);
    end
end

if AFLevel==0
    AFLevel=RmgAFLevelFind(RmgData);
end

if length(AFLevel)<length(RmgData)
    AFLevel=repmat(AFLevel,1,length(RmgData));
end
    
linecolorsIRM={'g','b','r'};
linecolorsARM={'y','c','m'};
linecolorsNRM={'b','r','g'};
linecolorsRRM={'m','y','c'};
linesyms={'.','x','o','+','*','s','d','v','^','>','<'};

legendstr={};

doMultiAF=0;

if nargin>2
    if varargin{2}
        doMultiAF=1;
    else
        doMultiAF=0;
    end
end

if length(RmgData)==1
    titleSuffix=[': ' RmgData(1).samplename];
    RmgData(1).samplename='';
else
    titleSuffix='';
end

for i=1:length(RmgData)
    Curves(i)=RmgLowrieFullerCurves(RmgData(i),AFLevel(i));
    numcurves(i)=2;
    if doMultiAF
        FullerCurves(i)=RmgFullerCurves(RmgData(i),AFLevel(i));
        RRMCurve(i)=RmgRRMCurve(RmgData(i),AFLevel(i));
        numcurves(i)=2*Curves(i).doesExist+FullerCurves(i).doesExist+RRMCurve(i).doesExist;
    end
    if Curves(i).doesExist
        ARMAF(i)=Curves(i).ARMAF;
        IRMAF(i)=Curves(i).IRMAF;        
        plot(ARMAF(i).treatmentAFFields*1000,ARMAF(i).mzNormalized,[linecolorsARM{mod(i,3)+1} linesyms{mod((i-1)*numcurves(i)+1,11)+1} '-']);
        hold on;
        plot(IRMAF(i).treatmentAFFields*1000,IRMAF(i).mzNormalized,[linecolorsIRM{mod(i,3)+1} linesyms{mod((i-1)*numcurves(i),11)+1} '-']);
        legendstr={legendstr{:} [RmgData(i).samplename ' ARM'] [RmgData(i).samplename ' IRM'] };
    end
    if doMultiAF
        if FullerCurves(i).doesExist
            plot(FullerCurves(i).NRM.treatmentAFFields*1000,FullerCurves(i).NRM.mdirectionalNormalized,[linecolorsNRM{mod(i,3)+1} linesyms{mod((i-1)*numcurves(i)+2,11)+1} '-']);
            hold on;
            legendstr={legendstr{:} [RmgData(i).samplename ' NRM'] };
        end
        if RRMCurve(i).doesExist
            RRMstep=intersect(RmgData.stepsRRM,find(RmgData.treatmentAFFields==AFLevel(i)));
            RRMstep=RRMstep(length(RRMstep));
            RRMAF(i)=RmgExtractAFOfStep(RmgData,RRMstep);
            if RRMAF(i).doesExist
                includeRRM(i)=1;
                plot(RRMAF(i).treatmentAFFields*1000,RRMAF(i).mzNormalized,[linecolorsRRM{mod(i,3)+1} linesyms{mod((i-1)*numcurves(i)+3,11)+1} '-']);
                legendstr={legendstr{:} [RmgData(i).samplename ' RRM'] };
            end
        end
    end
end

if sum([Curves.doesExist])>0
    legend(legendstr,'Location','Northeast');
    xlabel('B (mT)');
    ylabel('frac. mag.');
    if doMultiAF
        title(['AF' titleSuffix]); 
    else
        title(['Lowrie-Fuller' titleSuffix]);
    end
else
    axis off;
end




