function y=RmgRRMCurve(RmgData,varargin)

mu0=4*pi*1e-7;

if nargin>1
    AFLevel=varargin{1};
else
    AFLevel=RmgAFLevelFind(RmgData,'RRM');
end

ARM=RmgARMCurve(RmgData,AFLevel);

RRM0Steps=intersect(RmgData.stepsRRM,find(RmgData.spin==0));
if length(RRM0Steps)==0
    y.doesExist=0;
    return;
end
y.doesExist=1;

for i=1:length(RRM0Steps)
    subsequentSteps{i}=[RRM0Steps(i)+1:length(RmgData.levels)];
    NonRRMPositions{i}=union(setdiff(subsequentSteps{i},RmgData.stepsRRM),length(RmgData.levels)+1);
    firstNonRRM(i)=NonRRMPositions{i}(1);
    SpinSpeeds{i}=RmgData.spin([RRM0Steps(i):firstNonRRM(i)-1]);
    baselineVector{i}=RmgData.mvector(:,RRM0Steps(i));
    deltas{i}=RmgData.mvector(:,[RRM0Steps(i):firstNonRRM(i)-1])-repmat(baselineVector{i},1,firstNonRRM(i)-RRM0Steps(i));
end
y.ARMsusceptibility=ARM.ARMsusceptibility;
y.spins=[SpinSpeeds{:}];
y.deltas=[deltas{:}];
y.Brrm=mu0*y.deltas(3,:)/ARM.ARMsusceptibility;