function y=RmgRRMPlot(RmgData,varargin);

if nargin==1
    AFLevel=RmgAFLevelFind(RmgData);
else
    AFLevel=varargin{1};
end

if AFLevel==0
    AFLevel=RmgAFLevelFind(RmgData);
end


if length(AFLevel)<length(RmgData)
    AFLevel=repmat(AFLevel,1,length(RmgData));
end

linecolors={'k','g','b','r','c','m','y'};
linesyms={'.','x','o','+','*','s','d','v','^','>','<'};


legendstr={};

for i=1:length(RmgData)
    RRM(i)=RmgRRMCurve(RmgData(i),AFLevel(i));
    if RRM(i).doesExist
        plot(RRM(i).spins,RRM(i).Brrm*10^6,[linecolors{mod(i,7)+1} linesyms{mod(i,11)+1} ]);
        legendstr={legendstr{:} RmgData(i).samplename};
        hold on;
    end
end

if sum([RRM.doesExist])>0
    if length(RmgData)>1
        legend(legendstr,'Location','Northwest');
        titleSuffix='';
    else
        titleSuffix=[': ' RmgData(1).samplename];
    end
    xlabel ('Spin (Hz)');
    ylabel ('B_{RRM} (\muT)');
    title(['RRM' titleSuffix]);
else
    axis off;
end