function y=RmgSIRMCurve(RmgData)

candidateSIRM=intersect(find(RmgData.treatmentDCFields==max(RmgData.treatmentDCFields)),RmgData.stepsIRM);

y.doesExist=-1;

while y.doesExist==-1
    if length(candidateSIRM)==0
        y.doesExist=0;
        return;
    end
   
    stepnum=candidateSIRM(length(candidateSIRM));

    priorSteps=[1:stepnum-1];
    priorIRM=intersect(priorSteps,RmgData.stepsIRM);
    priorNonIRM=setdiff(priorSteps,priorIRM);
    preIRMStep=priorNonIRM(length(priorNonIRM));

    if preIRMStep<stepnum-1
        y.doesExist=1;
    else
        candidateSIRM(length(candidateSIRM))=[];
    end
    
    
end

y.AF=RmgExtractAFOfStep(RmgData,stepnum);
y.baselineVector=y.AF.baselineVector;

y.IRM.IRMSteps=[preIRMStep+1:stepnum];
y.IRM.treatmentDCFields=RmgData.treatmentDCFields(y.IRM.IRMSteps);
y.IRM.mvectorUnsub=RmgData.mvector(:,y.IRM.IRMSteps);
y.IRM.mvector=y.IRM.mvectorUnsub-repmat(y.baselineVector,1,length(y.IRM.IRMSteps));
y.IRM.IRMperVol=RmgData.mzvol(y.IRM.IRMSteps);
y.IRM.fracmags=abs(y.IRM.mvector(3,:)/y.IRM.mvector(3,length(y.IRM.IRMSteps)));

y.AF.fracmags=abs(y.AF.mvector(3,:)/y.IRM.mvector(3,length(y.IRM.IRMSteps)));


%y.AF.interp=fit(y.AF.treatmentAFFields',y.AF.fracmags','linearinterp');
%y.IRM.interp=fit(y.IRM.treatmentDCFields',y.IRM.fracmags','linearinterp');

y.diff.fields=[max([min(y.AF.treatmentAFFields) min(y.IRM.treatmentDCFields)]):1e-4:min([max(y.AF.treatmentAFFields)  max(y.IRM.treatmentDCFields)])];
AFinterp=interpolate(y.AF.treatmentAFFields,y.AF.fracmags,y.diff.fields);
IRMinterp=interpolate(y.IRM.treatmentDCFields,y.IRM.fracmags,y.diff.fields);
y.diff.deltas=AFinterp-IRMinterp;
[C,I]=min(abs(y.diff.deltas));
y.diff.deltas=moving(1-AFinterp-IRMinterp,5);
y.diff.integrateddelta=trapz(y.diff.fields*1000,y.diff.deltas);
y.diff.crossover=y.diff.fields(I);


y.AF.dfields=diff(y.AF.treatmentAFFields);
y.IRM.dfields=diff(y.IRM.treatmentDCFields);

y.AF.derivFields=y.AF.treatmentAFFields(1:length(y.AF.treatmentAFFields)-1)+.5*y.AF.dfields;
y.IRM.derivFields=y.IRM.treatmentDCFields(1:length(y.IRM.treatmentDCFields)-1)+.5*y.IRM.dfields;

y.AF.dlogfields=diff(log10(y.AF.treatmentAFFields));
y.IRM.dlogfields=diff(log10(y.IRM.treatmentDCFields));

y.AF.logDerivFields=log10(y.AF.treatmentAFFields(1:length(y.AF.treatmentAFFields)-1))+.5*y.AF.dlogfields;
y.IRM.logDerivFields=log10(y.IRM.treatmentDCFields(1:length(y.IRM.treatmentDCFields)-1))+.5*y.IRM.dlogfields;

%y.AF.loginterp=fit(log10(y.AF.treatmentAFFields'),y.AF.fracmags','linearinterp');
%y.IRM.loginterp=fit(log10(y.IRM.treatmentDCFields'),y.IRM.fracmags','linearinterp');

y.AF.derivFracmags=-diff(y.AF.fracmags)./diff((y.AF.treatmentAFFields));
y.IRM.derivFracmags=diff(y.IRM.fracmags)./diff((y.IRM.treatmentDCFields));

%y.AF.derivFracmags=differentiate(y.AF.interp,y.AF.derivFields);
%y.IRM.derivFracmags=differentiate(y.IRM.interp,y.IRM.derivFields);

y.AF.logderiv=-diff(y.AF.fracmags)./diff(log10(y.AF.treatmentAFFields));
y.IRM.logderiv=diff(y.IRM.fracmags)./diff(log10(y.IRM.treatmentDCFields));

%y.AF.logderiv=-differentiate(y.AF.loginterp,y.AF.logDerivFields);
%y.IRM.logderiv=differentiate(y.IRM.loginterp,y.IRM.logDerivFields);

smoothSpan=double(int32(length(y.AF.logDerivFields)*.03)*2+1);
%y.AF.logderivSmooth=smooth(y.AF.logderiv,smoothSpan,'rlowess');
y.AF.logderivSmooth=moving(y.AF.logderiv,smoothSpan)';

smoothSpan=double(int32(length(y.IRM.logDerivFields)*.03)*2+1);
%y.IRM.logderivSmooth=smooth(y.IRM.logderiv,smoothSpan,'rlowess');
y.IRM.logderivSmooth=moving(y.IRM.logderiv,smoothSpan)';

y.sIRM=abs(y.IRM.mvector(3,length(y.IRM.IRMSteps)));
y.sIRMperVol=y.sIRM/RmgData.volume;
y.Hcr=y.diff.crossover;
%y.R=y.IRM.interp(y.Hcr);
y.R=interpolate(y.IRM.treatmentDCFields,y.IRM.fracmags,y.Hcr);
y.MAF=interpolate(y.IRM.fracmags,y.IRM.treatmentDCFields,0.5);
y.MDF=y.AF.MDF;

y.IRM30toIRM100=interpolate(y.IRM.treatmentDCFields,y.IRM.mvector(3,:),0.03)/interpolate(y.IRM.treatmentDCFields,y.IRM.mvector(3,:),0.1);
y.IRM100toIRM300=interpolate(y.IRM.treatmentDCFields,y.IRM.mvector(3,:),0.1)/interpolate(y.IRM.treatmentDCFields,y.IRM.mvector(3,:),0.3);

y.IRM.meanlogfield=trapz(y.IRM.logDerivFields,y.IRM.logderivSmooth.*y.IRM.logDerivFields)/trapz(y.IRM.logDerivFields,y.IRM.logderivSmooth);
y.IRM.dispersion=sqrt(trapz(y.IRM.logDerivFields,((y.IRM.logDerivFields-y.IRM.meanlogfield).^2).*y.IRM.logderivSmooth)/trapz(y.IRM.logDerivFields,y.IRM.logderivSmooth));
y.IRM.skewness=trapz(y.IRM.logDerivFields,((y.IRM.logDerivFields-y.IRM.meanlogfield).^3).*y.IRM.logderivSmooth)/(y.IRM.dispersion^3);

end