function y=RmgSIRMPlot(RmgData)


linecolors={'k','g','b','r','c','m','y'};
linesyms={'.','x','o','+','*','s','d','v','^','>','<'};


legendstr={};

for i=1:length(RmgData)
    IRM(i)=RmgSIRMCurve(RmgData(i));
    if IRM(i).doesExist
        semilogx(IRM(i).IRM.treatmentDCFields*1000,IRM(i).IRM.fracmags,[linecolors{mod(i,7)+1} linesyms{mod(i,11)+1} '-']);
        if length(RmgData)>1
            legendstr={legendstr{:} RmgData(i).samplename};
        end
        hold on;
    end
end

if sum([IRM.doesExist])>0
    if length(RmgData) > 1
        legend(legendstr,'Location','Northwest');
    
        titleSuffix='';
    else
        titleSuffix=[': ' RmgData(1).samplename];
    end
    for i=1:length(RmgData)
        if IRM(i).doesExist
            semilogx(IRM(i).AF.treatmentAFFields*1000,IRM(i).AF.fracmags,[linecolors{mod(i,7)+1} linesyms{mod(i,11)+1} '-']);
        end
    end
    xlabel ('B (mT)');
    ylabel (['f_{SIRM}']);
    title(['IRM' titleSuffix]);
else
    axis off;
end
