VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "SampleCommand"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder6" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Attribute VB_Ext_KEY = "Member0" ,"Sample"
'local variable(s) to hold property value(s)
Private mvarKey As String 'local copy
Private mvarcommandType As String 'local copy
Private mvarFileID As String
Private mvarSample As String
Private mvarHole As Long 'local copy

Private Const commandMeasure = "Meas"
Private Const commandInitUp = "InitUp"
Private Const commandHolder = "Holder"
Private Const commandFlip = "Flip"
Private Const commandFin = "Fin"
Private Const commandGoto = "Goto"

Public Sub Execute()
    Dim NotificationMessage As String

    Do Until Not Prog_paused
        If Prog_halted Then Exit Do
            DelayTime 0.5
    Loop
    frmMeasure.HideStats
    frmMeasure.clearData
            
    If DEBUG_MODE Then frmDebug.Msg "Executing from queue of " & SampleQueueCommands & _
        ": " & commandType & " hole " & hole

    Select Case mvarcommandType
        Case commandMeasure
            'frmMeasure.SetFieldsFromRegistry fileid
            MeasurementsSinceHolder = MeasurementsSinceHolder + 1
            frmVacuum.MotorPower True
            frmMeasure.SetSample mvarSample
            With SampleIndexRegistry(mvarFileID)
                .measurementSteps.CurrentStepIndex = 1
                frmMeasure.SetFields .avgSteps, .curDemagLong, .doUp, .doBoth, mvarFileID
            End With
            frmMeasure.ZOrder
            frmMeasure.Show
            frmDCMotors.ChangerHole
            Changer_ProcessSample hole
        Case commandInitUp
            ' no longer serves a purpose except as marker for preprocessing
        Case commandHolder
            frmVacuum.MotorPower True
        
            If MeasurementsSinceHolder = 0 Then Exit Sub
            MeasurementsSinceHolder = 0
            
            If COMPortSusceptibility > 0 And EnableSusceptibility Then frmSusceptibilityMeter.LagTime
            
            If Changer_ValidStart(hole) Then
                frmDCMotors.ChangerMotortoHole hole
            Else
                Changer_NearestHole
            End If
            frmMeasure.SetFields 1, vbNullString, True, False, vbNullString
            frmMeasure.SetSample "Holder"
            frmMeasure.ZOrder
            frmMeasure.Show
            ' Process the current position (a hole)
            Changer_ProcessSample frmDCMotors.ChangerHole
        Case commandFlip
            frmVacuum.ValveConnect False
            frmVacuum.MotorPower False
            
            Changer_NearestHole
            With SampleIndexRegistry(mvarFileID)
                SetCodeLevel CodeOrange
                frmSendMail.MailNotification "Flip samples", "Please place the samples '" & .SampleCode & "' in the sample tray " & _
                    "with the arrows pointed down.", CodeOrange
                MsgBox "Please place the samples '" & .SampleCode & "' in the sample tray " & _
                    "with the arrows pointed down."
                SetCodeLevel CodeGreen, True
                .doUp = Not .doUp
            End With
            
            frmVacuum.MotorPower True
        Case commandFin
            frmVacuum.ValveConnect False
            frmVacuum.MotorPower False
            frmMeasure.Hide
            
            If LenB(fileid) > 0 Then
                If SampleIndexRegistry(fileid).measurementSteps.NeedsCoilAFDemag Then
                    Changer_NearestHole
                    MotorUpDn_Move AFPos, 2   '  Move somewhat slowly into AF region
                    frmDCMotors.TurningMotorRotate 0
                    frmAF.Connect
                    frmAF.ExecuteRamp "C", TransverseCoilSystem, AfTransMax, AFDelay, AFRampRate
                    frmDCMotors.TurningMotorRotate 90
                    frmAF.ExecuteRamp "C", TransverseCoilSystem, AfTransMax, AFDelay, AFRampRate
                    frmAF.ExecuteRamp "C", AxialCoilSystem, AfAxialMax, AFDelay, AFRampRate
                    frmAF.Disconnect
                    frmDCMotors.TurningMotorRotate 360
                    MotorUpDn_Move 0, 2
                End If
            End If
            
            ' reset SampleHolder step type to NRM, just in case
            SampleHolder.Parent.measurementSteps(1).StepType = "NRM"
            SampleHolder.Parent.measurementSteps(1).level = 0
            
            Changer_NearestHole
            NotificationMessage = "Measurements are done on " & SampleIndexRegistry(mvarFileID).SampleCode & "."
            frmSendMail.MailNotification "2G Status Update", NotificationMessage
            'MsgBox (NotificationMessage)
        Case commandGoto
            If Changer_ValidStart(hole) Then
                frmDCMotors.ChangerMotortoHole hole
                frmDCMotors.ChangerHole
            End If
    End Select
End Sub


Public Property Let fileid(ByVal vdata As String)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.Hole = 5
    mvarFileID = vbNullString
    If SampleIndexRegistry.IsValidFile(vdata) Then _
        mvarFileID = SampleIndexRegistry(vdata).FileName
End Property


Public Property Get fileid() As String
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.Hole
    fileid = mvarFileID
End Property

Public Property Let Sample(ByVal vdata As String)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.Hole = 5
On Error GoTo Oops
    mvarSample = SampleIndexRegistry(mvarFileID).sampleSet(vdata).Samplename
    
    On Error GoTo 0
    Exit Property
Oops:
    mvarSample = vbNullString
End Property


Public Property Get Sample() As String
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.Hole
    Sample = mvarSample
End Property

Public Property Let hole(ByVal vdata As Long)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.Hole = 5
    
    If (vdata < SlotMin) Or (vdata > SlotMax) Then
        mvarHole = 0
    Else
        mvarHole = vdata
    End If
End Property


Public Property Get hole() As Long
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.Hole
    hole = mvarHole
End Property



Public Property Let commandType(ByVal vdata As String)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.commandType = 5
    mvarcommandType = vdata
End Property


Public Property Get commandType() As String
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.commandType
    commandType = mvarcommandType
End Property



Public Property Let key(ByVal vdata As String)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.Key = 5
    mvarKey = vdata
End Property


Public Property Get key() As String
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.Key
    key = mvarKey
End Property
