VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "Cartesian3D"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder6" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
'local variable(s) to hold property value(s)
Public x As Double
Public y As Double
Public z As Double

Const pi As Double = 3.141592653589
Const rad As Double = (pi / 180#)
Const deg As Double = (180# / pi)


Function atan(ByVal x As Double, ByVal y As Double) As Double
    If x > 0 Then
        If y > 0 Then
            atan = Atn(y / x)
        Else
            atan = 2 * pi + Atn(y / x)
        End If
    ElseIf x < 0 Then
        atan = pi + Atn(y / x)
    Else
        If y > 0 Then
            atan = pi
        ElseIf y < 0 Then
            atan = -pi
        Else
            atan = 0#
        End If
    End If
End Function

Public Property Get dec() As Double
    dec = atan(x, y) * deg
End Property

Public Property Get inc() As Double
    Dim p As Double
    p = x ^ 2 + y ^ 2
    inc = atan(Sqr(p), z) * deg
End Property


Public Property Get mag() As Double
    mag = Sqr(x ^ 2 + y ^ 2 + z ^ 2)
End Property

Public Property Get UnitVectorX() As Double
    Dim m As Double
    m = mag
    
    If m = 0 Then
        UnitVectorX = 1
    Else
        UnitVectorX = x / m
    End If
End Property

Public Property Get UnitVectorY() As Double
    Dim m As Double
    m = mag
    
    If m = 0 Then
        UnitVectorY = 0
    Else
        UnitVectorY = y / m
    End If
End Property

Public Property Get UnitVectorZ() As Double
    Dim m As Double
    m = mag
    
    If m = 0 Then
        UnitVectorZ = 0
    Else
        UnitVectorZ = z / m
    End If
End Property

Public Sub WriteToINI(sSection As String, sKey As String, sIniFile As String)
    Dim xStr As String, yStr As String, zStr As String
    
    xStr = Format$(x, "0.0000000E+")
    yStr = Format$(y, "0.0000000E+")
    zStr = Format$(z, "0.0000000E+")
    Config_AddToINI sSection, sKey, xStr & "," & yStr & "," & zStr, sIniFile
End Sub

Public Sub ReadFromINI(sSection As String, sKey As String, sIniFile As String)
    Dim parseArray() As String
    parseArray = Split(Config_GetFromINI(sSection, sKey, "0,0,0", sIniFile), ",")
    x = val(parseArray(0))
    y = val(parseArray(1))
    z = val(parseArray(2))
End Sub

Public Function WriteString() As String
    Dim xStr As String, yStr As String, zStr As String
    
    xStr = Format$(x, "0.0000000E+")
    yStr = Format$(y, "0.0000000E+")
    zStr = Format$(z, "0.0000000E+")
    WriteString = xStr & "," & yStr & "," & zStr
End Function

Public Sub ReadString(ByVal cartesianString As String)
    Dim parseArray() As String
    parseArray = Split(cartesianString, ",")
    x = val(parseArray(0))
    y = val(parseArray(1))
    z = val(parseArray(2))
End Sub

