VERSION 5.00
Object = "{0ECD9B60-23AA-11D0-B351-00A0C9055D8E}#6.0#0"; "MSHFLXGD.OCX"
Begin VB.Form frmChanger 
   AutoRedraw      =   -1  'True
   Caption         =   "Hole Sample List"
   ClientHeight    =   6195
   ClientLeft      =   135
   ClientTop       =   420
   ClientWidth     =   10305
   ControlBox      =   0   'False
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MDIChild        =   -1  'True
   ScaleHeight     =   6132.428
   ScaleMode       =   0  'User
   ScaleWidth      =   10752.43
   Visible         =   0   'False
   Begin VB.Frame FrameOrder 
      Caption         =   "Sample order"
      Height          =   732
      Left            =   7320
      TabIndex        =   14
      Top             =   1800
      Width           =   2772
      Begin VB.OptionButton optOrder 
         Caption         =   "Descending"
         Height          =   372
         Index           =   1
         Left            =   1440
         TabIndex        =   16
         Top             =   240
         Width           =   1212
      End
      Begin VB.OptionButton optOrder 
         Caption         =   "Ascending"
         Height          =   372
         Index           =   0
         Left            =   120
         TabIndex        =   15
         Top             =   240
         Value           =   -1  'True
         Width           =   1332
      End
   End
   Begin VB.Frame FrameReloadPos 
      Caption         =   "Reload position"
      Height          =   732
      Left            =   7320
      TabIndex        =   11
      Top             =   2760
      Width           =   2772
      Begin VB.OptionButton optLoadReturn 
         Caption         =   "Return to start"
         Height          =   372
         Index           =   0
         Left            =   120
         TabIndex        =   13
         Top             =   240
         Value           =   -1  'True
         Width           =   1332
      End
      Begin VB.OptionButton optLoadReturn 
         Caption         =   "Leave at end"
         Height          =   372
         Index           =   1
         Left            =   1440
         TabIndex        =   12
         Top             =   240
         Width           =   1212
      End
   End
   Begin VB.Frame FrameFinalPos 
      Caption         =   "Final position"
      Height          =   975
      Left            =   7320
      TabIndex        =   8
      Top             =   3720
      Width           =   2772
      Begin VB.OptionButton optReturn 
         Caption         =   "Return to start"
         Height          =   375
         Index           =   0
         Left            =   120
         TabIndex        =   10
         Top             =   360
         Value           =   -1  'True
         Width           =   1212
      End
      Begin VB.OptionButton optReturn 
         Caption         =   "Leave at end"
         Height          =   375
         Index           =   1
         Left            =   1440
         TabIndex        =   9
         Top             =   360
         Width           =   1212
      End
   End
   Begin VB.Frame FrameRepHolder 
      Caption         =   "Multiple holder measurements"
      Height          =   972
      Left            =   7320
      TabIndex        =   5
      Top             =   4920
      Width           =   2772
      Begin VB.OptionButton optRepeatHolder 
         Caption         =   "Repeat           (weak samples)"
         Height          =   612
         Index           =   0
         Left            =   120
         TabIndex        =   7
         Top             =   240
         Value           =   -1  'True
         Width           =   1332
      End
      Begin VB.OptionButton optRepeatHolder 
         Caption         =   "Skip            (strong samples)"
         Height          =   612
         Index           =   1
         Left            =   1440
         TabIndex        =   6
         Top             =   240
         Width           =   1092
      End
   End
   Begin VB.CommandButton cmdPrint 
      Caption         =   "&Print"
      Height          =   315
      Left            =   7440
      TabIndex        =   3
      Top             =   1200
      Width           =   972
   End
   Begin VB.CommandButton cmdSeq 
      Caption         =   "&Sequential Ordering"
      Height          =   495
      Left            =   8880
      TabIndex        =   2
      Top             =   480
      Width           =   972
   End
   Begin VB.CommandButton cmdClear 
      Caption         =   "&Clear"
      Height          =   315
      Left            =   7440
      TabIndex        =   1
      Top             =   840
      Width           =   972
   End
   Begin VB.CommandButton cmdOK 
      Caption         =   "&OK"
      Default         =   -1  'True
      Height          =   315
      Left            =   7440
      TabIndex        =   0
      Top             =   480
      Width           =   972
   End
   Begin MSHierarchicalFlexGridLib.MSHFlexGrid gridSamples 
      Height          =   5772
      Left            =   240
      TabIndex        =   4
      Top             =   240
      Width           =   6852
      _ExtentX        =   12091
      _ExtentY        =   10186
      _Version        =   393216
      _NumberOfBands  =   1
      _Band(0).Cols   =   2
   End
   Begin VB.Menu mnuSample 
      Caption         =   "Sample"
      NegotiatePosition=   3  'Right
      Visible         =   0   'False
      Begin VB.Menu mnuSampleDelete 
         Caption         =   "&Delete"
      End
      Begin VB.Menu mnuSampleDeleteAndShift 
         Caption         =   "Delete without &Gap"
      End
      Begin VB.Menu mnuInsertSample 
         Caption         =   "&Insert Sample"
      End
      Begin VB.Menu mnuSampleInfo 
         Caption         =   "Sample Info"
      End
   End
End
Attribute VB_Name = "frmChanger"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
' Sample changer form.  This is for handling assignments
' of samples to holes.

Option Explicit

Private Chg_isAscend As Boolean    ' Order of changer measurement
Public newSampQueue As SampleCommands

Private ChangerSamples() As SampleIdentifier

Private WhichFilesLoaded() As Integer

Private gridrows As Integer
Private gridcols As Integer

Public IsMasterList As Boolean


Private Sub form_show()
    form_resize
End Sub

Private Sub mnuInsertSample_click()
    Dim selectionDialog As frmSampleSelect
    Set selectionDialog = New frmSampleSelect
    Dim holeid As Integer
    Dim addFile As String, addSample As String
    
    holeid = gridHole(gridSamples.row, gridSamples.Col)
    If Not Changer_ValidStart(holeid) Then Exit Sub
    
    selectionDialog.Show
    addFile = selectionDialog.Filename
    addSample = selectionDialog.Samplename
    
    If SampleIndexRegistry.IsValidSample(addFile, addSample) Then IncorporateSample holeid, addFile, addSample
    
    Set selectionDialog = Nothing
    fillSamplesGrid
End Sub

Public Function ChangerSampleName(ByVal slot As Integer) As String
    If slot < SlotMin Or slot > SlotMax Then Exit Function
    ChangerSampleName = ChangerSamples(slot).Samplename
End Function

Public Function ChangerFileName(ByVal slot As Integer) As String
    If slot < SlotMin Or slot > SlotMax Then Exit Function
    ChangerFileName = ChangerSamples(slot).Filename
End Function

Public Sub Clear()
' This procedure clears all of the samples from the
    ' screen, resetting the sample form.
    Dim i As Integer
    
    For i = SlotMin To SlotMax
        With ChangerSamples(i)
            If IsMasterList Then
                If SampleIndexRegistry.IsValidSample(.Filename, .Samplename) Then
                    SampleIndexRegistry(.Filename).sampleSet(.Samplename).sampleHole = 0
                End If
            End If
            .Filename = vbNullString
            .Samplename = vbNullString
        End With
    Next i
    fillSamplesGrid
    
    If IsMasterList Then
        SampQueue.Clear
    End If
End Sub

Public Function isValidSampleIn(slot As Integer)
    isValidSampleIn = False
    With ChangerSamples(slot)
        If SampleIndexRegistry.IsValidSample(.Filename, .Samplename) Then isValidSampleIn = True
    End With
End Function

Public Function ChangerSample(slot As Integer) As Sample
    On Error GoTo Oops
    With ChangerSamples(slot)
        Set ChangerSample = SampleIndexRegistry(.Filename).sampleSet(.Samplename)
    End With
    On Error GoTo 0
    Exit Function
Oops:
    Set ChangerSample = New Sample
End Function

Private Sub countFileCalls()
    Dim i As Integer
    ReDim WhichFilesLoaded(SampleIndexRegistry.Count) As Integer
    
    For i = 1 To SlotMax
        With ChangerSamples(i)
        If LenB(.Filename) > 0 Then WhichFilesLoaded(SampleIndexRegistry.Index(.Filename)) = WhichFilesLoaded(SampleIndexRegistry.Index(.Filename)) + 1
        End With
    Next i
End Sub

Public Function setOrder(ascending As Boolean)
    Chg_isAscend = ascending
    If ascending Then
        optOrder(0).Value = True
        optOrder(1).Value = False
    Else
        optOrder(1).Value = True
        optOrder(0).Value = False
    End If
    'SetSequenceVariables
End Function

Public Sub RefreshControls()
    If IsMasterList Then
        Me.Caption = "Hole Sample List - Master List"
        cmdSeq.Visible = True
        FrameOrder.Visible = False
        FrameReloadPos.Visible = False
        FrameFinalPos.Visible = False
        FrameRepHolder.Visible = False
        mnuInsertSample.Visible = False
        mnuSampleDelete.Visible = False
        mnuSampleDeleteAndShift.Visible = False
        
    Else
        Me.Caption = "Hole Sample List - New Sample Set"
        cmdSeq.Visible = False
        FrameOrder.Visible = True
        FrameReloadPos.Visible = False
        FrameFinalPos.Visible = False
        FrameRepHolder.Visible = False
        mnuSampleDelete.Visible = True
        mnuInsertSample.Visible = True
        mnuSampleDeleteAndShift.Visible = True
    End If
End Sub

Private Sub form_resize()
    cmdSeq.Left = Me.Width - cmdSeq.Width * (-cmdSeq.Visible) - 200
    cmdOK.Left = cmdSeq.Left - cmdOK.Width - 400
    cmdPrint.Left = cmdSeq.Left - cmdPrint.Width - 400
    cmdClear.Left = cmdSeq.Left - cmdClear.Width - 400
    FrameOrder.Left = Me.Width - (FrameOrder.Width) * (-FrameOrder.Visible)
    FrameReloadPos.Left = Me.Width - (FrameReloadPos.Width) * (-FrameReloadPos.Visible)
    FrameFinalPos.Left = Me.Width - (FrameFinalPos.Width) * (-FrameFinalPos.Visible)
    FrameRepHolder.Left = Me.Width - (FrameRepHolder.Width) * (-FrameRepHolder.Visible)
    fillSamplesGrid
End Sub

Private Function numChangerSamples() As Integer
    Dim i As Integer
    numChangerSamples = 0
    For i = SlotMin To (SlotMax - 1)
        If Changer_isHole(i) Then i = i + 1
'        If txtNum(i).Text <> "none" Then
        If LenB(ChangerSamples(i).Filename) <> 0 Then
            numChangerSamples = numChangerSamples + 1
        End If
    Next i
End Function

Public Sub fillSamplesGrid()
    Dim i As Integer
    Dim j As Integer
    Dim doublegridcols As Double
    
    gridSamples.FixedCols = 0
    gridSamples.FixedRows = 1
    gridSamples.Height = Me.Height - 1000
    If cmdOK.Left < FrameOrder.Left Then
        gridSamples.Width = cmdOK.Left - (2 * gridSamples.Left)
    Else
        gridSamples.Width = FrameOrder.Left - (2 * gridSamples.Left)
    End If
    
    gridrows = HoleSlotNum * Int(((gridSamples.Height) / (gridSamples.RowHeight(0)) - 2) / HoleSlotNum)
    If gridrows < HoleSlotNum Then gridrows = HoleSlotNum
    doublegridcols = ((SlotMax - SlotMin) + 1) / gridrows
    If doublegridcols <> Int(doublegridcols) Then doublegridcols = doublegridcols + 1
    gridcols = 2 * Int(doublegridcols)
    gridSamples.Rows = gridrows + 1
    gridSamples.Cols = gridcols
    
    
    For j = 0 To gridcols - 1
        If j Mod 2 = 0 Then
            gridSamples.ColWidth(j) = Me.TextWidth(Str(SlotMax) & "W")
        Else
            gridSamples.ColWidth(j) = Me.TextWidth("WWWWWWW")
        End If

        For i = 0 To gridrows
            gridSamples.TextMatrix(i, j) = gridContent(i, j)
        Next i
    Next j
    
End Sub


Private Sub cmdClear_Click()
    Clear
End Sub


Public Sub ProcessSamplesToQueue(chgAscend As Boolean, chgLoadReturn As Boolean, chgDoReturn As Boolean, chgRepHolder As Boolean)
    ' This procedure begins processing samples according to the list
    ' of samples in mainchanger.  That form holds a record of the order
    ' and positions of samples that need to be processed.
    '
    ' Revision History:
    '
    '   7-15-99   Geoff Matters     Removed 'Pos' variable, lines marked DELETE
    '   8-30-99   Geoff Matters     Added 'repHolder' arg
    '  11-12-03   Bob Kopp          rewrote to send samples to sample queue
    '  12-13-03   Bob Kopp          removed isAscend


    Dim i As Integer, sampSlot As Integer
    Dim testSAMFile As SampleIndexRegistration
    
    If Not currentPosInitialized Then GetCurrentChangerPos
    
    Set newSampQueue = New SampleCommands
    
    frmProgram.StatBarNew "Processing samples to queue..."

    countFileCalls
    If SampleIndexRegistry.Count = 0 Then Exit Sub
    For i = 1 To SampleIndexRegistry.Count
        If WhichFilesLoaded(i) > 0 Then
         With SampleIndexRegistry(i)
            If .measurementSteps.Count > 1 Then .doBoth = False
            If .doBoth And .doUp Then
                ' Initialize the ".up" file if we are about to do an "up" measurement
                newSampQueue.Add "InitUp", 0, .Filename
            End If
         End With
        End If
    Next i
    
    ' Measure the holder first
    
    newSampQueue.Add "Holder"
    
    i = 1
    Do While sampSlot <> -1                   ' while there is a sample to process
        ' Next sample...
        i = i + 1
        sampSlot = ProcessOrderSlot(i, chgAscend)
        If sampSlot = -1 Then Exit Do
        
        If Changer_isHole(sampSlot) Then
            ' Only perform repeat holder measurements if requested
            ' (For strong samples, holder does not need to be remeasured)
            If chgRepHolder And newSampQueue(newSampQueue.Count).commandType <> "Holder" Then
                newSampQueue.Add "Holder", sampSlot
            End If
        Else
            If isValidSampleIn(sampSlot) Then newSampQueue.Add "Meas", sampSlot
            ' Process slot "sampSlot"
        End If
    Loop
    If chgLoadReturn Then
    ' Move to the hole with the first sample!
         newSampQueue.Add "Goto", (ProcessOrderSlot(2, chgAscend))
    End If
    newSampQueue.Preprocess
    If chgDoReturn Then
        ' Move to the hole with the first sample!
         newSampQueue.Add "Goto", (ProcessOrderSlot(2, chgAscend))
    End If
    
    SampQueue.Assimilate newSampQueue
    frmProgram.StatBarNew vbNullString
End Sub


Public Function GetCurrentChangerPos()
    ' Ask user to specify which sample is currently under the holder
    ' A wrong answer could be disastrous.
    Dim newpos As Double
    Dim rangeStr As String
    
    If currentPosInitialized Then Exit Function
    newpos = -1
    rangeStr = Str(SlotMin) & "-" & Str(SlotMax)
    
    While Not (newpos >= SlotMin And newpos <= SlotMax)
    newpos = val(InputBox("Which sample slot is now under " & _
        "the holder " & rangeStr & "?" & vbCr & "CAREFUL - A wrong answer " & _
        "here could BREAK THE SYSTEM!", "Important!", frmDCMotors.ChangerHole))
    Wend
    
    frmDCMotors.SetChangerHole newpos
    currentPosInitialized = True
End Function

Private Sub cmdOk_Click()
    ' The settings are acceptable to the user, so continue.
    'SetSequenceVariables
    'If IsMasterList Then
     '   ProcessSamplesToQueue
    'End If
    Me.Hide
End Sub

Public Sub cmdSeq_Click()
    ' This procedure requests a little information about the
    ' load order, and automatically assigns samples to sample
    ' changer holes.
    Set fChangerSampOrder = New frmChangerSampOrder
    Load fChangerSampOrder
    fChangerSampOrder.ZOrder
    fChangerSampOrder.Show
End Sub

Private Sub Form_Load()

    ReDim ChangerSamples(SlotMax) As SampleIdentifier
    
    IsMasterList = False
    Me.Width = 0.8 * frmProgram.Width
    Me.Height = 0.8 * frmProgram.Height
    Me.Left = 0.03 * frmProgram.Width
    Me.Top = 0.03 * frmProgram.Height
    ' set some field properties
    'Dim i As Integer
    'For i = SLOTMIN To (SLOTMAX - 1)
        'If (i Mod HOLESLOTNUM <> 0) Then
            'txtNum(i).Enabled = True
            'txtNum(i).Font = "Arial"
            'txtNum(i).FontSize = 7
        'End If
    'Next i
    optOrder(1).Value = True
    optLoadReturn(0).Value = True
    optReturn(0).Value = True
    RefreshControls
    Clear             ' clear data on the form
End Sub

Private Sub SetSequenceVariables()

    Chg_isAscend = optOrder(0).Value
    'Chg_doReturn = optReturn(0).value
    'Chg_loadReturn = optLoadReturn(0).value
    'Chg_repHolder = optRepeatHolder(0).value
End Sub

Public Sub IncorporateSample(ByVal addHole As Integer, ByVal Filename As String, ByVal Samplename As String)
    If LenB(Filename) = 0 And LenB(Samplename) = 0 Then Exit Sub
    If Changer_ValidSlot(addHole) Then
        With ChangerSamples(addHole)
        If isValidSampleIn(addHole) Then SampleIndexRegistry(.Filename).sampleSet(.Samplename).sampleHole = 0
        If SampleIndexRegistry.IsValidSample(Filename, Samplename) Then
            .Filename = Filename
            .Samplename = Samplename
            If IsMasterList Then
                SampleIndexRegistry(.Filename).sampleSet(.Samplename).sampleHole = addHole
            End If
        Else
            .Filename = vbNullString
            .Samplename = vbNullString
        End If
        End With
    End If
End Sub


Public Sub ShiftSamples(ShiftStart As Integer, ShiftEnd As Integer, ShiftSize As Integer)
    Dim i As Integer
    If Not (Changer_ValidStart(ShiftStart) And Changer_ValidStart(ShiftEnd)) Then Exit Sub
    If ShiftStart > ShiftEnd Then Exit Sub
    If ShiftSize > 0 Then
        For i = ShiftEnd To ShiftStart Step -1
            i = SkipHoles(i, False)
            If SkipHoles(i - ShiftSize, False) < ShiftStart Then Exit For
            With ChangerSamples((SkipHoles(i - ShiftSize, False)))
                IncorporateSample i, .Filename, .Samplename
            End With
        Next i
    Else
        For i = ShiftStart To ShiftEnd Step 1
            i = SkipHoles(i, True)
            If SkipHoles(i - ShiftSize, True) > ShiftEnd Then Exit For
            With ChangerSamples((SkipHoles(i - ShiftSize, True)))
                IncorporateSample i, .Filename, .Samplename
            End With
        Next i
    End If
    RefreshControls
End Sub

Public Function SkipHoles(slotpos As Integer, asc As Boolean) As Integer
    ' This function returns slotpos if the slot is valid.
    ' Otherwise, it returns the number of the next valid slot,
    ' incrementing if asc is true, decrementing if not

    If Changer_isHole(slotpos) Then
        ' We need a valid slot that is not a hole
        If asc Then
            slotpos = slotpos + 1               ' Increment
        Else
            slotpos = slotpos - 1               ' Decrement
        End If
    End If
    SkipHoles = slotpos
End Function


Public Function ProcessOrderSlot(ByVal processnum As Integer, _
    isAscend As Boolean) As Integer
    ' This function should return the n'th slot to process when
    ' using the sample changer. Return -1 if we've already "passed" the
    ' last sample.  This returns slots in sequential order, starting from
    ' the lowest numbered slot with a sample in it.  It skips slots that
    ' do not contain samples, but includes "red" slots (for holder
    ' measurements).
    
    ' It needs upgrading to handle samples across the line.
    
    Dim i As Integer, j As Integer
    ' curNum        - current item we're looking for (holes and samples)
    ' curSlot       - current slot we're looking at
    ' samplespassed - actual number of samples we've skipped past
    Dim curSlot As Integer, curNum As Integer, samplespassed As Integer
    
    ProcessOrderSlot = -1
    
    If processnum = 1 Then Exit Function
    
    ' Find the slot of the correct "item" to process
    curNum = 2
    curSlot = FirstSlot
    samplespassed = 0
    If curSlot = -1 Then Exit Function
    While samplespassed < numChangerSamples And ProcessOrderSlot = -1
        If curSlot < SlotMin Then curSlot = SlotMax
        If curSlot > SlotMax Then curSlot = SlotMin
        
        If Changer_isHole(curSlot) Then
            If Changer_isHole(curSlot) Then
                If curNum = processnum Then ProcessOrderSlot = curSlot
                curNum = curNum + 1
            End If
        ElseIf LenB(ChangerSamples(curSlot).Samplename) <> 0 Then
            If curNum = processnum Then ProcessOrderSlot = curSlot
            curNum = curNum + 1
            samplespassed = samplespassed + 1
        End If
        If isAscend Then
            curSlot = curSlot + 1
        Else
            curSlot = curSlot - 1
        End If
    Wend
End Function


Private Function holeGridPosition(holeNum As Integer, row As Boolean) As Integer
    If row Then
        holeGridPosition = (holeNum - SlotMin) Mod (gridrows) + gridSamples.FixedRows
    Else
        holeGridPosition = ((holeNum - SlotMin) \ gridcols) * 2 + 1
    End If
End Function

Private Function gridHole(row As Integer, column As Integer) As Integer
    Dim holeLabel As Boolean
    Dim holeid As Integer
    If (row = 0) Then
        gridHole = -1
    Else
        If column Mod 2 = 0 Then holeLabel = True
        holeid = (column \ 2) * gridrows
        holeid = holeid + SlotMin + (row - 1)
        If holeid <= SlotMax And holeid >= SlotMin Then
            If holeLabel Then
                gridHole = -2
            Else
                gridHole = holeid
            End If
        Else
            gridHole = -3
        End If
    End If

End Function

Private Function gridContent(row As Integer, column As Integer) As String
    Dim holeLabel As Boolean
    Dim holeid As Integer
    holeid = gridHole(row, column)
    If (holeid = -1) Then
        If column Mod 2 = 0 Then
            gridContent = "Hole"
        Else
            gridContent = "Sample"
        End If
    Else
        If holeid = -2 Then
            holeLabel = True
            holeid = gridHole(row, column + 1)
        End If
        If holeid = -3 Then Exit Function
        If holeLabel Then
            gridContent = Str(holeid)
        Else
            If Changer_isHole(holeid) Then
                gridContent = " ---------- "
            Else
                gridContent = ChangerSamples(holeid).Samplename
            End If
        End If
    End If
End Function

Private Sub gridsamples_mousedown(Button As Integer, _
      Shift As Integer, x As Single, y As Single)
    Dim holeid As Integer
    
    'If Button <> vbRightButton Then Exit Sub
    holeid = gridHole(gridSamples.row, gridSamples.Col)
    If Changer_ValidStart(holeid) And Not Changer_isHole(holeid) Then
        If SampleIndexRegistry.IsValidSample(ChangerSamples(holeid).Filename, ChangerSamples(holeid).Samplename) And (Not Changer_isHole(holeid)) Then
            mnuSampleInfo.Visible = True
            mnuSampleDelete.Visible = True
            mnuSampleDeleteAndShift.Visible = True
            PopupMenu mnuSample
        Else
            mnuSampleInfo.Visible = False
            mnuSampleDelete.Visible = False
            mnuSampleDeleteAndShift.Visible = False
            PopupMenu mnuSample
        End If
    End If
End Sub

Private Sub mnuSampleDeleteAndShift_click()
    Dim holeid As Integer
    holeid = gridHole(gridSamples.row, gridSamples.Col)
    If Not Changer_ValidStart(holeid) Then Exit Sub
    If SampleIndexRegistry.IsValidSample(ChangerSamples(holeid).Filename, ChangerSamples(holeid).Samplename) And (Not Changer_isHole(holeid)) Then
        emptyHole holeid
        SetSequenceVariables
        If Chg_isAscend Then
            ShiftSamples holeid, SlotMax, -1
        Else
            ShiftSamples SlotMin, holeid, 1
        End If
    
    End If
    
End Sub


Private Sub mnuSampleInfo_Click()
    Dim holeid As Integer
    holeid = gridHole(gridSamples.row, gridSamples.Col)
    If Not Changer_ValidStart(holeid) Then Exit Sub
    'MsgBox "Sample ID: " & Str$(GetSampleId(holeid)) & vbCr & _
        "Sample Name: " & samplesList(holeid) & vbCr & _
        "Sample File: " & SamFileRegistry(samplesFiles(holeid)).filename, vbOKOnly, "Sample Info - Hole " & Str$(holeid)
End Sub

Public Sub emptyHole(holeid As Integer)
    If Changer_ValidStart(holeid) And Not Changer_isHole(holeid) Then
        With ChangerSamples(holeid)
            If IsMasterList Then
                If SampleIndexRegistry.IsValidSample(.Filename, .Samplename) Then
                    SampleIndexRegistry(.Filename).sampleSet(.Samplename).sampleHole = 0
                End If
            End If
            .Filename = vbNullString
            .Samplename = vbNullString
        End With
        fillSamplesGrid
    End If
End Sub

Private Sub mnuSampleDelete_Click()
    Dim holeid As Integer
    holeid = gridHole(gridSamples.row, gridSamples.Col)
    If Not Changer_ValidStart(holeid) Then Exit Sub
    If SampleIndexRegistry.IsValidSample(ChangerSamples(holeid).Filename, ChangerSamples(holeid).Samplename) And (Not Changer_isHole(holeid)) Then
        emptyHole holeid
    End If
End Sub

'-----------------------------------------------------------------------------
'  FirstSlot
'
'  Description:       This function returns the slot of the first sample.
'
'  Revision History:
'      Albert Hsiao   2.24.99     initial revision
'      Albert Hsiao   4.12.99     fixed bugs!
'      Bob Kopp       11.24.03    rewritten for registry
'
Public Function FirstSlot() As Integer
    Dim i As Integer, j As Integer, k As Integer
    
    FirstSlot = -1
    If SampleIndexRegistry.Count = 0 Then Exit Function
    For i = 1 To SampleIndexRegistry.Count
        With SampleIndexRegistry(i).sampleSet
        If .Count = 0 Then GoTo carryforth
        ' Start looking for the lowest numbered sample
        If Chg_isAscend Then
            For k = 1 To .Count
                For j = 1 To (SlotMax - 1)
                    If Changer_isHole(j) Then j = j + 1
                    If ChangerSamples(j).Samplename = .Item(k).Samplename And ChangerSamples(j).Filename = SampleIndexRegistry(i).Filename Then
                        FirstSlot = j
                        k = .Count
                        Exit For
                    End If
                Next j
            Next k
        Else
            For k = 1 To .Count
                For j = (SlotMax - 1) To SlotMin Step -1
                    If Changer_isHole(j) Then j = j - 1
                    If ChangerSamples(j).Samplename = .Item(k).Samplename And ChangerSamples(j).Filename = SampleIndexRegistry(i).Filename Then
                        FirstSlot = j
                        k = .Count
                        Exit For
                    End If
                Next j
            Next k
        End If
carryforth:
        If FirstSlot <> -1 Then Exit For
        End With
    Next i
End Function

