VERSION 5.00
Object = "{6B7E6392-850A-101B-AFC0-4210102A8DA7}#1.3#0"; "COMCTL32.OCX"
Begin VB.Form frmMeasure 
   BorderStyle     =   4  'Fixed ToolWindow
   Caption         =   "Measurement Window"
   ClientHeight    =   7455
   ClientLeft      =   30
   ClientTop       =   285
   ClientWidth     =   5565
   ControlBox      =   0   'False
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MDIChild        =   -1  'True
   MinButton       =   0   'False
   ScaleHeight     =   7455
   ScaleWidth      =   5565
   Visible         =   0   'False
   Begin VB.CommandButton buttonPause 
      Caption         =   "Pause run"
      Height          =   372
      Left            =   4200
      TabIndex        =   72
      Top             =   1560
      Width           =   1092
   End
   Begin VB.CommandButton buttonHalt 
      Caption         =   "Halt run"
      Height          =   372
      Left            =   2880
      TabIndex        =   71
      Top             =   1560
      Width           =   1092
   End
   Begin VB.CommandButton cmdPrint 
      Caption         =   "&Print"
      Height          =   345
      Left            =   1320
      TabIndex        =   66
      Top             =   1560
      Width           =   858
   End
   Begin VB.Frame framStats 
      Height          =   2052
      Left            =   240
      TabIndex        =   45
      Top             =   5040
      Width           =   5055
      Begin VB.CommandButton cmdStats 
         Caption         =   "&Show Stats"
         Enabled         =   0   'False
         Height          =   372
         Left            =   3720
         TabIndex        =   67
         Top             =   240
         Width           =   1092
      End
      Begin VB.Label Label18 
         Alignment       =   2  'Center
         Caption         =   "CSD"
         Height          =   255
         Left            =   3480
         TabIndex        =   74
         Top             =   840
         Width           =   495
      End
      Begin VB.Label lblCSD 
         Alignment       =   2  'Center
         BackColor       =   &H80000005&
         BorderStyle     =   1  'Fixed Single
         Height          =   255
         Left            =   3360
         TabIndex        =   73
         Top             =   1080
         Width           =   855
      End
      Begin VB.Label lblavgmag 
         Alignment       =   2  'Center
         BackColor       =   &H80000005&
         BorderStyle     =   1  'Fixed Single
         Height          =   252
         Left            =   240
         TabIndex        =   70
         Top             =   1080
         Width           =   852
      End
      Begin VB.Label Label6 
         Alignment       =   2  'Center
         Caption         =   "Moment"
         Height          =   255
         Left            =   240
         TabIndex        =   69
         Top             =   840
         Width           =   855
      End
      Begin VB.Label lblAvgDec 
         Alignment       =   2  'Center
         BackColor       =   &H80000005&
         BorderStyle     =   1  'Fixed Single
         Height          =   255
         Left            =   1710
         TabIndex        =   61
         Top             =   1080
         Width           =   735
      End
      Begin VB.Label lblAvgInc 
         Alignment       =   2  'Center
         BackColor       =   &H80000005&
         BorderStyle     =   1  'Fixed Single
         Height          =   255
         Left            =   2550
         TabIndex        =   60
         Top             =   1080
         Width           =   735
      End
      Begin VB.Label Label30 
         Alignment       =   2  'Center
         Caption         =   "Inc"
         Height          =   255
         Left            =   2550
         TabIndex        =   59
         Top             =   840
         Width           =   735
      End
      Begin VB.Label Label29 
         Alignment       =   2  'Center
         Caption         =   "Dec"
         Height          =   255
         Left            =   1710
         TabIndex        =   58
         Top             =   840
         Width           =   735
      End
      Begin VB.Label lblDSigInduced 
         Alignment       =   2  'Center
         BackColor       =   &H80000005&
         BorderStyle     =   1  'Fixed Single
         Height          =   252
         Left            =   3504
         TabIndex        =   57
         Top             =   1692
         Width           =   1320
      End
      Begin VB.Label lblDSigDrift 
         Alignment       =   2  'Center
         BackColor       =   &H80000005&
         BorderStyle     =   1  'Fixed Single
         Height          =   252
         Left            =   240
         TabIndex        =   56
         Top             =   1692
         Width           =   1320
      End
      Begin VB.Label lblDSigHolder 
         Alignment       =   2  'Center
         BackColor       =   &H80000005&
         BorderStyle     =   1  'Fixed Single
         Height          =   252
         Left            =   1884
         TabIndex        =   55
         Top             =   1692
         Width           =   1320
      End
      Begin VB.Label Label25 
         Caption         =   "Signal/Drift:"
         Height          =   252
         Left            =   240
         TabIndex        =   54
         Top             =   1452
         Width           =   1320
      End
      Begin VB.Label Label24 
         Caption         =   "Signal/Holder:"
         Height          =   252
         Left            =   1884
         TabIndex        =   53
         Top             =   1452
         Width           =   1320
      End
      Begin VB.Label Label23 
         Caption         =   "Signal/Induced:"
         Height          =   252
         Left            =   3504
         TabIndex        =   52
         Top             =   1452
         Width           =   1308
      End
      Begin VB.Label Label22 
         Alignment       =   2  'Center
         Caption         =   "Avg. Z"
         Height          =   253
         Left            =   2167
         TabIndex        =   51
         Top             =   242
         Width           =   858
      End
      Begin VB.Label Label21 
         Alignment       =   2  'Center
         Caption         =   "Avg. Y"
         Height          =   253
         Left            =   1210
         TabIndex        =   50
         Top             =   242
         Width           =   858
      End
      Begin VB.Label Label16 
         Alignment       =   2  'Center
         Caption         =   "Avg. X"
         Height          =   253
         Left            =   242
         TabIndex        =   49
         Top             =   242
         Width           =   847
      End
      Begin VB.Label lblavgx 
         Alignment       =   2  'Center
         BackColor       =   &H80000005&
         BorderStyle     =   1  'Fixed Single
         Height          =   253
         Left            =   242
         TabIndex        =   48
         Top             =   484
         Width           =   847
      End
      Begin VB.Label lblavgy 
         Alignment       =   2  'Center
         BackColor       =   &H80000005&
         BorderStyle     =   1  'Fixed Single
         Height          =   253
         Left            =   1199
         TabIndex        =   47
         Top             =   484
         Width           =   858
      End
      Begin VB.Label lblavgz 
         Alignment       =   2  'Center
         BackColor       =   &H80000005&
         BorderStyle     =   1  'Fixed Single
         Height          =   253
         Left            =   2167
         TabIndex        =   46
         Top             =   484
         Width           =   858
      End
   End
   Begin ComctlLib.StatusBar sbComm 
      Align           =   2  'Align Bottom
      Height          =   210
      Left            =   0
      TabIndex        =   44
      Top             =   7245
      Width           =   5565
      _ExtentX        =   9816
      _ExtentY        =   370
      SimpleText      =   ""
      _Version        =   327682
      BeginProperty Panels {0713E89E-850A-101B-AFC0-4210102A8DA7} 
         NumPanels       =   3
         BeginProperty Panel1 {0713E89F-850A-101B-AFC0-4210102A8DA7} 
            AutoSize        =   1
            Object.Width           =   5477
            Key             =   ""
            Object.Tag             =   ""
         EndProperty
         BeginProperty Panel2 {0713E89F-850A-101B-AFC0-4210102A8DA7} 
            Object.Width           =   2117
            MinWidth        =   2117
            Key             =   ""
            Object.Tag             =   ""
         EndProperty
         BeginProperty Panel3 {0713E89F-850A-101B-AFC0-4210102A8DA7} 
            Object.Width           =   2117
            MinWidth        =   2117
            Key             =   ""
            Object.Tag             =   ""
         EndProperty
      EndProperty
   End
   Begin VB.CommandButton cmdHide 
      Caption         =   "&Hide"
      Height          =   345
      Left            =   240
      TabIndex        =   43
      Top             =   1560
      Width           =   858
   End
   Begin VB.Frame Frame1 
      Height          =   2892
      Left            =   240
      TabIndex        =   8
      Top             =   2016
      Width           =   5055
      Begin VB.Label lblCalcInc 
         Alignment       =   2  'Center
         BackColor       =   &H80000005&
         BorderStyle     =   1  'Fixed Single
         Height          =   255
         Index           =   3
         Left            =   4080
         TabIndex        =   42
         Top             =   2400
         Width           =   735
      End
      Begin VB.Label lblCalcInc 
         Alignment       =   2  'Center
         BackColor       =   &H80000005&
         BorderStyle     =   1  'Fixed Single
         Height          =   255
         Index           =   1
         Left            =   4080
         TabIndex        =   41
         Top             =   1680
         Width           =   735
      End
      Begin VB.Label lblCalcInc 
         Alignment       =   2  'Center
         BackColor       =   &H80000005&
         BorderStyle     =   1  'Fixed Single
         Height          =   255
         Index           =   2
         Left            =   4080
         TabIndex        =   40
         Top             =   2040
         Width           =   735
      End
      Begin VB.Label lblCalcInc 
         Alignment       =   2  'Center
         BackColor       =   &H80000005&
         BorderStyle     =   1  'Fixed Single
         Height          =   255
         Index           =   0
         Left            =   4080
         TabIndex        =   39
         Top             =   1320
         Width           =   735
      End
      Begin VB.Label lblCalcDec 
         Alignment       =   2  'Center
         BackColor       =   &H80000005&
         BorderStyle     =   1  'Fixed Single
         Height          =   255
         Index           =   3
         Left            =   3240
         TabIndex        =   38
         Top             =   2400
         Width           =   735
      End
      Begin VB.Label lblCalcDec 
         Alignment       =   2  'Center
         BackColor       =   &H80000005&
         BorderStyle     =   1  'Fixed Single
         Height          =   255
         Index           =   1
         Left            =   3240
         TabIndex        =   37
         Top             =   1680
         Width           =   735
      End
      Begin VB.Label lblCalcDec 
         Alignment       =   2  'Center
         BackColor       =   &H80000005&
         BorderStyle     =   1  'Fixed Single
         Height          =   255
         Index           =   2
         Left            =   3240
         TabIndex        =   36
         Top             =   2040
         Width           =   735
      End
      Begin VB.Label lblCalcDec 
         Alignment       =   2  'Center
         BackColor       =   &H80000005&
         BorderStyle     =   1  'Fixed Single
         Height          =   255
         Index           =   0
         Left            =   3240
         TabIndex        =   35
         Top             =   1335
         Width           =   735
      End
      Begin VB.Label lblMeasZ 
         Alignment       =   2  'Center
         BackColor       =   &H00C0E0FF&
         BorderStyle     =   1  'Fixed Single
         Height          =   255
         Index           =   3
         Left            =   2160
         TabIndex        =   34
         Top             =   2400
         Width           =   855
      End
      Begin VB.Label lblMeasZ 
         Alignment       =   2  'Center
         BackColor       =   &H00C0E0FF&
         BorderStyle     =   1  'Fixed Single
         Height          =   255
         Index           =   1
         Left            =   2160
         TabIndex        =   33
         Top             =   1680
         Width           =   855
      End
      Begin VB.Label lblMeasZ 
         Alignment       =   2  'Center
         BackColor       =   &H00C0E0FF&
         BorderStyle     =   1  'Fixed Single
         Height          =   255
         Index           =   2
         Left            =   2160
         TabIndex        =   32
         Top             =   2040
         Width           =   855
      End
      Begin VB.Label lblMeasZ 
         Alignment       =   2  'Center
         BackColor       =   &H00C0E0FF&
         BorderStyle     =   1  'Fixed Single
         Height          =   255
         Index           =   0
         Left            =   2160
         TabIndex        =   31
         Top             =   1320
         Width           =   855
      End
      Begin VB.Label lblMeasY 
         Alignment       =   2  'Center
         BackColor       =   &H00FFC0C0&
         BorderStyle     =   1  'Fixed Single
         Height          =   255
         Index           =   3
         Left            =   1200
         TabIndex        =   30
         Top             =   2400
         Width           =   855
      End
      Begin VB.Label lblMeasY 
         Alignment       =   2  'Center
         BackColor       =   &H00FFC0C0&
         BorderStyle     =   1  'Fixed Single
         Height          =   255
         Index           =   1
         Left            =   1200
         TabIndex        =   29
         Top             =   1680
         Width           =   855
      End
      Begin VB.Label lblMeasY 
         Alignment       =   2  'Center
         BackColor       =   &H00C0FFC0&
         BorderStyle     =   1  'Fixed Single
         Height          =   255
         Index           =   2
         Left            =   1200
         TabIndex        =   28
         Top             =   2040
         Width           =   855
      End
      Begin VB.Label lblMeasY 
         Alignment       =   2  'Center
         BackColor       =   &H00C0FFC0&
         BorderStyle     =   1  'Fixed Single
         Height          =   255
         Index           =   0
         Left            =   1200
         TabIndex        =   27
         Top             =   1320
         Width           =   855
      End
      Begin VB.Label lblMeasX 
         Alignment       =   2  'Center
         BackColor       =   &H00C0FFC0&
         BorderStyle     =   1  'Fixed Single
         Height          =   252
         Index           =   3
         Left            =   240
         TabIndex        =   26
         Top             =   2400
         Width           =   850
      End
      Begin VB.Label lblMeasX 
         Alignment       =   2  'Center
         BackColor       =   &H00C0FFC0&
         BorderStyle     =   1  'Fixed Single
         Height          =   252
         Index           =   1
         Left            =   240
         TabIndex        =   25
         Top             =   1680
         Width           =   850
      End
      Begin VB.Label lblMeasX 
         Alignment       =   2  'Center
         BackColor       =   &H00FFC0C0&
         BorderStyle     =   1  'Fixed Single
         Height          =   252
         Index           =   2
         Left            =   240
         TabIndex        =   24
         Top             =   2040
         Width           =   850
      End
      Begin VB.Label lblMeasX 
         Alignment       =   2  'Center
         BackColor       =   &H00FFC0C0&
         BorderStyle     =   1  'Fixed Single
         Height          =   252
         Index           =   0
         Left            =   240
         TabIndex        =   23
         Top             =   1320
         Width           =   850
      End
      Begin VB.Label lblMeasZZero 
         Alignment       =   2  'Center
         BackColor       =   &H00C0E0FF&
         BorderStyle     =   1  'Fixed Single
         Height          =   255
         Index           =   1
         Left            =   2160
         TabIndex        =   22
         Top             =   720
         Width           =   855
      End
      Begin VB.Label lblMeasYZero 
         Alignment       =   2  'Center
         BackColor       =   &H00C0FFC0&
         BorderStyle     =   1  'Fixed Single
         Height          =   255
         Index           =   1
         Left            =   1200
         TabIndex        =   21
         Top             =   720
         Width           =   855
      End
      Begin VB.Label lblMeasXZero 
         Alignment       =   2  'Center
         BackColor       =   &H00FFC0C0&
         BorderStyle     =   1  'Fixed Single
         Height          =   252
         Index           =   1
         Left            =   240
         TabIndex        =   20
         Top             =   720
         Width           =   850
      End
      Begin VB.Label lblMeasZZero 
         Alignment       =   2  'Center
         BackColor       =   &H00C0E0FF&
         BorderStyle     =   1  'Fixed Single
         Height          =   255
         Index           =   0
         Left            =   2160
         TabIndex        =   19
         Top             =   480
         Width           =   855
      End
      Begin VB.Label lblMeasYZero 
         Alignment       =   2  'Center
         BackColor       =   &H00C0FFC0&
         BorderStyle     =   1  'Fixed Single
         Height          =   255
         Index           =   0
         Left            =   1200
         TabIndex        =   18
         Top             =   480
         Width           =   855
      End
      Begin VB.Label lblMeasXZero 
         Alignment       =   2  'Center
         BackColor       =   &H00FFC0C0&
         BorderStyle     =   1  'Fixed Single
         Height          =   252
         Index           =   0
         Left            =   240
         TabIndex        =   17
         Top             =   480
         Width           =   850
      End
      Begin VB.Label Label7 
         Alignment       =   2  'Center
         Caption         =   "X"
         Height          =   252
         Left            =   240
         TabIndex        =   16
         Top             =   1080
         Width           =   850
      End
      Begin VB.Label Label8 
         Alignment       =   2  'Center
         Caption         =   "Y"
         Height          =   255
         Left            =   1200
         TabIndex        =   15
         Top             =   1080
         Width           =   855
      End
      Begin VB.Label Label9 
         Alignment       =   2  'Center
         Caption         =   "Z"
         Height          =   255
         Left            =   2160
         TabIndex        =   14
         Top             =   1080
         Width           =   855
      End
      Begin VB.Label Label10 
         Alignment       =   2  'Center
         Caption         =   "Dec"
         Height          =   255
         Left            =   3240
         TabIndex        =   13
         Top             =   1080
         Width           =   735
      End
      Begin VB.Label Label11 
         Alignment       =   2  'Center
         Caption         =   "Inc"
         Height          =   255
         Left            =   4080
         TabIndex        =   12
         Top             =   1080
         Width           =   735
      End
      Begin VB.Label Label12 
         Caption         =   "XZero:"
         Height          =   255
         Left            =   285
         TabIndex        =   11
         Top             =   240
         Width           =   780
      End
      Begin VB.Label Label13 
         Caption         =   "YZero:"
         Height          =   255
         Left            =   1245
         TabIndex        =   10
         Top             =   240
         Width           =   780
      End
      Begin VB.Label Label14 
         Caption         =   "ZZero:"
         Height          =   255
         Left            =   2205
         TabIndex        =   9
         Top             =   240
         Width           =   780
      End
   End
   Begin VB.Label Label5 
      Alignment       =   2  'Center
      Caption         =   "Dec"
      Height          =   252
      Left            =   480
      TabIndex        =   68
      Top             =   5280
      Visible         =   0   'False
      Width           =   732
   End
   Begin VB.Label Label2 
      Caption         =   "Directions:"
      Height          =   253
      Left            =   242
      TabIndex        =   65
      Top             =   968
      Width           =   858
   End
   Begin VB.Label Label15 
      Caption         =   "Measuring:"
      Height          =   253
      Left            =   1815
      TabIndex        =   64
      Top             =   968
      Width           =   858
   End
   Begin VB.Label lblDirs 
      Alignment       =   2  'Center
      BackColor       =   &H80000005&
      BorderStyle     =   1  'Fixed Single
      Height          =   252
      Left            =   1092
      TabIndex        =   63
      Top             =   960
      Width           =   492
   End
   Begin VB.Label lblMeasDir 
      Alignment       =   2  'Center
      BackColor       =   &H80000005&
      BorderStyle     =   1  'Fixed Single
      Height          =   253
      Left            =   2662
      TabIndex        =   62
      Top             =   968
      Width           =   495
   End
   Begin VB.Label lblDataFileName 
      BackColor       =   &H80000005&
      BorderStyle     =   1  'Fixed Single
      Height          =   253
      Left            =   1078
      TabIndex        =   7
      Top             =   605
      Width           =   3223
   End
   Begin VB.Label lblDemag 
      BackColor       =   &H80000005&
      BorderStyle     =   1  'Fixed Single
      Height          =   255
      Left            =   4440
      TabIndex        =   6
      Top             =   240
      Width           =   855
   End
   Begin VB.Label lblAvgCycles 
      BackColor       =   &H80000005&
      BorderStyle     =   1  'Fixed Single
      Height          =   255
      Left            =   3120
      TabIndex        =   5
      Top             =   240
      Width           =   495
   End
   Begin VB.Label lblSampName 
      BackColor       =   &H80000005&
      BorderStyle     =   1  'Fixed Single
      Height          =   255
      Left            =   1080
      TabIndex        =   4
      Top             =   240
      Width           =   975
   End
   Begin VB.Label Label4 
      Caption         =   "File Path:"
      Height          =   252
      Left            =   240
      TabIndex        =   3
      Top             =   600
      Width           =   852
   End
   Begin VB.Label Label3 
      Caption         =   "Demag:"
      Height          =   255
      Left            =   3720
      TabIndex        =   2
      Top             =   240
      Width           =   735
   End
   Begin VB.Label Label1 
      Caption         =   "Avg. Cycles"
      Height          =   255
      Index           =   1
      Left            =   2160
      TabIndex        =   1
      Top             =   240
      Width           =   975
   End
   Begin VB.Label Label1 
      Caption         =   "Sample:"
      Height          =   252
      Index           =   0
      Left            =   240
      TabIndex        =   0
      Top             =   240
      Width           =   852
   End
End
Attribute VB_Name = "frmMeasure"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Public Sub SetSample(smp As String)
    ' This procedure sets the name of the current sample
    ' that is being processed by the magnetometer.
    
    lblSampName.Caption = smp
    frmStats.lblSampName.Caption = smp
End Sub



Public Sub SetFields(ByVal steps As Integer, ByVal demag As String, _
    ByVal isUp As Boolean, ByVal isBoth As Boolean, ByVal datafilename As String)
    ' This procedure sets some of the information in the
    ' fields on this form.  It is called by frmMagnetometerControl.
    
    lblAvgCycles.Caption = steps
    lblDemag.Caption = demag
    frmStats.lblAvgCycles.Caption = steps
    frmStats.lblDemag.Caption = demag
    If isUp Then lblMeasDir.Caption = "U" Else lblMeasDir.Caption = "D"
    If isBoth Then lblDirs.Caption = "U/D" _
        Else lblDirs.Caption = lblMeasDir.Caption
    frmStats.lblDirs = lblDirs.Caption
    lblDataFileName = datafilename
    frmStats.lblDataFileName = datafilename
End Sub

Private Sub buttonHalt_Click()
    Flow_Halt
    updateFlowStatus
    Unload Me
End Sub

Private Sub buttonPause_Click()
    If Prog_paused Then
        Flow_Resume
    Else
        Flow_Pause
    End If
    updateFlowStatus
End Sub

Private Sub cmdHide_Click()
    ' Update the main form and hide the window.
    frmProgram.mnuViewMeasurement.Checked = False
    Me.Hide
End Sub

Private Sub cmdPrint_Click()
    On Error GoTo ErrorHandler
    Dim x As Integer
    Dim numlines As Integer    ' Number of lines printed here
    numlines = 21
    
    cmdPrint.Enabled = False
    If Print_LinesLeft < numlines Then
        Print_PageBreak
    End If
    Print_Line
    Print_Line "Measurement:"
    Print_Line "Sample - " & lblSampName.Caption
    Print_Line
    Print_Line vbTab & vbTab & _
               "XZero" & vbTab & vbTab & _
               "YZero" & vbTab & vbTab & _
               "ZZero"
    Print_Line "First:" & vbTab & vbTab & _
               lblMeasXZero(0).Caption & vbTab & _
               lblMeasYZero(0).Caption & vbTab & _
               lblMeasZZero(0).Caption
    Print_Line "Second:" & vbTab & vbTab & _
               lblMeasXZero(1).Caption & vbTab & _
               lblMeasYZero(1).Caption & vbTab & _
               lblMeasZZero(1).Caption
    Print_Line
    Print_Line vbTab & vbTab & _
               "X" & vbTab & vbTab & _
               "Y" & vbTab & vbTab & _
               "Z" & vbTab & vbTab & _
               "Dec:" & vbTab & vbTab & _
               "Inc:"
    For x = 0 To 3
        Print_Line vbTab & vbTab & _
                   lblMeasX(x).Caption & vbTab & _
                   lblMeasY(x).Caption & vbTab & _
                   lblMeasZ(x).Caption & vbTab & _
                   lblCalcDec(x).Caption & vbTab & vbTab & _
                   lblCalcInc(x).Caption
    Next x
    Print_Line
    Print_Line vbTab & vbTab & _
               "Avg. X" & vbTab & vbTab & _
               "Avg. Y" & vbTab & vbTab & _
               "Avg. Z" & vbTab & vbTab
    Print_Line vbTab & vbTab & _
               lblavgx.Caption & vbTab & _
               lblavgy.Caption & vbTab & _
               lblavgz.Caption & vbTab
    Print_Line
    Print_Line "Signal / Drift:  " & vbTab & lblDSigDrift.Caption
    Print_Line "Signal / Holder: " & vbTab & lblDSigHolder.Caption
    Print_Line "Signal / Induced:" & vbTab & lblDSigInduced.Caption
    Print_Line
    Exit Sub
    
ErrorHandler:
    MsgBox ("There was a problem printing to the printer.")
End Sub

Private Sub cmdStats_Click()
    cmdStats.Enabled = False
    frmStats.ZOrder
    frmStats.Show
End Sub

Private Sub form_activate()
    If Me.Visible Then
        frmProgram.mnuViewMeasurement.Checked = True
    Else
        ' would this ever happen?
        frmProgram.mnuViewMeasurement.Checked = False
    End If
End Sub

Private Sub Form_Load()
    lblDataFileName.Caption = vbNullString     ' Show file name
    frmMeasure.lblDataFileName = vbNullString
    HideStats
    updateFlowStatus
End Sub

Public Sub updateFlowStatus()
    If Prog_halted Then
        buttonHalt.Enabled = False
        buttonPause.Caption = "Resume run"
    Else
        If Prog_paused Then
            buttonPause.Caption = "Resume run"
            buttonHalt.Enabled = True
        Else
            buttonPause.Caption = "Pause run"
            buttonHalt.Enabled = True
        End If
    End If
End Sub

Public Sub showData(ByVal datX As Double, ByVal datY As Double, _
    ByVal datZ As Double, num As Integer)
    ' This routine displays the data fields in dat in the
    ' appropriate fields in the form. 'num' designates which
    ' fields to display into
    Dim angdat As Measure_Unfolded
    
    Select Case num
        Case 0
            ' Show as First Zero data points
            lblMeasXZero(0).Caption = FormatNumber(datX)
            lblMeasYZero(0).Caption = FormatNumber(datY)
            lblMeasZZero(0).Caption = FormatNumber(datZ)
        Case 1 To 4
            ' Show as Data points
            lblMeasX(num - 1).Caption = FormatNumber(datX)
            lblMeasY(num - 1).Caption = FormatNumber(datY)
            lblMeasZ(num - 1).Caption = FormatNumber(datZ)
        Case 5
            ' Show as Last Zero data points
            lblMeasXZero(1).Caption = FormatNumber(datX)
            lblMeasYZero(1).Caption = FormatNumber(datY)
            lblMeasZZero(1).Caption = FormatNumber(datZ)
    End Select
End Sub

Public Sub ShowAngDat(ByVal dec As Double, ByVal inc As Double, _
    ByVal num As Integer)
    ' This function displays angular data in appropriate boxes
    lblCalcDec(num - 1).Caption = Format$(dec, "##0.0")
    lblCalcInc(num - 1).Caption = Format$(inc, "##0.0")
End Sub

Public Sub ShowStats(ByVal x As Double, ByVal y As Double, ByVal z As Double, _
    ByVal dec As Double, ByVal inc As Double, ByVal SigDrift As Double, _
    ByVal SigHold As Double, ByVal SigInd As Double, ByVal CSD As Double)
    ' This procedure displays statistical information gathered
    ' from a measurement cycle with the magnetometer.
    
    Dim unfolded As Measure_Unfolded
    
    Me.Height = 7860
    framStats.Visible = True
    
    lblavgx.Caption = FormatNumber(x)
    lblavgy.Caption = FormatNumber(y)
    lblavgz.Caption = FormatNumber(z)
    lblavgmag.Caption = Format$(RangeFact * Sqr(x ^ 2 + y ^ 2 + z ^ 2), "0.0000E+")
    lblAvgDec.Caption = Format$(dec, "##0.0")
    lblAvgInc.Caption = Format$(inc, "##0.0")
    lblDSigDrift.Caption = FormatNumber(SigDrift)
    lblDSigHolder.Caption = Format$(SigHold, "0.0000E+")
    lblDSigInduced.Caption = FormatNumber(SigInd)
    lblCSD.Caption = Format$(CSD, "##0.00")
End Sub

Public Sub HideStats()
    ' This procedure hides the statistics frame and resizes
    ' the measurement window
    
    frmStats.Hide
    framStats.Visible = False
    Me.Height = 5484
    Me.Width = 5610
End Sub

Public Sub clearStats()
    ' This procedure clears data from the stat data boxes
    
    frmStats.cmdPrint.Enabled = True
    lblavgx.Caption = vbNullString
    lblavgy.Caption = vbNullString
    lblavgz.Caption = vbNullString
    lblDSigDrift.Caption = vbNullString
    lblDSigHolder.Caption = vbNullString
    lblDSigInduced.Caption = vbNullString
    lblavgmag.Caption = vbNullString
    lblCSD.Caption = vbNullString
End Sub

Public Sub clearData()
    ' This function clears all the currently displayed data.
    Dim i As Integer
    
    cmdPrint.Enabled = True
    lblMeasXZero(0).Caption = vbNullString
    lblMeasYZero(0).Caption = vbNullString
    lblMeasZZero(0).Caption = vbNullString
    lblMeasXZero(1).Caption = vbNullString
    lblMeasYZero(1).Caption = vbNullString
    lblMeasZZero(1).Caption = vbNullString
    For i = 0 To 3
        lblMeasX(i).Caption = vbNullString
        lblMeasY(i).Caption = vbNullString
        lblMeasZ(i).Caption = vbNullString
        lblCalcInc(i).Caption = vbNullString
        lblCalcDec(i).Caption = vbNullString
    Next i
End Sub
Public Function GetSample() As String
    ' This function returns the name of the current sample
    ' that is being measured.  It assumes we have already
    ' told the form which sample we're measuring at some
    ' previous time.
    
    GetSample = lblSampName.Caption
End Function

Public Function getMeasDir() As Integer
    ' This function returns the current direction of the
    ' arrow on the sample that is being measured. (up/down)
    If lblMeasDir.Caption = "U" Then
        getMeasDir = Magnet_SampleOrientationUp
    Else
        getMeasDir = Magnet_SampleOrientationDown
    End If
End Function
