VERSION 5.00
Object = "{6B7E6392-850A-101B-AFC0-4210102A8DA7}#1.3#0"; "COMCTL32.OCX"
Object = "{38911DA0-E448-11D0-84A3-00DD01104159}#1.1#0"; "COMCT332.OCX"
Begin VB.MDIForm frmProgram 
   AutoShowChildren=   0   'False
   BackColor       =   &H8000000C&
   Caption         =   "Paleomagnetics Magnetometer Control System"
   ClientHeight    =   9030
   ClientLeft      =   120
   ClientTop       =   795
   ClientWidth     =   10755
   LinkTopic       =   "MDIForm1"
   NegotiateToolbars=   0   'False
   WindowState     =   2  'Maximized
   Begin ComCtl3.CoolBar CoolBar1 
      Align           =   1  'Align Top
      Height          =   510
      Left            =   0
      TabIndex        =   1
      Top             =   0
      Width           =   10755
      _ExtentX        =   18971
      _ExtentY        =   900
      BandCount       =   1
      _CBWidth        =   10755
      _CBHeight       =   510
      _Version        =   "6.0.8169"
      MinHeight1      =   450
      Width1          =   1440
      NewRow1         =   0   'False
      Begin VB.CommandButton cmdLogout 
         BackColor       =   &H0080FFFF&
         Caption         =   "Log Out"
         Height          =   255
         Left            =   4080
         MaskColor       =   &H0080FFFF&
         Style           =   1  'Graphical
         TabIndex        =   4
         Top             =   120
         Width           =   1455
      End
      Begin VB.CommandButton cmdMagnetometerControl 
         Appearance      =   0  'Flat
         Caption         =   "Magnetometer Control"
         Height          =   255
         Left            =   1920
         TabIndex        =   3
         Top             =   120
         Width           =   1935
      End
      Begin VB.CommandButton cmdFileRegistry 
         Appearance      =   0  'Flat
         Caption         =   "File Registry"
         Height          =   255
         Left            =   120
         TabIndex        =   2
         Top             =   120
         Width           =   1695
      End
   End
   Begin ComctlLib.StatusBar sbStatusBar 
      Align           =   2  'Align Bottom
      Height          =   270
      Left            =   0
      TabIndex        =   0
      Top             =   8760
      Width           =   10755
      _ExtentX        =   18971
      _ExtentY        =   476
      SimpleText      =   ""
      _Version        =   327682
      BeginProperty Panels {0713E89E-850A-101B-AFC0-4210102A8DA7} 
         NumPanels       =   4
         BeginProperty Panel1 {0713E89F-850A-101B-AFC0-4210102A8DA7} 
            AutoSize        =   1
            Object.Width           =   11800
            Text            =   "Initializing..."
            TextSave        =   "Initializing..."
            Object.Tag             =   ""
         EndProperty
         BeginProperty Panel2 {0713E89F-850A-101B-AFC0-4210102A8DA7} 
            Object.Width           =   2469
            MinWidth        =   2469
            Object.Tag             =   ""
         EndProperty
         BeginProperty Panel3 {0713E89F-850A-101B-AFC0-4210102A8DA7} 
            Object.Width           =   2469
            MinWidth        =   2469
            Object.Tag             =   ""
         EndProperty
         BeginProperty Panel4 {0713E89F-850A-101B-AFC0-4210102A8DA7} 
            Style           =   5
            AutoSize        =   2
            Object.Width           =   1667
            MinWidth        =   1676
            TextSave        =   "1:33 PM"
            Object.Tag             =   ""
         EndProperty
      EndProperty
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin VB.Menu mnuFile 
      Caption         =   "&File"
      NegotiatePosition=   1  'Left
      Begin VB.Menu mnuFileNew 
         Caption         =   "&New"
      End
      Begin VB.Menu mnuFileLogout 
         Caption         =   "&Log out"
      End
      Begin VB.Menu mnuFileExit 
         Caption         =   "&Exit"
      End
   End
   Begin VB.Menu mnuView 
      Caption         =   "&View"
      NegotiatePosition=   1  'Left
      Begin VB.Menu mnuViewStatusBar 
         Caption         =   "Status &Bar"
      End
      Begin VB.Menu mnuViewMeasurement 
         Caption         =   "&Measurement Window"
      End
      Begin VB.Menu mnuViewSampleChanger 
         Caption         =   "Sample &Changer Master List"
      End
      Begin VB.Menu mnuViewQueue 
         Caption         =   "Command &Queue"
      End
      Begin VB.Menu mnuViewStepMonitor 
         Caption         =   "Step Monitor"
      End
      Begin VB.Menu mnuViewDebug 
         Caption         =   "&Debug"
         Visible         =   0   'False
      End
      Begin VB.Menu mnuSpacer 
         Caption         =   "-"
         Index           =   1
      End
      Begin VB.Menu mnuViewSettings 
         Caption         =   "&Settings..."
      End
      Begin VB.Menu mnuViewOptions 
         Caption         =   "1023"
      End
   End
   Begin VB.Menu mnuFlow 
      Caption         =   "&Flow"
      NegotiatePosition=   1  'Left
      Begin VB.Menu mnuFlowRunning 
         Caption         =   "&Running"
         Checked         =   -1  'True
      End
      Begin VB.Menu mnuFlowPaused 
         Caption         =   "&Paused"
      End
      Begin VB.Menu mnuFlowHalted 
         Caption         =   "&Halted"
      End
      Begin VB.Menu mnuFlowSpacer 
         Caption         =   "-"
      End
      Begin VB.Menu mnuFlowCodeOverride 
         Caption         =   "Code &Override"
      End
   End
   Begin VB.Menu mnuDiagnostics 
      Caption         =   "&Diagnostics"
      NegotiatePosition=   1  'Left
      Begin VB.Menu mnuDiagDCMotors 
         Caption         =   "DC &Motors"
      End
      Begin VB.Menu mnuDiagSQUID 
         Caption         =   "&SQUID"
      End
      Begin VB.Menu mnuDiagVacuum 
         Caption         =   "&Vacuum"
      End
      Begin VB.Menu mnuSpacer2 
         Caption         =   "-"
      End
      Begin VB.Menu mnuDiagAF 
         Caption         =   "&AF Demagnetizer"
      End
      Begin VB.Menu mnuDiagIRMARM 
         Caption         =   "&IRM/ARM"
      End
      Begin VB.Menu mnuDiagMCC 
         Caption         =   "&Measurement Computing"
      End
      Begin VB.Menu mnuDiagSusceptibility 
         Caption         =   "Susceptibility &Bridge"
      End
      Begin VB.Menu mnuSpacer9 
         Caption         =   "-"
      End
      Begin VB.Menu mnuDiagVRM 
         Caption         =   "VRM Data Collection"
      End
   End
   Begin VB.Menu mnuWindows 
      Caption         =   "&Windows"
      NegotiatePosition=   1  'Left
      WindowList      =   -1  'True
   End
   Begin VB.Menu mnuHelp 
      Caption         =   "&Help"
      NegotiatePosition=   1  'Left
      Begin VB.Menu mnuHelpIndex 
         Caption         =   "&Index"
      End
      Begin VB.Menu mnuHelpShow 
         Caption         =   "&Show"
      End
      Begin VB.Menu mnuSpacer3 
         Caption         =   "-"
      End
      Begin VB.Menu mnuHelpAbout 
         Caption         =   "1027"
      End
   End
End
Attribute VB_Name = "frmProgram"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
Private Declare Function OSWinHelp% Lib "user32" Alias "WinHelpA" (ByVal hwnd&, ByVal HelpFile$, ByVal wCommand%, dwData As Any)

Const TitleBase = "Paleomagnetic Magnetometer Controller System"

Private readySignals As Integer
Private initialized As Boolean


Public Sub SignalReady()
    readySignals = readySignals + 1
    If readySignals >= 2 Then
        frmMagnetometerControl.Show
        frmSampleIndexRegistry.Show
        
        DoEvents            ' Allow form to refresh first

        If Not initialized Then
            Me.Caption = TitleBase & " (" & MailFromName & ") - [" & LoginName & "]"
            If Not NOCOMM_MODE Then Magnetometer_Initialize Else FLAG_MagnetInit = True
            frmMagnetometerControl.EnableMagnetCmds
            initialized = True
        End If
        
        If DEBUG_MODE Then
            mnuViewDebug.Visible = True
        Else
            mnuViewDebug.Visible = False
        End If
    End If
End Sub


Private Sub cmdLogout_Click()
    Logout
End Sub



Private Sub mdiForm_Load()
    LoadResStrings Me
    
    mnuViewMeasurement.Checked = False
    If DEBUG_MODE Then
       mnuViewDebug.Visible = True
    Else
        mnuViewDebug.Visible = False
    End If
    initialized = False
    Me.Caption = TitleBase & " (" & MailFromName & ")"
End Sub


Private Sub mdiForm_hide()
    If Me.WindowState <> vbMinimized Then
        Config_SaveSetting "Program", "MainWindowLeft", Str$(Me.Left)
        Config_SaveSetting "Program", "MainWindowTop", Str$(Me.Top)
        Config_SaveSetting "Program", "MainWindowHeight", Str$(Me.Height)
        Config_SaveSetting "Program", "MainWindowWidth", Str$(Me.Width)
    End If
End Sub

Public Sub StatusBar(statstring As String, barpart As Integer)
    If barpart < 1 Or barpart > 3 Then Exit Sub
    sbStatusBar.Panels(barpart).Text = statstring
End Sub

Public Sub StatBarNew(statstring As String)
    sbStatusBar.Panels(1).Text = statstring
    sbStatusBar.Panels(2).Text = vbNullString
    sbStatusBar.Panels(3).Text = vbNullString
End Sub


Private Sub mnuDiagAF_Click()
    frmAF.ZOrder
    frmAF.Show
End Sub

Private Sub mnuDiagDCMotors_Click()
    frmDCMotors.ZOrder
    frmDCMotors.Show
End Sub


Public Sub Logout()
    readySignals = 0
    initialized = False
    
    Set SampQueue = Nothing
    Set SampleIndexRegistry = Nothing
    Set SampleHolder = Nothing
    Set SusceptibilityStandard = Nothing
    Set MainChanger = Nothing
    
    frmMagnetometerControl.Hide
    frmSampleIndexRegistry.Hide
    
    
    Unload frmMagnetometerControl
    Unload frmSampleIndexRegistry

    frmMagnetometerControl.DisableMagnetCmds
    
    frmVacuum.ValveConnect False
    frmVacuum.MotorPower False
    
    frmLogin.LoginSucceeded = False
    LoginName = vbNullString
    LoginEmail = vbNullString
    
    Me.Caption = TitleBase & " (" & MailFromName & ")"
    
    DoEvents            ' Allow form to refresh first

    FLAG_MagnetInit = False     ' Magnetometer uninitialized
    FLAG_MagnetUse = False      ' Magnetometer not in use
    
    
    Set SampQueue = New SampleCommands
    Set SampleIndexRegistry = New SampleIndexRegistrations
    
    Set SampleHolder = SampleIndexRegistry("!Holder").sampleSet("Holder")
    Set SusceptibilityStandard = SampleIndexRegistry("!Holder").sampleSet("SusStd")
    
    Set MainChanger = New frmChanger
    MainChanger.IsMasterList = True
    Load MainChanger
    
        
    
    frmTip.ZOrder
    frmLogin.ZOrder
    frmTip.Show
    frmLogin.Show

End Sub



Private Sub mnuDiagVRM_Click()
    frmVRM.ZOrder
    frmVRM.Show
End Sub

Private Sub mnuFileLogout_Click()
    Logout
End Sub

Private Sub mnuFlowCodeOverride_Click()
    If StatusCodeColorLevel = CodeGrey Then
        SetCodeLevel StatusCodeColorLevelPrior
    Else
        SetCodeLevel CodeGrey
    End If
End Sub

Private Sub mnuFlowHalted_Click()
    Flow_Halt
    updateFlowMenu
End Sub

Private Sub mnuDiagIRMARM_Click()
    frmIRMARM.ZOrder
    frmIRMARM.Show
End Sub

Private Sub mnuDiagMCC_Click()
    frmMCC.ZOrder
    frmMCC.Show
End Sub


Private Sub mnuDiagSusceptibility_Click()
    frmSusceptibilityMeter.ZOrder
    frmSusceptibilityMeter.Show
End Sub

Private Sub mnuHelpIndex_Click()
    frmHelp.loadHelpFile "index.html"
    frmHelp.ZOrder
    frmHelp.Show
End Sub

Private Sub mnuHelpShow_Click()
    frmHelp.ZOrder
    frmHelp.Show
End Sub

Private Sub mnuViewDebug_click()
    frmDebug.ZOrder
    frmDebug.Show
End Sub

Private Sub mnuViewQueue_Click()
    frmSampleQueueMonitor.ZOrder
    frmSampleQueueMonitor.Show
End Sub

Private Sub mnuFileExit_Click()
    ' Exit Program
    End
End Sub


Private Sub mnuHelpAbout_Click()
    frmAbout.ZOrder
    frmAbout.Show
End Sub



Private Sub mnuViewSettings_Click()
    frmSettings.ZOrder
    frmSettings.Show
End Sub

Private Sub mnuViewMeasurement_Click()
    If mnuViewMeasurement.Checked Then
        frmMeasure.Hide
        mnuViewMeasurement.Checked = False
    Else
        frmMeasure.ZOrder
        frmMeasure.Show
        mnuViewMeasurement.Checked = True
    End If
End Sub

Private Sub mnuViewOptions_Click()
    frmOptions.ZOrder
    frmOptions.Show
End Sub

Private Sub mnuViewSampleChanger_Click()
    MainChanger.ZOrder
    MainChanger.Show
End Sub

Private Sub mnuViewStatusBar_Click()
    If mnuViewStatusBar.Checked Then
        frmProgram.sbStatusBar.Visible = False
        mnuViewStatusBar.Checked = False
    Else
        frmProgram.sbStatusBar.Visible = True
        mnuViewStatusBar.Checked = True
    End If
End Sub



Public Sub updateFlowMenu()
    If Prog_halted Then
        mnuFlowRunning.Checked = False
        mnuFlowPaused.Checked = False
        mnuFlowHalted.Checked = True
    Else
        If Prog_paused Then
            mnuFlowRunning.Checked = False
            mnuFlowPaused.Checked = True
            mnuFlowHalted.Checked = False
        Else
            mnuFlowRunning.Checked = True
            mnuFlowPaused.Checked = False
            mnuFlowHalted.Checked = False
        End If
    End If
End Sub

Private Sub mnuFlowPaused_Click()
    Flow_Pause
    updateFlowMenu
End Sub

Private Sub mnuFlowRunning_Click()
    Flow_Resume
    updateFlowMenu
End Sub

Private Sub mnuDiagSQUID_Click()
    frmSQUID.ZOrder
    frmSQUID.Show
End Sub



Private Sub mnuDiagVacuum_Click()
    frmVacuum.ZOrder
    frmVacuum.Show
End Sub


Private Sub cmdMagnetometerControl_click()
    frmMagnetometerControl.ZOrder
    frmMagnetometerControl.Show
    frmMagnetometerControl.SetFocus
End Sub

Private Sub cmdFileRegistry_click()
    frmSampleIndexRegistry.ZOrder
    frmSampleIndexRegistry.Show
    frmSampleIndexRegistry.SetFocus
End Sub

Private Sub mdiform_Unload(Cancel As Integer)
    'Dim howsthat As VbMsgBoxResult
    'howsthat = MsgBox("Power vacuum off?", vbYesNo)
    'If howsthat = vbYes Then frmVacuum.MotorPower False
    
    
    ' Disconnect all connections
    frmDCMotors.MotorCommDisconnect
    frmAF.Disconnect
    frmSQUID.Disconnect
    frmVacuum.Disconnect
    frmSusceptibilityMeter.Disconnect
End Sub


Public Sub SetProgramCodeLevel(newLevel As String)
    Select Case newLevel
    Case CodeRed
        BackColor = ColorRed
    Case CodeOrange
        BackColor = ColorOrange
    Case CodeYellow
        BackColor = ColorYellow
    Case CodeGreen
        BackColor = ColorGreen
    Case CodeBlue
        BackColor = ColorBlue
    Case CodeGrey
        BackColor = ColorGrey
    End Select
End Sub

Private Sub mnuViewStepMonitor_Click()
    frmStepMonitor.ZOrder
    frmStepMonitor.Show
End Sub

