% psv_driver.m
%
% Sample program on how to use psv.m (PSV simulation script)
% 
% Kazuo Sone
clear;

% Read from simulation data.
% [simdata,txt] =
% xlsread('..\Phase3_data\phi070\case11\run1_0271\ForPSVcorrection.csv');
load simdata.mat

% Arrange data so that it conforms to the input requirement of psv
% function.
% 
% Do nothing here.

% Use psv function to obtain PSV velocity data from simulation data.
% 
% [PMdata, PSVdata, force, flag] = psv(simdata, 'Al2O3');
[PMdata, PSVdata, force] = psv(simdata, 'Zeeo', 1200, 10000, 50, 2);
% [PMdata2, PSVdata2, force] = psv(simdata, 'Zeeo', 1200, 10000, 200, 1);
% [PMdata2, PSVdata2, force] = psv(simdata, 'Zeeo', 1200, 100000, 1000, 2);
% [PMdata, PSVdata] = psv(simdata, {1.0e-5, 1000, 1.0}, 1600, 8000);
% [PMdata, PSVdata] = psv(simdata, {3.0e-6, 2400, [300 1000.0; 3000 1000.0]}, 1600, 8000);

% Plot the original numerical data in blue.
plot(simdata(:,1), simdata(:,2), 'b', 'LineWidth',2);
hold on;
% Then plot the particle motion in black.
plot(PMdata(:,1), PMdata(:,2),'k:', 'LineWidth',2);
% plot(PMdata2(:,1), PMdata2(:,2), 'b');
% Finally plot the PSV data in red.
plot(PSVdata(:,1), PSVdata(:,2), 'r', 'LineWidth',2);
% plot(PSVdata2(:,1), PSVdata2(:,2), 'g');
legend('Simulation', 'Particle motion', 'Simulated PSV');

disp('saving to psvdata.xls...');
[SUCCESS, MESSAGE] = xlswrite('psvdata.xls', PSVdata);

Suref = 1.0e99;
for i = 1:length(simdata)
    Suref = min(Suref, simdata(i,2));
    if Suref < simdata(i,2)
        break;
    end
end
Suref_sim = Suref;
disp( sprintf('Simulated flame speed is %f', Suref) )

Suref = 1.0e99;
for i = 1:length(PSVdata)
    Suref = min(Suref, PSVdata(i,2));
    if Suref < PSVdata(i,2)
        break;
    end
end
Suref_psv = Suref;
disp( sprintf('PSV flame speed is %f', Suref) )

disp( sprintf('Error is  %f %%', (Suref_psv / Suref_sim-1)*100) )

