load('xml.js')
load('stats.js')

var starttime = new Date();

function analyzeWave(wave,freq)
{
    var result = new Object;
    
    var ft = fourierComponent(wave.data,freq,wave.step,wave.cycles);
    
    if (ft.max >= 127 || ft.min <= -128) throw('Clipping');
    
    result.sin = ft.sin * wave.ymu;
    result.cos = ft.cos * wave.ymu;    
       
    var rising = 0;
    var falling = 0;
    var middle = (ft.max + ft.min) / 2;
    var last = wave.data[0];
    for(var x =0; x< wave.data.length; x++)
    {
     var current = wave.data[x];
     
     if (!rising && (current == middle || (last < middle && current > middle)))
         { rising = Number(x); x += 10; }      
     else if (!falling && (current == middle || (last > middle && current < middle))) 
         { falling = Number(x); x += 10;}
      
     if (falling && rising) break;
     last = wave.data[x];
    }
    
    result.start = (wave.step * rising * freq * 360); /* phase */
    result.stop =  (wave.step * falling * freq * 360); /* phase */
    
    result.mean = ft.mean;

    return result;
}

function daqinfo(sample)
{//frequency, time/division, samples/division
 var waves = sample.find('waveform');
 var measure = sample.find('measurement');
 var freq = Number(measure[0].get('value'));
 var rate = Number(waves[0].get("WFI").match(/([0-9.E\-]+) s\/div/)[1]);
 return freq + ' ' + (1000*rate).toFixed(1) + ' ms/div';
}

function summarizeSample(sample)
{
	//frequency, [ sin, cos] ... 
	
	var waves = sample.find('waveform');
	var measure = sample.find('measurement');
	var freq = Number(measure[0].get('value'));

    write(freq);  	
  	
	var result = new Object;
	result.magnitude = freq.toFixed(3);
	result.phase = freq.toFixed(3);
	result.mean = freq.toFixed(3);
	
	try {
	
 	for (var j in waves)
        {
         //prepare the analysis object
         var wave = new Object;
         
         wave.data = waves[j].cdata.split(',');
         if (wave.data.length != 10000)
         {
         writeln(' missing data');
         return false;
         }
         for(var x in wave.data) wave.data[x] = Number(wave.data[x]); 
	 
	 wave.step = Number(waves[j].get('XIN'));
 	 wave.span = Number(wave.step) * 10000; 
	 wave.rate = Number(waves[j].get("WFI").match(/([0-9.E\-]+) s\/div/)[1]);
 	 wave.cycles = Math.floor(wave.span * freq);
	 wave.vscale = Number(waves[j].get("WFI").match(/([0-9.E\-]+) V\/div/)[1])
	 wave.ymu = Number(waves[j].get('YMU'));
	 wave.voff = Number(waves[j].get('YOF'));        
	 
	 //run the analysis function
     var r = analyzeWave(wave,freq);
         
 	 //save the results
 	 result.magnitude += '\t' + r.sin + '\t' + r.cos;
 	 result.phase +=  '\t' + r.start + '\t' + r.stop;
 	 result.mean +=  '\t' + r.mean;
	 write('\t',Math.sqrt(r.sin*r.sin + r.cos*r.cos).toExponential(1)); 
	 if (j == 3) write('\t',(Math.abs(r.start - r.stop) - 180).toFixed(1));
        } 
        
        } catch(err)
        {
         writeln('error ',err);
         return false;
        }
        
        writeln('');
        return result;
}

function summarizeFile(f,mag,phase,mean,info)
{
  while(!f.eof)
  {
   var sample;
   try {
    sample = readXML(f,'sample,measurement,waveform');
   } catch(x) {writeln(x);}
   if (!sample) break;
  
   if (sample.get('date')=='undefined') continue;
   
   var r = summarizeSample(sample); 
   if (!r) continue;
  
   
   mag.writeln(r.magnitude);
   phase.writeln(r.phase);   
   mean.writeln(r.mean);
   info.writeln(daqinfo(sample));
  }
}


summarizeFile(new Stream('data.xml','rt'),
		new Stream('magnitude.txt','wt'),
		new Stream('phase.txt','wt'),
		new Stream('mean.txt','wt'),
		new Stream('info.txt','wt'));
	
var endtime = new Date();
writeln('Start: ',starttime.toString());
writeln('Finish: ',endtime.toString());
writeln('Elapsed: ',(endtime-starttime)/1000,'s');