load('xml.js')
load('ploteps.js')

var starttime = new Date();

function plotWave(plot,vscale,ymu,yoff,label,data)
{
   plot.trace(data,ymu,10* vscale)
     
   if (vscale >= 1)
      plot.legend(label,(vscale).toFixed(0) + " V/div");
   else
      plot.legend(label, (1000*vscale).toFixed(0) + " mV/div");
      
   plot.origin(yoff*ymu,10*vscale);
}
   
// load data file
var labels=['PDH','DC','X-talk','CHOP'];
  
function plotFile(f)
{
   while(!f.eof)
   {
    var sample;
    try {
     sample = readXML(f,'sample,measurement,waveform');
    } catch(x) {writeln(x);}
    if (!sample) break;
        
 try {
    var measure = sample.find('measurement');
    var waves = sample.find('waveform');
    var freq = Number(measure[0].get('value'));
 writeln(waves.length);
	
    writeln(freq);
    
    var filename = '' + freq.toFixed(1) + ".eps";
    while (filename.length < 10) filename = '0' + filename;
    var outfile = new Stream('img/' + filename,'wt');
    var plot = new Plot(outfile,432,288);
    plot.graticule();

    for (j in waves)
    {
     plot.color(j);
     
     var data = waves[j].cdata.split(',');
     for(var x in data) data[x] = Number(data[x]); 
     	 
     var vscale = Number(waves[j].get("WFI").match(/([0-9.E\-]+) V\/div/)[1])
     var ymu = Number(waves[j].get('YMU'));
     var voff = Number(waves[j].get('YOF'));        
     var rate = Number(waves[j].get("WFI").match(/([0-9.E\-]+) s\/div/)[1]);

     plotWave(plot,vscale,ymu,voff,labels[j],data);
     plot.label(freq,rate);
    }
    
    plot.finish(outfile);
    

    } catch (err)
    {writeln(err);}
   }
}


plotFile(new Stream('data.xml','rt'));

var endtime = new Date();
writeln('Start: ',starttime.toString());
writeln('Finish: ',endtime.toString());
writeln('Elapsed: ',(endtime-starttime)/1000,'s');