
function plotOrigin(pos, vrange)
{
 var x = 0;
 var y = (pos + (vrange/2)) * this.h / vrange;
 
 if (y > 0 && y < this.h) 
 {
  this.eps.writeln('0 ',y.toFixed(2),' moveto 0 4 rlineto 5 -4 rlineto -5 -4 rlineto closepath fill');
 }
}

function plotLogLog(data)
{
 var temp = new Array;
 for (var i in data)
 {
  temp[i] = new Array;
  temp[i][0] = Math.log(Number(data[i][0])) / Math.LN10;
  temp[i][1] = Math.log(Number(data[i][1])) / Math.LN10 ; 
 }
 var range = this.autoRange(this.range(temp));
 this.axisLogX(range[0][1]-range[0][0]);
 this.axisLogY(range[1][1]-range[1][0]);
 
 temp.sort();
 return this.plotXY(temp,range);
}

function plotLogLinear(data)
{
 var temp = new Array;
 for (var i in data)
 {
  temp[i] = new Array;
  temp[i][0] = Math.log(Number(data[i][0])) / Math.LN10;
  temp[i][1] = Number(data[i][1]); 
 }
 
 var range = this.range(temp);
 var ar = this.autoRange(range);
 range[0]=ar[0];

 this.axisLogX(range[0][1]-range[0][0]);
 this.axisLinY(range[1][1]-range[1][0]);
 
 temp.sort();
 return this.plotXY(temp,range);
}

function plotLinearLog(data)
{
 var temp = new Array;
 for (var i in data)
 {
  temp[i] = new Array;
  temp[i][0] = Number(data[i][0]); 
  temp[i][1] = Math.log(Number(data[i][1])) / Math.LN10;
 }
 
 var range = this.range(temp);
 var ar = this.autoRange(range);
 range[1]=ar[1];

 this.axisLinX(range[0][1]-range[0][0]);
 this.axisLogY(range[1][1]-range[1][0]);

 temp.sort();
 return this.plotXY(temp,range);
}

function plotLinX(count)
{
if (!count) return;
 this.eps.writeln('%Axis');
 this.eps.writeln('gsave');
 this.eps.writeln('0.8 setgray [1 ',(this.h/50 - 1).toFixed(2),'] 0 setdash');
 for (var i=1; i<count; i++)
  { 
   this.eps.writeln(this.w * i / count,' 0 moveto 0 ',this.h,' rlineto stroke');
  }
 this.eps.writeln('grestore'); 
}

function plotLinY(count)
{
if (!count) return;
 this.eps.writeln('%Axis');
 this.eps.writeln('gsave');
 this.eps.writeln('0.8 setgray [1 ',(this.w/50 - 1).toFixed(2),'] 0 setdash');
 for (var i=1; i<count; i++)
  { 
   this.eps.writeln('0 ',this.h*i/count,' moveto ', this.w,' 0 rlineto stroke');
  } 
 this.eps.writeln('grestore'); 
}

function plotLogX(decades)
{
if (!decades) return;
 this.eps.writeln('%Axis');
 this.eps.writeln('gsave 0.8 setgray');
 for (var i=0; i<decades; i++)
   { 
    this.eps.writeln(this.w * i / decades,' 0 moveto 0 ',this.h,' rlineto stroke');
   }
   
 this.eps.writeln('[1 ',(this.h/50 - 1).toFixed(2),'] 0 setdash');
 for (var i=0; i<decades; i++)
  { 
   for (var j=1; j < 10; j++)
   this.eps.writeln( (this.w / decades) * (i + Math.log(j)/Math.LN10) ,' 0 moveto 0 ',this.h,' rlineto stroke');
  }
 this.eps.writeln('grestore'); 
}

function plotLogY(decades)
{
if (!decades) return;
 this.eps.writeln('%Axis');
 this.eps.writeln('gsave 0.8 setgray');
 for (var i=0; i<decades; i++)
   { 
    this.eps.writeln('0 ',this.h*i/decades,' moveto ', this.w,' 0 rlineto stroke');
   }
 this.eps.writeln('[1 ',(this.w/50 - 1).toFixed(2),'] 0 setdash');
 for (var i=0; i<decades; i++)
  { 
   for (var j=1; j < 10; j++)
    this.eps.writeln('0 ',(this.h/decades)*(i + Math.log(j)/Math.LN10),' moveto ', this.w,' 0 rlineto stroke');
  } 
  
 this.eps.writeln('grestore'); 
}

function plotAutoRange(r)
{
 r[0][0] = Math.floor(r[0][0]);
 r[1][0] = Math.floor(r[1][0]);
 r[0][1] = Math.ceil(r[0][1]);
 r[1][1] = Math.ceil(r[1][1]);

 return r;
}

function plotRange(data)
{

 var xmax =  Number(data[0][0]);
 var xmin =  Number(data[0][0]);
 var ymax =  Number(data[0][1]);
 var ymin =  Number(data[0][1]);

 for (var i in data)
 {
  if (xmax < data[i][0]) xmax= Number(data[i][0]);
  if (xmin > data[i][0]) xmin= Number(data[i][0]);
  if (ymax < data[i][1]) ymax= Number(data[i][1]);
  if (ymin > data[i][1]) ymin= Number(data[i][1]);
 }
 
 return [[xmin,xmax],[ymin,ymax]];
}

function plotXY(data,range)
{
 
 if (!range) range = this.range(data);
 xmin = range[0][0];
 xmax = range[0][1];
 ymin = range[1][0];
 ymax = range[1][1];
 
 if (xmax == xmin) return;
 if (ymax == ymin) return;
  
 var vrange = ymax - ymin;
 var xrange = (xmax - xmin);
 
 var x = (Number(data[0][0]) - xmin) * this.w / xrange;
 var y = (Number(data[0][1]) - ymin) * this.h / vrange;
  
 if (y < 0) y=0;
 if (y > this.h) y=this.h;
 this.eps.writeln(x.toFixed(2),' ',y.toFixed(2),' m');
 for (var i= 1; i < data.length; i++)
  {
   x = (data[i][0] - xmin) * this.w / xrange;
   y = (data[i][1] - ymin) * this.h / vrange;
   if (y < 0) y=0;
   if (y > this.h) y=this.h;
   
   this.eps.writeln(x.toFixed(2),' ',y.toFixed(2),' l');    
  }
 this.eps.writeln('stroke');
}

function plotLegend(label,label2)
{
 if (label2)
 {
  this.eps.writeln(this.w - 60,' ',this.labely,' m (',label2,') show');  
 }
 if (label)
 {
  this.eps.writeln(this.w - 100,' ',this.labely,' m (',label,') show');
  this.labely -= 15;
 }
}
 
function plotTrace(list, ymu, vrange)
{
 var x = 0;
 var y = (list[0] * ymu + (vrange/2)) * this.h / vrange;
 
 if (y < 0) y=0;
 if (y > this.h) y=this.h;
 this.eps.writeln(x.toFixed(2),' ',y.toFixed(2),' m');
 for (var i=1; i<list.length; i++)
 {
  x = this.w * i / list.length;
  y = (list[i] * ymu  + (vrange/2)) * this.h / vrange;
  if (y < 0) y=0;
  if (y > this.h) y=this.h;
  
  this.eps.writeln(x.toFixed(2),' ',y.toFixed(2),' l'); 
  
 }
 this.eps.writeln('stroke');
}

function plotGraticule(count)
{
 if (!count) count = 10;
 this.eps.writeln('%graticule');
 this.eps.writeln('0.8 setgray [1 ',(this.h/(5*count) - 1).toFixed(2),'] 0 setdash');
 for (var i=1; i<count; i++)
  { 
  if (i == count/2) continue;
  this.eps.writeln(this.w * i / count,' 0 moveto 0 ',this.h,' rlineto stroke');
  }
 this.eps.writeln('0.8 setgray [1 ',(this.w/(5*count) - 1).toFixed(2),'] 0 setdash');
 for (var i=1; i<count; i++)
  { 
  if (i == count/2) continue;
  this.eps.writeln('0 ',this.h*i/count,' moveto ', this.w,' 0 rlineto stroke');
  }
 this.eps.writeln('[] 0 setdash');
 this.eps.writeln(this.w/2,' 0 moveto 0 ',this.h,' rlineto stroke');
 this.eps.writeln('0 ',this.h/2,' moveto ', this.w,' 0 rlineto stroke');
}


function plotHeader()
{
 this.eps.writeln("%!PS-Adobe-3.0 EPSF-3.0");
 this.eps.writeln("%%BoundingBox: 0 0 ",this.w," ",this.h);
 this.eps.writeln("%%PaperSize: ",this.w," ",this.h);
 this.eps.writeln("%%Creator:");
 this.eps.writeln("%%Title:");
 this.eps.writeln("%%DocumentFonts: Courier Helvetica Helvetica-Bold");
 this.eps.writeln("%%DocumentNeededFonts: Courier Helvetica Helvetica-Bold");
 this.eps.writeln("gsave");
 this.eps.writeln("/m {moveto} def /l {lineto} def");
 this.eps.writeln("/Helvetica findfont 10 scalefont setfont");
}

function plotFinish()
{
 this.eps.writeln("grestore");
}

function plotRGB(r,g,b)
{
 this.eps.writeln((r/255).toFixed(3),' ',(g/255).toFixed(3),' ',(b/255).toFixed(3),' setrgbcolor');
}

function plotColor(i)
{
 this.eps.writeln(this.colors[i],' setrgbcolor');
}

function plotLabel(freq, rate)
{
//draw box and labels
this.eps.writeln("0 setgray 0 0 moveto ",this.w," 0 rlineto 0 ",this.h," rlineto -",this.w," 0 rlineto closepath stroke");
this.eps.writeln('5 ',this.h-15,' m (', freq.toFixed(1),' Hz) show');
this.eps.writeln('5 ',this.h-27,' m (', (1000*rate).toFixed(1),' ms/div) show');
}

function Plot(eps,w,h,colors)
{
 if (colors)
   this.colors = this.colors.concat(colors);
 else
   this.colors = ["1 0 0","0 0 1",".75 0 .6","0 .75 0"];
 
 this.w = w;
 this.h = h;
 this.labely = h - 15;
 this.eps = eps;
 this.plotXY = plotXY;
 this.log = plotLinearLog;
 this.linearLog = plotLinearLog;
 this.logLog = plotLogLog;
 this.logLinear = plotLogLinear;
 this.trace = plotTrace;
 this.legend = plotLegend;
 this.finish= plotFinish; 
 this.graticule = plotGraticule;
 this.color = plotColor;
 this.rgbcolor = plotRGB;
 this.label = plotLabel;
 this.header = plotHeader;
 this.origin = plotOrigin;
 this.range = plotRange;
 this.autoRange = plotAutoRange;
 this.axisLogY = plotLogY
 this.axisLogX = plotLogX
 this.axisLinY = plotLinY
 this.axisLinX = plotLinX
 this.header();
}
