/* Set the oscilloscope to 38400 baud, hard flagging, cr/lf */
/* hard flagging will prevent data from being lost before JS can read() */
var acount=0;

function readVal(scope)
{
 var temp = scope.readLine();
 if (temp == "DCL") temp = scope.readLine();
 return temp.toString().split(' ')[1];
}

function readmeas(name,scope,file)
{
    file.write('<measurement');
    var v;

    scope.write("MEASU:MEAS",name,":SOURCE?\r\n");
    v = readVal(scope);
    file.write(' source=',v);
    write(v,' ');

    scope.write("MEASU:MEAS",name,":TYPE?\r\n");
    v = readVal(scope);
    file.write(' type=',v);
    write(v,' ');

    scope.write("MEASU:MEAS",name,":UNITS?\r\n");
    v = readVal(scope);
    file.write(' units=',v);
    write(v,' ');

    scope.write("MEASU:MEAS",name,":VALUE?\r\n");
    v = readVal(scope);
    file.write(' value=',v);
    write(v,' ');

    writeln('')
    file.writeln(" />");
}

var temp = new Stream;

function readch(name,scope,file)
{
scope.write("DATA:SOURCE ",name,"\r\n");
scope.write("DATA:ENC ASCII\r\n");
scope.write("DATA:START 1\r\n");
scope.write("DATA:STOP 10000\r\n");

write(name);
scope.write("WAVF?\r\n");

temp.clear();
scope.readUntil('P:',temp);

var preamble = new Stream;
scope.readUntil(':CURV',preamble);

var setup = new Record;
preamble.rewind();
preamble.readList(setup,';',' ');

file.write('<waveform ');
file.writeList(setup,' ','=');
file.writeln(">");

temp.clear();
scope.readUntil("\n",temp);
write(' ',temp.size,' bytes');
temp.rewind();
file.append(temp);
var z = temp.toString().split(',').length;
acount += z;
writeln(' ',z,' points');
file.writeln("\r\n</waveform>");
if (z != 10000) throw('missing data');
}

var scope = new Stream('com1://38400');
var file = new Stream('data.xml','at');

scope.write("ACQ:STATE STOP\r\n");

scope.write("DATE?\r\n");
var date = readVal(scope);
//var date = scope.readUntil("\n").split(' ')[1];

scope.write("TIME?\r\n");
var time = readVal(scope);
//var time = scope.readUntil("\n").split(' ')[1];

writeln(date,' ',time);

// read ch 1, 3, 4

file.writeln('<sample date=',date,' time=',time,'>');

writeln('measurements');
readmeas(1,scope,file);
readmeas(2,scope,file)
readmeas(3,scope,file);
readmeas(4,scope,file);

writeln('');
writeln('saving waveforms');
//scope.write("SAVE:WAVEFORM CH1,REF1\r\n");
//scope.write("SAVE:WAVEFORM CH2,REF2\r\n");
//scope.write("SAVE:WAVEFORM CH3,REF3\r\n");
//scope.write("SAVE:WAVEFORM CH4,REF4\r\n");
//scope.write("SELECT:REF1 ON\r\n");
//scope.write("SELECT:REF2 ON\r\n");
//scope.write("SELECT:REF3 ON\r\n");
//scope.write("SELECT:REF4 ON\r\n");

/* turn the scope on in sample mode, */
/* to line up for the next measurement */
//scope.write("ACQ:STOPA RUNST \r\n");
//scope.write("ACQ:MODE SAM \r\n");
//scope.write("ACQ:STATE RUN \r\n");

writeln('Reading data');
try {

readch('CH1',scope,file);
sleep(500)
readch('CH2',scope,file);
sleep(500)
readch('CH3',scope,file);
sleep(500)
readch('CH4',scope,file);
sleep(500)

} catch(err) {writeln(err);}
//scope.write("SELECT:REF1 OFF\r\n");
//scope.write("SELECT:REF2 OFF\r\n");
//scope.write("SELECT:REF3 OFF\r\n");
//scope.write("SELECT:REF4 OFF\r\n");

file.writeln("</sample>");
file.close();
writeln('done');

if (acount == 40000)
{scope.write("ACQ:STOPA RUNST \r\n");
scope.write("ACQ:STATE RUN \r\n");
}
sleep(3000);
if (acount == 40000)
{scope.write("ACQ:STOPA SEQ \r\n");
scope.write("ACQ:MODE AVE \r\n");
scope.write("ACQ:STATE RUN \r\n");
}