function stats(wave, freq, timestep, cycles)
{
 var sum = 0.0;
 var min = wave[0];
 var max = wave[0];
 var count = Math.floor(cycles/(freq * timestep));
 for (var i=0; i< count; i++ )
  {   
   if (max < wave[i] ) max = wave[i];
   else if (min > wave[i] ) min = wave[i];
   sum += wave[i];
  }
 return {min: min, max:max, range: (max-min), mean: sum / count};
}

/** calculates the RMS amplitude of the Sine and Cosine components
of the wave */

function fourierComponent(wave, freq, timestep, cycles)
{
 var sum = 0.0;
 var min1 = wave[0];
 var max1 = wave[0];
 var count = Math.floor(cycles/(freq * timestep));
 var start = Math.floor((wave.length - count)/2);
 var end = Math.floor(wave.length - ((wave.length - count)/2));
 var middle = wave.length / 2;
 
 for (var i=start; i< end; i++ )
  {
   if ( max1 < wave[i] ) max1 = wave[i];
   else if ( min1 > wave[i] ) min1 = wave[i];
   
   sum += wave[i];
  }
  
 var mean = sum / count;
 var sum1 = 0.0;
 var sum2 = 0.0;
  
 for (var i=start; i< end; i++ )
 {
  sum1 += Math.sin(2 * Math.PI * (i-middle) * cycles / count) * (wave[i] - mean);
  sum2 += Math.cos(2 * Math.PI * (i-middle) * cycles / count) * (wave[i] - mean);   
 }
 
 sum1 = Math.sqrt(2) * sum1;
 sum2 = Math.sqrt(2) * sum2;
 return {sin: sum1/count, cos: sum2/count, sum: sum, mean: sum/count, max: max1, min: min1};
}