function encodeHTML(str)
{
 var s = str.toString();
 s = s.replace(/\&/g,'&amp;');
 s = s.replace(/\>/g,'&gt;');
 s = s.replace(/\"/g,'&quot;');
 return s.replace(/\</g,'&lt;');  
}

function decodeHTML(str)
{
 var s = str.toString();
 s = s.replace(/&amp;/g,'&');
 s = s.replace(/&gt;/g,'>');
 s = s.replace(/&quot;/g,'"');
 return s.replace(/&lt;/g,'<');  
}

function XML_toString()
{
 var out = new Stream;
 this.toStream(out);
 return out.toString();
}

function XML_toStream(out)
{
 out.write('<', this.name);
  
 if (this.params != null)
 for(var x=0; x<this.params.count; x++)
   out.write(' ',this.params.name(x),'="',encodeURL(this.params.value(x)),'"');

 if (this.children.length > 0 || this.cdata.length > 0)
  {
   out.writeln('>');
   
   for(var x in this.children)
    this.children[x].toStream(out);
 
   if (this.cdata.length)
    {
     if (this.cdata.indexOf('</') != -1)
     {/*looks like included markup data*/
      out.writeln('<![CDATA[',this.cdata,']]>');
     }
     else
     {
      out.writeln(this.cdata);
     }    
    } 
   out.writeln('</',this.name,'>');
 }
 else
  out.writeln(' />');
}


function XML_find(type,field,value)
{
 var ret = new Array(0);
 for(var x in this.children)
  {  
   if (type != null) if (this.children[x].name != type) continue;   
   if (field == null)
     ret.push(this.children[x]);
   else if (this.children[x].get(field) == value)
     ret.push(this.children[x]);   
  }
 return ret;
}

function appendXML(text,allowed)
{
 var result = new Array;
 var infile;
 if (text.className = 'stream')
  infile = text;
 else
 {
  new Stream();
  infile.write(text);
  infile.rewind();
 }

 while (true)
 {
  var tag = readXML(infile,allowed);
  if (tag == null) break;
  result.push(tag);  
 }
 return result;
}

function readXML(stream,allowed)
{
/* Reads a single XML object and all its children: name, properties, children, cdata */
 var parent = null; /*top object on the stack */
 var end = '';
 var stack = new Array;
 var ignore=' BR P B I C TT U /P /B /I /C /TT /U IMG A /A ';

 while (!stream.eof)
 {
  var params = new Record;
  var name = stream.readTag(params,allowed);
  
  /* may be appending cdata to a parent */
  if (parent != null)
  {
   if (name.length == 0)
   {
    parent.cdata += '<>';
    continue;
   }

   if (name == '![CDATA[')
   {
    parent.cdata = stream.tagText;
    delete stream.tagText;
   } 
   
   /* HTML-like markup tags don't count */
   if (name.length <= 3 && name.search('[^/A-Za-z_]') == -1)
   {
    var find = new RegExp(' ' + name + ' ','i');
    if (ignore.search(find) != -1)
     {
      parent.cdata += stream.tagText;
      parent.cdata += '<' + name;
      if (params.length > 0) parent.cdata += ' ' + params.write(' ');
      parent.cdata += '>';
      continue;
     }
   }
  }
  else
  {/* if we just started, wait until we see the start of an object */
   if (name.charAt(0) == '/' || name.length == 0)
   continue;
  }
  
  /* XML control tags don't count */
  if (name.charAt(0) == '?' || name.charAt(0) == '!')
  continue;
  
  if (name == end) /* finish an object */
  {
    parent.cdata += stream.tagText;
    delete stream.tagText;
  
    if (stack.length == 0) return parent; /* just finished the first object */
    
    end = stack.pop();
    parent = stack.pop();    
   }  
  else if (name.charAt(0) == '/')
   { //probably a parse error, so ignore it    
    throw('Parse error at '+stream.pos+' name='+name);
   }
  else /* start a new object */
   {    
    var obj = new XML(name,params,'');  

    if (parent != null)
     {
      parent.children.push(obj);
      parent.cdata += stream.tagText;
     }
     
    if (stream.hasChildren) 
     {      
      if (parent != null)
      {
      stack.push(parent);
      stack.push(new String(end));
      }  
      end = "/" + name;  
      parent = obj;
     }
    else if (parent == null) return obj;
   }
  delete stream.tagText;    
   
 }/*! stream.eof() */
 
 /* the XML file was not terminated, so return the first object */
 /* and assume terminators for the rest */
 return parent;
}

function XML_Has(str)
{
 return this.params.has(str);
}

function XML_Get(str)
{
 if (this.params.has(str))
  return this.params.get(str);
 var ch = this.find(str);
 if (ch == null) return "";
 if (ch.length == 1) return ch[0].cdata;
 return "";
}

function XML_set(str,name,value)
{
 if (this.db != null)
  {
   this.db.set(this.id,name,value);
  }
 return this.params.set(name,value);
}

function XML_Sort(field,reverse)
{
 if (reverse)
  this.children.sort(function comp(x,y){a = x.get(field); b = y.get(field); return a > b ? -1 : a == b ? 0 : 1;})
 else
  this.children.sort(function comp(x,y){a = x.get(field); b = y.get(field); return a < b ? -1 : a == b ? 0 : 1;})
}

function XML(name,params,cdata)
{
 this.name = name;
 if (typeof(params) == 'undefined') 
  this.params = new Record(); 
 else if (typeof(params) == 'string')
  this.params = new Record(params);
 else
  this.params = params;
  
 this.cdata = (cdata == null) ? '' : cdata;
 this.children = new Array;
 this.toStream = XML_toStream;
 this.toString = XML_toString;
 this.get = XML_Get;
 this.find = XML_find;
 this.has = XML_Has;
 this.sort = XML_Sort;
}
