(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     85036,       2280]
NotebookOptionsPosition[     82865,       2238]
NotebookOutlinePosition[     83276,       2255]
CellTagsIndexPosition[     83233,       2252]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.893169184244089*^9, 3.893169193749565*^9}, {
   3.893169228933765*^9, 3.893169271929041*^9}, {3.8932474291274157`*^9, 
   3.893247956595399*^9}, {3.893247999459058*^9, 3.8932480990398808`*^9}, {
   3.893248131603445*^9, 3.893248146322143*^9}, {3.893248390209675*^9, 
   3.8932483904382153`*^9}, {3.893248550550694*^9, 3.893248611858539*^9}, {
   3.893248661357287*^9, 3.8932487670966473`*^9}, {3.893248839219634*^9, 
   3.893248975684409*^9}, {3.893249006069007*^9, 3.893249017854089*^9}, {
   3.893249075824139*^9, 3.8932490837312193`*^9}, {3.893249126117807*^9, 
   3.893249190619787*^9}, {3.893249223509326*^9, 3.893249259578326*^9}, {
   3.893249318455318*^9, 3.8932493291843767`*^9}, {3.893249366255732*^9, 
   3.893249600295336*^9}, {3.893249646975462*^9, 3.893249712211182*^9}, {
   3.893249748076227*^9, 3.893249758718948*^9}, {3.89324979392142*^9, 
   3.893249837477996*^9}, {3.893249889778275*^9, 3.893249972136262*^9}, {
   3.893250007228786*^9, 3.893250130172738*^9}, {3.893250162516395*^9, 
   3.8932502220513077`*^9}, {3.893250283920403*^9, 3.8932503142581453`*^9}, {
   3.8932504564358473`*^9, 3.89325045675108*^9}, {3.893250511649528*^9, 
   3.8932505243568573`*^9}, {3.8932507189026012`*^9, 3.893250721037348*^9}, {
   3.893250765369471*^9, 3.89325113554706*^9}, {3.893251195822163*^9, 
   3.8932513060888567`*^9}, {3.89325134147785*^9, 3.89325137747808*^9}, {
   3.8932514109554243`*^9, 3.893251649867654*^9}, {3.8932518282385406`*^9, 
   3.893251860795795*^9}, {3.893353867832752*^9, 3.89335387182745*^9}, {
   3.893354470712245*^9, 3.893354510867787*^9}, {3.8933545732189074`*^9, 
   3.893354580893916*^9}, {3.893355402329399*^9, 3.893355402401001*^9}, {
   3.893356656437881*^9, 3.8933566867589684`*^9}, {3.893426920347826*^9, 
   3.893426970022314*^9}, {3.893427000399474*^9, 3.893427021135282*^9}, {
   3.893427060287558*^9, 3.8934271398855658`*^9}, {3.8934274997595863`*^9, 
   3.893427520525772*^9}, {3.8934277053109093`*^9, 3.893427733976604*^9}, {
   3.893427765312744*^9, 3.89342785695702*^9}, {3.893427910307954*^9, 
   3.893427958665544*^9}, {3.893427992324006*^9, 3.893428035949024*^9}, {
   3.8934284081727953`*^9, 3.893428419372346*^9}, {3.893428459007658*^9, 
   3.8934284643966846`*^9}, {3.893428702440484*^9, 3.89342870699035*^9}, {
   3.8934326966366377`*^9, 3.8934327089092197`*^9}, 3.893433602276453*^9, {
   3.893433684828636*^9, 3.8934336897237062`*^9}, {3.894798675227211*^9, 
   3.894798675835196*^9}, {3.89496266860911*^9, 3.894962671507259*^9}, {
   3.894963995961163*^9, 3.89496400227387*^9}, {3.8949825582529287`*^9, 
   3.8949825851890697`*^9}, {3.894982667195017*^9, 3.894982797187276*^9}, {
   3.895051678746327*^9, 3.895051680924375*^9}, {3.89505308272348*^9, 
   3.895053088465988*^9}, {3.8950760229382763`*^9, 3.895076027919436*^9}, {
   3.895076060472386*^9, 3.895076061354556*^9}, {3.895080549077141*^9, 
   3.8950805546428633`*^9}, {3.8950859881819057`*^9, 3.895086002001219*^9}, {
   3.954003870566825*^9, 
   3.954003871113084*^9}},ExpressionUUID->"68d78e95-469d-4969-ab89-\
063ca38d2ad6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"EQUILIBRIUM", " ", "1"}], " ", ":", " ", "\[IndentingNewLine]", 
     
     RowBox[{"q_L", 
      RowBox[{"(", 
       RowBox[{"\[Pi]", "|", "\[Omega]_H"}], ")"}]}]}], "=", 
    RowBox[{
     RowBox[{"q_H", 
      RowBox[{"(", 
       RowBox[{"\[Pi]", "|", "\[Omega]_L"}], ")"}]}], "\[IndentingNewLine]", "<=",
      " ", "\[Pi]_L", "\[IndentingNewLine]", "<=", " ", 
     RowBox[{"q_L", 
      RowBox[{"(", 
       RowBox[{"\[Pi]", "|", "\[Omega]_L"}], ")"}]}], "\[IndentingNewLine]", "<=",
      " ", "\[Pi]_H", "\[IndentingNewLine]", "<=", " ", 
     RowBox[{"q_H", 
      RowBox[{"(", 
       RowBox[{"\[Pi]", "|", "\[Omega]_H"}], ")"}]}]}]}], 
   "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"ClearAll", "[", "\[IndentingNewLine]", 
    RowBox[{
    "hpreAccH", ",", "hpreAccL", ",", "lpreAccH", ",", "lpreAccL", ",", 
     "\[IndentingNewLine]", "hDAH", ",", "hDAL", ",", "lDAH", ",", "lDAL", 
     ",", "\[IndentingNewLine]", "qhH", ",", "qhL", ",", "qlH", ",", "qlL", 
     ",", "\[IndentingNewLine]", "UhpreAccH", ",", "UhpreAccH", ",", 
     "UlpreAccH", ",", "UlsigAccL", ",", "\[IndentingNewLine]", "UhDAH", ",", 
     "UhDAL", ",", "UlDAH", ",", "UlDAL", ",", "\[IndentingNewLine]", "uh", 
     ",", "ul", ",", "ph", ",", "pl", ",", "\[IndentingNewLine]", "c", ",", 
     "r", ",", "cap"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"c", " ", "=", " ", 
     RowBox[{"1", "/", "2"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Early", " ", "matches"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"hpreAccH", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"(", "1", ")"}], " ", "r", " ", 
       RowBox[{"Integrate", "[", 
        RowBox[{"1", ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "ph", ",", "1"}], "}"}]}], "]"}]}], "//", " ", 
      "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"hpreAccL", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"(", "c", ")"}], " ", "r", " ", 
       RowBox[{"Integrate", "[", 
        RowBox[{"1", ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "ph", ",", "1"}], "}"}]}], "]"}]}], "//", " ", 
      "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lpreAccH", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"(", "1", ")"}]}], ")"}], " ", "r", " ", 
        RowBox[{"Integrate", "[", 
         RowBox[{"1", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "pl", ",", "1"}], "}"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", "1", ")"}], "r", " ", 
        RowBox[{"Integrate", "[", 
         RowBox[{"1", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "pl", ",", "ph"}], "}"}]}], "]"}]}]}], "//", " ",
       "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lpreAccL", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"(", "c", ")"}]}], ")"}], " ", "r", " ", 
        RowBox[{"Integrate", "[", 
         RowBox[{"1", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "pl", ",", "1"}], "}"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", "c", ")"}], " ", "r", " ", 
        RowBox[{"Integrate", "[", 
         RowBox[{"1", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "pl", ",", "ph"}], "}"}]}], "]"}]}]}], "//", " ",
       "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Late", " ", "matches"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"hDAH", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"(", "1", ")"}], 
       RowBox[{"(", 
        RowBox[{"1", "-", "r"}], ")"}], 
       RowBox[{"Integrate", "[", 
        RowBox[{"1", ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "qhH", ",", "1"}], "}"}]}], "]"}]}], "//", " ", 
      "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"hDAL", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", "c", ")"}], 
        RowBox[{"(", 
         RowBox[{"1", "-", "r"}], ")"}], 
        RowBox[{"Integrate", "[", 
         RowBox[{"1", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "qhL", ",", "1"}], "}"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"(", "c", ")"}]}], ")"}], 
        RowBox[{"(", 
         RowBox[{"1", "-", "r"}], ")"}], 
        RowBox[{"Integrate", "[", 
         RowBox[{"1", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "qhL", ",", "qlL"}], "}"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", "c", ")"}], "r", " ", 
        RowBox[{"Integrate", "[", 
         RowBox[{"1", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "qhL", ",", "pl"}], "}"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"(", "c", ")"}]}], ")"}], "r", " ", 
        RowBox[{"Integrate", "[", 
         RowBox[{"1", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "qhL", ",", "pl"}], "}"}]}], "]"}]}]}], "//", 
      " ", "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lDAH", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"(", "1", ")"}]}], ")"}], 
        RowBox[{"(", 
         RowBox[{"1", "-", "r"}], ")"}], 
        RowBox[{"Integrate", "[", 
         RowBox[{"1", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "qlH", ",", "1"}], "}"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", "1", ")"}], 
        RowBox[{"(", 
         RowBox[{"1", "-", "r"}], ")"}], 
        RowBox[{"Integrate", "[", 
         RowBox[{"1", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "qlH", ",", "qhH"}], "}"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"(", "1", ")"}]}], ")"}], "r", " ", 
        RowBox[{"Integrate", "[", 
         RowBox[{"1", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "qlH", ",", "pl"}], "}"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", "1", ")"}], "r", " ", 
        RowBox[{"Integrate", "[", 
         RowBox[{"1", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "qlH", ",", "pl"}], "}"}]}], "]"}]}]}], "//", 
      " ", "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lDAL", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"(", "c", ")"}]}], ")"}], 
       RowBox[{"(", 
        RowBox[{"1", "-", "r"}], ")"}], 
       RowBox[{"Integrate", "[", 
        RowBox[{"1", ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "qlL", ",", "1"}], "}"}]}], "]"}]}], "//", " ", 
      "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Calculating", " ", "Cutoffs"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"qhH", "=", 
     RowBox[{
      RowBox[{"qhH", "/.", 
       RowBox[{"Solve", "[", 
        RowBox[{
         RowBox[{"cap", "==", 
          RowBox[{"hpreAccH", "+", "hDAH"}]}], ",", "qhH"}], "]"}]}], "//", 
      " ", "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"qhL", "=", 
     RowBox[{
      RowBox[{"qhL", "/.", 
       RowBox[{"Solve", "[", 
        RowBox[{
         RowBox[{"cap", "==", 
          RowBox[{"hpreAccL", "+", "hDAL"}]}], ",", "qhL"}], "]"}]}], "//", 
      " ", "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"qlH", "=", 
     RowBox[{
      RowBox[{"qlH", "/.", 
       RowBox[{"Solve", "[", 
        RowBox[{
         RowBox[{"cap", "==", 
          RowBox[{"lpreAccH", "+", "lDAH"}]}], ",", "qlH"}], "]"}]}], "//", 
      " ", "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"qlL", "=", 
     RowBox[{
      RowBox[{"qlL", "/.", 
       RowBox[{"Solve", "[", 
        RowBox[{
         RowBox[{"cap", "==", 
          RowBox[{"lpreAccL", "+", "lDAL"}]}], ",", "qlL"}], "]"}]}], "//", 
      " ", "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Calculating", " ", "Utilities"}], "*)"}], "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{"UhpreAccH", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"(", "1", ")"}], " ", "r", " ", 
       RowBox[{"Integrate", "[", 
        RowBox[{"x", ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "ph", ",", "1"}], "}"}]}], "]"}]}], "//", " ", 
      "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"UhpreAccL", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"(", "c", ")"}], " ", "r", " ", 
       RowBox[{"Integrate", "[", 
        RowBox[{"x", ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "ph", ",", "1"}], "}"}]}], "]"}]}], "//", " ", 
      "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"UlpreAccH", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", "c"}], ")"}], " ", "r", " ", 
        RowBox[{"Integrate", "[", 
         RowBox[{"x", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "pl", ",", "1"}], "}"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", "1", ")"}], "r", " ", 
        RowBox[{"Integrate", "[", 
         RowBox[{"x", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "pl", ",", "ph"}], "}"}]}], "]"}]}]}], "//", " ",
       "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"UlsigAccL", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", "1"}], ")"}], " ", "r", " ", 
        RowBox[{"Integrate", "[", 
         RowBox[{"x", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "pl", ",", "1"}], "}"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", "c", ")"}], " ", "r", " ", 
        RowBox[{"Integrate", "[", 
         RowBox[{"x", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "pl", ",", "ph"}], "}"}]}], "]"}]}]}], "//", " ",
       "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"UhDAH", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"(", "1", ")"}], 
       RowBox[{"(", 
        RowBox[{"1", "-", "r"}], ")"}], 
       RowBox[{"Integrate", "[", 
        RowBox[{"x", ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "qhH", ",", "1"}], "}"}]}], "]"}]}], "//", " ", 
      "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"UhDAL", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", "c", ")"}], 
        RowBox[{"(", 
         RowBox[{"1", "-", "r"}], ")"}], 
        RowBox[{"Integrate", "[", 
         RowBox[{"x", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "qhL", ",", "1"}], "}"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"(", "c", ")"}]}], ")"}], 
        RowBox[{"(", 
         RowBox[{"1", "-", "r"}], ")"}], 
        RowBox[{"Integrate", "[", 
         RowBox[{"x", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "qhL", ",", "qlL"}], "}"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", "c", ")"}], "r", " ", 
        RowBox[{"Integrate", "[", 
         RowBox[{"x", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "qhL", ",", "pl"}], "}"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"(", "c", ")"}]}], ")"}], "r", " ", 
        RowBox[{"Integrate", "[", 
         RowBox[{"x", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "qhL", ",", "pl"}], "}"}]}], "]"}]}]}], "//", 
      " ", "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"UlDAH", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"(", "1", ")"}]}], ")"}], 
        RowBox[{"(", 
         RowBox[{"1", "-", "r"}], ")"}], 
        RowBox[{"Integrate", "[", 
         RowBox[{"x", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "qlH", ",", "1"}], "}"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", "1", ")"}], 
        RowBox[{"(", 
         RowBox[{"1", "-", "r"}], ")"}], 
        RowBox[{"Integrate", "[", 
         RowBox[{"x", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "qlH", ",", "qhH"}], "}"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"(", "1", ")"}]}], ")"}], "r", " ", 
        RowBox[{"Integrate", "[", 
         RowBox[{"x", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "qlH", ",", "pl"}], "}"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", "1", ")"}], "r", " ", 
        RowBox[{"Integrate", "[", 
         RowBox[{"x", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "qlH", ",", "pl"}], "}"}]}], "]"}]}]}], "//", 
      " ", "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"UlDAL", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"(", "c", ")"}]}], ")"}], 
       RowBox[{"(", 
        RowBox[{"1", "-", "r"}], ")"}], 
       RowBox[{"Integrate", "[", 
        RowBox[{"x", ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "qlL", ",", "1"}], "}"}]}], "]"}]}], "//", " ", 
      "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"uh", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"1", "/", "2"}], 
        RowBox[{"(", 
         RowBox[{"UhpreAccH", " ", "+", " ", "UhDAH"}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"1", "/", "2"}]}], ")"}], 
        RowBox[{"(", 
         RowBox[{"UhpreAccL", " ", "+", " ", "UhDAL"}], ")"}]}]}], " ", "//", 
      " ", "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ul", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"1", "/", "2"}], 
        RowBox[{"(", 
         RowBox[{"UlpreAccH", " ", "+", " ", "UlDAH"}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"1", "/", "2"}]}], ")"}], 
        RowBox[{"(", 
         RowBox[{"UlsigAccL", " ", "+", " ", "UlDAL"}], ")"}]}]}], "//", " ", 
      "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"The", " ", "utilities", " ", "are", " ", 
     RowBox[{"concave", ":"}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Reduce", "[", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"D", "[", 
         RowBox[{"uh", ",", "ph"}], "]"}], ",", "ph"}], "]"}], "<=", " ", 
      "0"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"FullSimplify", "[", 
    RowBox[{"%", ",", 
     RowBox[{"Assumptions", "->", 
      RowBox[{
       RowBox[{"0", "<=", "r", "<=", "1"}], "&&", 
       RowBox[{"0", "<", "cap", "<=", 
        RowBox[{"1", "/", "2"}]}]}]}]}], "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Reduce", "[", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"D", "[", 
         RowBox[{"ul", ",", "pl"}], "]"}], ",", "pl"}], "]"}], "<=", " ", 
      "0"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"FullSimplify", "[", 
    RowBox[{"%", ",", 
     RowBox[{"Assumptions", "->", 
      RowBox[{
       RowBox[{"0", "<=", "r", "<=", "1"}], "&&", 
       RowBox[{"0", "<", "cap", "<=", 
        RowBox[{"1", "/", "2"}]}]}]}]}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Equilibrium", " ", "pl", " ", "and", " ", "ph"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pl", "=", 
     RowBox[{
      RowBox[{"pl", "/.", 
       RowBox[{"Solve", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"D", "[", 
           RowBox[{"ul", ",", " ", "pl"}], "]"}], " ", "==", "0"}], ",", 
         "pl"}], "]"}]}], "//", " ", "FullSimplify"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ph", "=", 
     RowBox[{
      RowBox[{"ph", "/.", 
       RowBox[{"Solve", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"D", "[", 
           RowBox[{"uh", ",", " ", "ph"}], "]"}], " ", "==", "0"}], ",", 
         "ph"}], "]"}]}], "//", " ", "FullSimplify"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plEQ", "=", 
     RowBox[{"FullSimplify", "[", "pl", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"phEQ", "=", 
     RowBox[{"FullSimplify", "[", "ph", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"uhEQ", " ", "=", " ", "uh"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"ClearAll", "[", 
    RowBox[{"pl", ",", "ph"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"pl", " ", "=", " ", "plEQ"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
     "qlL", " ", "does", " ", "not", " ", "catch", " ", "ph", " ", "because", 
      " ", "ph"}], " ", ">=", " ", 
     RowBox[{"1", "-", 
      RowBox[{"2", " ", "Cap"}]}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Reduce", "[", 
     RowBox[{
      RowBox[{"qlL", " ", ">", " ", "ph"}], "&&", 
      RowBox[{"qhH", ">=", "ph"}], "&&", 
      RowBox[{"ph", ">=", "phEQ"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"FullSimplify", "[", 
    RowBox[{"%", ",", 
     RowBox[{"Assumptions", "->", 
      RowBox[{
       RowBox[{"0", "<=", "r", "<=", "1"}], "&&", 
       RowBox[{"0", "<", "cap", "<=", 
        RowBox[{"1", "/", "2"}]}]}]}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.893250726702169*^9, 3.893250727696227*^9}, 
   3.893251882671105*^9, {3.893252182718021*^9, 3.893252211259466*^9}, {
   3.89325224389738*^9, 3.89325232701434*^9}, {3.89325247189955*^9, 
   3.8932525046308327`*^9}, {3.893252545346942*^9, 3.8932525580723457`*^9}, {
   3.893253024608306*^9, 3.893253057592958*^9}, {3.8932532080211153`*^9, 
   3.893253223505982*^9}, {3.893353859485915*^9, 3.893353861783348*^9}, {
   3.893354104140408*^9, 3.893354252991898*^9}, {3.893354544518464*^9, 
   3.893354570411977*^9}, {3.893355402420402*^9, 3.8933554025352583`*^9}, {
   3.893426920374172*^9, 3.893426923033608*^9}, {3.893427248105012*^9, 
   3.8934273747541533`*^9}, {3.8934275739914207`*^9, 3.893427600913644*^9}, {
   3.893427670875392*^9, 3.8934276716614733`*^9}, {3.89342780326196*^9, 
   3.893427808042829*^9}, {3.893427863296311*^9, 3.893427874405046*^9}, {
   3.893428071352285*^9, 3.893428145748062*^9}, {3.8934281801581907`*^9, 
   3.893428185588605*^9}, {3.893428238385028*^9, 3.89342824903652*^9}, {
   3.893428287529448*^9, 3.893428362918317*^9}, {3.893428402874621*^9, 
   3.893428404847521*^9}, {3.8934297110544453`*^9, 3.893429724193593*^9}, {
   3.893429978684424*^9, 3.893430035902643*^9}, {3.893430078897469*^9, 
   3.8934301096039467`*^9}, {3.893430179191736*^9, 3.893430180638345*^9}, {
   3.893430210914372*^9, 3.893430216308117*^9}, {3.893430249494802*^9, 
   3.8934302509023037`*^9}, 3.893430285273294*^9, {3.893430319701894*^9, 
   3.893430394150258*^9}, {3.8934304642030773`*^9, 3.893430465164618*^9}, {
   3.893430505848363*^9, 3.893430508641963*^9}, {3.893432497745886*^9, 
   3.893432506921197*^9}, {3.893432636055934*^9, 3.893432636312796*^9}, {
   3.893432690970578*^9, 3.893432692797762*^9}, 3.893433550922237*^9, {
   3.893433594300624*^9, 3.8934336182481947`*^9}, {3.893433665953457*^9, 
   3.893433680435268*^9}, {3.894798679406261*^9, 3.8947986800935287`*^9}, {
   3.894962680291831*^9, 3.894962680679323*^9}, {3.894962893572052*^9, 
   3.894962897144824*^9}, {3.895053718766465*^9, 3.895053961865839*^9}, {
   3.895055230763699*^9, 3.895055232302677*^9}, {3.8950552706080847`*^9, 
   3.895055271602557*^9}, {3.895055412632154*^9, 3.8950554331503773`*^9}, {
   3.8950555102361794`*^9, 3.895055513570139*^9}, {3.89505556364152*^9, 
   3.895055686613093*^9}, {3.8950557943563232`*^9, 3.895055796256302*^9}, 
   3.895055850709361*^9, {3.8950560398143997`*^9, 3.895056042224794*^9}, {
   3.89505613212658*^9, 3.895056134891212*^9}, {3.895075574200712*^9, 
   3.895075578040916*^9}, {3.895086262646791*^9, 3.8950862950356617`*^9}, {
   3.895086489258629*^9, 3.8950864934521646`*^9}, {3.895086587499337*^9, 
   3.8950866402767677`*^9}, {3.895086884720704*^9, 3.895086903106723*^9}, {
   3.8951371956997147`*^9, 3.895137210718177*^9}, {3.895144382616599*^9, 
   3.89514441231781*^9}, {3.8951445248591633`*^9, 3.895144532600792*^9}, {
   3.89514527752293*^9, 3.8951453185457497`*^9}, {3.895145349524972*^9, 
   3.895145349718431*^9}, 3.8951460133231993`*^9, {3.8951498656162567`*^9, 
   3.895149868529046*^9}, 3.895150157335198*^9, {3.89515171108526*^9, 
   3.895151731907196*^9}, {3.8951519410300217`*^9, 3.895151956299971*^9}, {
   3.895152030828966*^9, 3.895152038450101*^9}, {3.895152435554722*^9, 
   3.895152437632752*^9}, {3.895152819833461*^9, 3.895152879225295*^9}, {
   3.8951541140377073`*^9, 3.895154133503031*^9}, {3.895154225890856*^9, 
   3.8951544220131702`*^9}, {3.895155514314026*^9, 3.895155514474596*^9}, {
   3.895155568141634*^9, 3.8951555828180428`*^9}, 3.895155674300969*^9, {
   3.89515635655719*^9, 3.89515637045715*^9}, {3.8951564007291937`*^9, 
   3.895156541143056*^9}, {3.895156804904323*^9, 3.895156862089753*^9}, {
   3.89515690475416*^9, 3.895156967723181*^9}, {3.895157052939954*^9, 
   3.89515705756256*^9}, {3.895157106055179*^9, 3.895157184444006*^9}, {
   3.895157220246748*^9, 3.895157341040176*^9}, {3.895157448338853*^9, 
   3.895157523312483*^9}, {3.895157562891217*^9, 3.895157608932661*^9}, {
   3.895157638941032*^9, 3.895157642024598*^9}, {3.895157673904903*^9, 
   3.895157674285996*^9}, {3.8951577329050703`*^9, 3.895157733314283*^9}, {
   3.895157971682687*^9, 3.895158029966577*^9}, {3.895158117079212*^9, 
   3.8951581944599133`*^9}, {3.8951584251532288`*^9, 3.895158549315696*^9}, {
   3.8951633853400106`*^9, 3.895163394242782*^9}, {3.895221815840528*^9, 
   3.8952218219009953`*^9}, {3.8952218571442966`*^9, 3.895221868393218*^9}, {
   3.895222116676545*^9, 3.895222137773121*^9}, {3.8952345175984783`*^9, 
   3.895234601574966*^9}, {3.895234686964986*^9, 3.895234696716608*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"855c4674-ffd6-4a54-8a25-c6ede463b5b5"],

Cell[BoxData[
 RowBox[{"r", "<", "1"}]], "Output",
 CellChangeTimes->{3.954003962254633*^9},
 CellLabel->"Out[26]=",ExpressionUUID->"ff3eceb6-8740-4936-8fbc-48f9db14f606"],

Cell[BoxData[
 RowBox[{"r", "<", "1"}]], "Output",
 CellChangeTimes->{3.954003962269288*^9},
 CellLabel->"Out[28]=",ExpressionUUID->"c63da2fc-7601-44d6-bd87-6a614f39a84d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"1", "-", 
    FractionBox[
     RowBox[{"6", " ", "cap"}], 
     RowBox[{"3", "+", "r"}]]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.954003962319433*^9},
 CellLabel->"Out[35]=",ExpressionUUID->"042580ed-4cdc-46c7-a6b3-bb01283a5d32"],

Cell[BoxData["False"], "Output",
 CellChangeTimes->{3.95400396592377*^9},
 CellLabel->"Out[37]=",ExpressionUUID->"42183097-7146-4b09-aabf-ea94cea86e57"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Theorem", " ", "2", " ", "proof"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Reduce", "[", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{"uhEQ", ",", " ", "r"}], "]"}], "<", "0"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"FullSimplify", "[", 
    RowBox[{"%", ",", 
     RowBox[{"Assumptions", "->", 
      RowBox[{
       RowBox[{"0", "<=", "r", "<=", "1"}], "&&", 
       RowBox[{"0", "<", "cap", "<=", 
        RowBox[{"1", "/", "2"}]}]}]}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.895163677032947*^9, 3.89516371889251*^9}},
 CellLabel->"In[38]:=",ExpressionUUID->"a0724a26-ab35-4486-9966-489e22ca2caf"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.954003998423477*^9},
 CellLabel->"Out[39]=",ExpressionUUID->"c899acb4-3341-4267-b990-eaaaa0dde302"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Deviation", " ", "1"}], ":", " ", "\[IndentingNewLine]", 
     RowBox[{"q_L", 
      RowBox[{"(", 
       RowBox[{"\[Pi]", "|", "\[Omega]_H"}], ")"}]}]}], "=", 
    RowBox[{
     RowBox[{"q_H", 
      RowBox[{"(", 
       RowBox[{"\[Pi]", "|", "\[Omega]_L"}], ")"}]}], "\[IndentingNewLine]", "<=",
      " ", 
     RowBox[{"q_L", 
      RowBox[{"(", 
       RowBox[{"\[Pi]", "|", "\[Omega]_L"}], ")"}]}], " ", 
     "\[IndentingNewLine]", "<=", " ", "\[Pi]_L", "\[IndentingNewLine]", "<=",
      " ", "\[Pi]_H", "\[IndentingNewLine]", "<=", " ", 
     RowBox[{"q_H", 
      RowBox[{"(", 
       RowBox[{"\[Pi]", "|", "\[Omega]_H"}], ")"}]}]}]}], 
   "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"ClearAll", "[", "\[IndentingNewLine]", 
    RowBox[{
    "hpreAccH", ",", "hpreAccL", ",", "lpreAccH", ",", "lpreAccL", ",", 
     "\[IndentingNewLine]", "hDAH", ",", "hDAL", ",", "lDAH", ",", "lDAL", 
     ",", "\[IndentingNewLine]", "qhH", ",", "qhL", ",", "qlH", ",", "qlL", 
     ",", "\[IndentingNewLine]", "UhpreAccH", ",", "UhpreAccH", ",", 
     "UlpreAccH", ",", "UlsigAccL", ",", "\[IndentingNewLine]", "UhDAH", ",", 
     "UhDAL", ",", "UlDAH", ",", "UlDAL", ",", "\[IndentingNewLine]", "uh", 
     ",", "ul", ",", "ph", ",", "pl", ",", "\[IndentingNewLine]", "c", ",", 
     "r", ",", "cap"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"c", " ", "=", " ", 
     RowBox[{"1", "/", "2"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"hpreAccH", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"(", "1", ")"}], " ", "r", " ", 
       RowBox[{"Integrate", "[", 
        RowBox[{"1", ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "ph", ",", "1"}], "}"}]}], "]"}]}], "//", " ", 
      "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"hpreAccL", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"(", "c", ")"}], " ", "r", " ", 
       RowBox[{"Integrate", "[", 
        RowBox[{"1", ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "ph", ",", "1"}], "}"}]}], "]"}]}], "//", " ", 
      "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lpreAccH", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"(", "1", ")"}]}], ")"}], " ", "r", " ", 
        RowBox[{"Integrate", "[", 
         RowBox[{"1", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "pl", ",", "1"}], "}"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", "1", ")"}], "r", " ", 
        RowBox[{"Integrate", "[", 
         RowBox[{"1", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "pl", ",", "ph"}], "}"}]}], "]"}]}]}], "//", " ",
       "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lpreAccL", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"(", "c", ")"}]}], ")"}], " ", "r", " ", 
        RowBox[{"Integrate", "[", 
         RowBox[{"1", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "pl", ",", "1"}], "}"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", "c", ")"}], " ", "r", " ", 
        RowBox[{"Integrate", "[", 
         RowBox[{"1", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "pl", ",", "ph"}], "}"}]}], "]"}]}]}], "//", " ",
       "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"hDAH", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"(", "1", ")"}], 
       RowBox[{"(", 
        RowBox[{"1", "-", "r"}], ")"}], 
       RowBox[{"Integrate", "[", 
        RowBox[{"1", ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "qhH", ",", "1"}], "}"}]}], "]"}]}], "//", " ", 
      "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"hDAL", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", "c", ")"}], 
        RowBox[{"(", 
         RowBox[{"1", "-", "r"}], ")"}], 
        RowBox[{"Integrate", "[", 
         RowBox[{"1", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "qhL", ",", "1"}], "}"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"(", "c", ")"}]}], ")"}], 
        RowBox[{"(", 
         RowBox[{"1", "-", "r"}], ")"}], 
        RowBox[{"Integrate", "[", 
         RowBox[{"1", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "qhL", ",", "qlL"}], "}"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", "c", ")"}], "r", " ", 
        RowBox[{"Integrate", "[", 
         RowBox[{"1", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "qhL", ",", "pl"}], "}"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"(", "c", ")"}]}], ")"}], "r", " ", 
        RowBox[{"Integrate", "[", 
         RowBox[{"1", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "qhL", ",", "qlL"}], "}"}]}], "]"}]}]}], "//", 
      " ", "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lDAH", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"(", "1", ")"}]}], ")"}], 
        RowBox[{"(", 
         RowBox[{"1", "-", "r"}], ")"}], 
        RowBox[{"Integrate", "[", 
         RowBox[{"1", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "qlH", ",", "1"}], "}"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", "1", ")"}], 
        RowBox[{"(", 
         RowBox[{"1", "-", "r"}], ")"}], 
        RowBox[{"Integrate", "[", 
         RowBox[{"1", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "qlH", ",", "qhH"}], "}"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"(", "1", ")"}]}], ")"}], "r", " ", 
        RowBox[{"Integrate", "[", 
         RowBox[{"1", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "qlH", ",", "pl"}], "}"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", "1", ")"}], "r", " ", 
        RowBox[{"Integrate", "[", 
         RowBox[{"1", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "qlH", ",", "pl"}], "}"}]}], "]"}]}]}], "//", 
      " ", "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lDAL", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"(", "c", ")"}]}], ")"}], 
        RowBox[{"(", 
         RowBox[{"1", "-", "r"}], ")"}], 
        RowBox[{"Integrate", "[", 
         RowBox[{"1", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "qlL", ",", "1"}], "}"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"(", "c", ")"}]}], ")"}], 
        RowBox[{"(", "r", ")"}], 
        RowBox[{"Integrate", "[", 
         RowBox[{"1", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "qlL", ",", "pl"}], "}"}]}], "]"}]}]}], "//", 
      " ", "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"qhH", "=", 
     RowBox[{
      RowBox[{"qhH", "/.", 
       RowBox[{"Solve", "[", 
        RowBox[{
         RowBox[{"cap", "==", 
          RowBox[{"hpreAccH", "+", "hDAH"}]}], ",", "qhH"}], "]"}]}], "//", 
      " ", "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"qhL", "=", 
     RowBox[{
      RowBox[{"qhL", "/.", 
       RowBox[{"Solve", "[", 
        RowBox[{
         RowBox[{"cap", "==", 
          RowBox[{"hpreAccL", "+", "hDAL"}]}], ",", "qhL"}], "]"}]}], "//", 
      " ", "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"qlH", "=", 
     RowBox[{
      RowBox[{"qlH", "/.", 
       RowBox[{"Solve", "[", 
        RowBox[{
         RowBox[{"cap", "==", 
          RowBox[{"lpreAccH", "+", "lDAH"}]}], ",", "qlH"}], "]"}]}], "//", 
      " ", "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"qlL", "=", 
     RowBox[{
      RowBox[{"qlL", "/.", 
       RowBox[{"Solve", "[", 
        RowBox[{
         RowBox[{"cap", "==", 
          RowBox[{"lpreAccL", "+", "lDAL"}]}], ",", "qlL"}], "]"}]}], "//", 
      " ", "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"UhpreAccH", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"(", "1", ")"}], " ", "r", " ", 
       RowBox[{"Integrate", "[", 
        RowBox[{"x", ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "ph", ",", "1"}], "}"}]}], "]"}]}], "//", " ", 
      "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"UhpreAccL", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"(", "c", ")"}], " ", "r", " ", 
       RowBox[{"Integrate", "[", 
        RowBox[{"x", ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "ph", ",", "1"}], "}"}]}], "]"}]}], "//", " ", 
      "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"UlpreAccH", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", "c"}], ")"}], " ", "r", " ", 
        RowBox[{"Integrate", "[", 
         RowBox[{"x", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "pl", ",", "1"}], "}"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", "1", ")"}], "r", " ", 
        RowBox[{"Integrate", "[", 
         RowBox[{"x", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "pl", ",", "ph"}], "}"}]}], "]"}]}]}], "//", " ",
       "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"UlsigAccL", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", "1"}], ")"}], " ", "r", " ", 
        RowBox[{"Integrate", "[", 
         RowBox[{"x", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "pl", ",", "1"}], "}"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", "c", ")"}], " ", "r", " ", 
        RowBox[{"Integrate", "[", 
         RowBox[{"x", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "pl", ",", "ph"}], "}"}]}], "]"}]}]}], "//", " ",
       "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"UhDAH", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"(", "1", ")"}], 
       RowBox[{"(", 
        RowBox[{"1", "-", "r"}], ")"}], 
       RowBox[{"Integrate", "[", 
        RowBox[{"x", ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "qhH", ",", "1"}], "}"}]}], "]"}]}], "//", " ", 
      "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"UhDAL", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", "c", ")"}], 
        RowBox[{"(", 
         RowBox[{"1", "-", "r"}], ")"}], 
        RowBox[{"Integrate", "[", 
         RowBox[{"x", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "qhL", ",", "1"}], "}"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"(", "c", ")"}]}], ")"}], 
        RowBox[{"(", 
         RowBox[{"1", "-", "r"}], ")"}], 
        RowBox[{"Integrate", "[", 
         RowBox[{"x", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "qhL", ",", "qlL"}], "}"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", "c", ")"}], "r", " ", 
        RowBox[{"Integrate", "[", 
         RowBox[{"x", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "qhL", ",", "pl"}], "}"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"(", "c", ")"}]}], ")"}], "r", " ", 
        RowBox[{"Integrate", "[", 
         RowBox[{"x", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "qhL", ",", "qlL"}], "}"}]}], "]"}]}]}], "//", 
      " ", "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"UlDAH", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"(", "1", ")"}]}], ")"}], 
        RowBox[{"(", 
         RowBox[{"1", "-", "r"}], ")"}], 
        RowBox[{"Integrate", "[", 
         RowBox[{"x", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "qlH", ",", "1"}], "}"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", "1", ")"}], 
        RowBox[{"(", 
         RowBox[{"1", "-", "r"}], ")"}], 
        RowBox[{"Integrate", "[", 
         RowBox[{"x", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "qlH", ",", "qhH"}], "}"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"(", "1", ")"}]}], ")"}], "r", " ", 
        RowBox[{"Integrate", "[", 
         RowBox[{"x", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "qlH", ",", "pl"}], "}"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", "1", ")"}], "r", " ", 
        RowBox[{"Integrate", "[", 
         RowBox[{"x", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "qlH", ",", "pl"}], "}"}]}], "]"}]}]}], "//", 
      " ", "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"UlDAL", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"(", "c", ")"}]}], ")"}], 
        RowBox[{"(", 
         RowBox[{"1", "-", "r"}], ")"}], 
        RowBox[{"Integrate", "[", 
         RowBox[{"x", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "qlL", ",", "1"}], "}"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"(", "c", ")"}]}], ")"}], 
        RowBox[{"(", "r", ")"}], 
        RowBox[{"Integrate", "[", 
         RowBox[{"x", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "qlL", ",", "pl"}], "}"}]}], "]"}]}]}], "//", 
      " ", "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"uh", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"1", "/", "2"}], 
        RowBox[{"(", 
         RowBox[{"UhpreAccH", " ", "+", " ", "UhDAH"}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"1", "/", "2"}]}], ")"}], 
        RowBox[{"(", 
         RowBox[{"UhpreAccL", " ", "+", " ", "UhDAL"}], ")"}]}]}], " ", "//", 
      " ", "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ul", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"1", "/", "2"}], 
        RowBox[{"(", 
         RowBox[{"UlpreAccH", " ", "+", " ", "UlDAH"}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"1", "/", "2"}]}], ")"}], 
        RowBox[{"(", 
         RowBox[{"UlsigAccL", " ", "+", " ", "UlDAL"}], ")"}]}]}], "//", " ", 
      "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pl", "=", "plEQ"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Reduce", "[", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"D", "[", 
         RowBox[{"uh", ",", "ph"}], "]"}], ",", "ph"}], "]"}], "<=", " ", 
      "0"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"FullSimplify", "[", 
    RowBox[{"%", ",", 
     RowBox[{"Assumptions", "->", 
      RowBox[{
       RowBox[{"0", "<=", "r", "<=", "1"}], "&&", 
       RowBox[{"0", "<", "cap", "<=", 
        RowBox[{"1", "/", "2"}]}]}]}]}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"phDEV1OPT", "=", 
     RowBox[{
      RowBox[{"ph", "/.", 
       RowBox[{"Solve", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"D", "[", 
           RowBox[{"uh", ",", " ", "ph"}], "]"}], " ", "==", "0"}], ",", 
         "ph"}], "]"}]}], "//", " ", "FullSimplify"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Reduce", "[", 
     RowBox[{"phDEV1OPT", ">=", "phEQ"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"FullSimplify", "[", 
    RowBox[{"%", ",", 
     RowBox[{"Assumptions", "->", 
      RowBox[{
       RowBox[{"0", "<=", "r", "<=", "1"}], "&&", 
       RowBox[{"0", "<", "cap", "<=", 
        RowBox[{"1", "/", "2"}]}]}]}]}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.895156405459557*^9, 3.89515640944841*^9}, {
  3.8951565617428627`*^9, 3.895156646958857*^9}, {3.8951566910299883`*^9, 
  3.895156782946124*^9}, {3.895158724409453*^9, 3.8951587913732967`*^9}, {
  3.895158822600912*^9, 3.895158830597262*^9}, {3.8951589045304728`*^9, 
  3.895158910470058*^9}, {3.895159139390911*^9, 3.8951591634487658`*^9}, {
  3.895159284425544*^9, 3.8951593104972897`*^9}, {3.895159357525197*^9, 
  3.8951593980641747`*^9}, {3.89515968125664*^9, 3.8951596886445417`*^9}, {
  3.895159840378265*^9, 3.895159928884864*^9}, {3.8951604549084253`*^9, 
  3.8951605165613947`*^9}, {3.895160751832734*^9, 3.89516075372132*^9}, {
  3.895162974684155*^9, 3.895162982132702*^9}, {3.8951630285964746`*^9, 
  3.8951630288336363`*^9}, {3.895163376316245*^9, 3.895163379520232*^9}},
 CellLabel->"In[40]:=",ExpressionUUID->"b8ab0b78-ea91-45d4-a717-783e7e41accf"],

Cell[BoxData[
 RowBox[{"r", "<", "1"}]], "Output",
 CellChangeTimes->{3.954004001804978*^9},
 CellLabel->"Out[66]=",ExpressionUUID->"d4825ac7-d7e4-4680-a666-2233187e026c"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.95400400181394*^9},
 CellLabel->"Out[69]=",ExpressionUUID->"5d88218e-9bed-47d0-bca4-055463a9d20a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Deviation", " ", "2"}], ":", " ", "\[IndentingNewLine]", 
     RowBox[{"q_L", 
      RowBox[{"(", 
       RowBox[{"\[Pi]", "|", "\[Omega]_H"}], ")"}]}]}], "=", 
    RowBox[{
     RowBox[{"q_L", 
      RowBox[{"(", 
       RowBox[{"\[Pi]", "|", "\[Omega]_L"}], ")"}]}], "\[IndentingNewLine]", "<=", 
     RowBox[{"q_H", 
      RowBox[{"(", 
       RowBox[{"\[Pi]", "|", "\[Omega]_L"}], ")"}]}], "\[IndentingNewLine]", "<=",
      "\[Pi]_H", "\[IndentingNewLine]", "<=", "\[Pi]_L", 
     "\[IndentingNewLine]", "<", 
     RowBox[{"q_H", 
      RowBox[{"(", 
       RowBox[{"\[Pi]", "|", "\[Omega]_H"}], ")"}]}]}]}], 
   "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"ClearAll", "[", "\[IndentingNewLine]", 
    RowBox[{
    "hpreAccH", ",", "hpreAccL", ",", "lpreAccH", ",", "lpreAccL", ",", 
     "\[IndentingNewLine]", "hDAH", ",", "hDAL", ",", "lDAH", ",", "lDAL", 
     ",", "\[IndentingNewLine]", "qhH", ",", "qhL", ",", "qlH", ",", "qlL", 
     ",", "\[IndentingNewLine]", "UhpreAccH", ",", "UhpreAccH", ",", 
     "UlpreAccH", ",", "UlsigAccL", ",", "\[IndentingNewLine]", "UhDAH", ",", 
     "UhDAL", ",", "UlDAH", ",", "UlDAL", ",", "\[IndentingNewLine]", "uh", 
     ",", "ul", ",", "ph", ",", "pl", ",", "\[IndentingNewLine]", "c", ",", 
     "r", ",", "cap"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"c", " ", "=", " ", 
     RowBox[{"1", "/", "2"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"hpreAccH", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", "1", ")"}], " ", "r", " ", 
        RowBox[{"Integrate", "[", 
         RowBox[{"1", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "ph", ",", "1"}], "}"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"(", "1", ")"}]}], ")"}], "r", " ", 
        RowBox[{"Integrate", "[", 
         RowBox[{"1", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "ph", ",", "pl"}], "}"}]}], "]"}]}]}], "//", " ",
       "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"hpreAccL", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", "c", ")"}], " ", "r", " ", 
        RowBox[{"Integrate", "[", 
         RowBox[{"1", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "ph", ",", "1"}], "}"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"(", "c", ")"}]}], " ", ")"}], "r", " ", 
        RowBox[{"Integrate", "[", 
         RowBox[{"1", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "ph", ",", "pl"}], "}"}]}], "]"}]}]}], "//", " ",
       "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lpreAccH", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"(", "1", ")"}]}], ")"}], " ", "r", " ", 
       RowBox[{"Integrate", "[", 
        RowBox[{"1", ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "pl", ",", "1"}], "}"}]}], "]"}]}], "//", " ", 
      "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lpreAccL", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"(", "c", ")"}]}], ")"}], " ", "r", " ", 
       RowBox[{"Integrate", "[", 
        RowBox[{"1", ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "pl", ",", "1"}], "}"}]}], "]"}]}], "//", " ", 
      "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"hDAH", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"(", "1", ")"}], 
       RowBox[{"(", 
        RowBox[{"1", "-", "r"}], ")"}], 
       RowBox[{"Integrate", "[", 
        RowBox[{"1", ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "qhH", ",", "1"}], "}"}]}], "]"}]}], "//", " ", 
      "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"hDAL", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", "c", ")"}], 
        RowBox[{"(", 
         RowBox[{"1", "-", "r"}], ")"}], 
        RowBox[{"Integrate", "[", 
         RowBox[{"1", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "qhL", ",", "1"}], "}"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", "c", ")"}], "r", " ", 
        RowBox[{"Integrate", "[", 
         RowBox[{"1", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "qhL", ",", "ph"}], "}"}]}], "]"}]}]}], "//", 
      " ", "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lDAH", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"(", "1", ")"}]}], ")"}], 
        RowBox[{"(", 
         RowBox[{"1", "-", "r"}], ")"}], 
        RowBox[{"Integrate", "[", 
         RowBox[{"1", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "qlH", ",", "1"}], "}"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", "1", ")"}], 
        RowBox[{"(", 
         RowBox[{"1", "-", "r"}], ")"}], 
        RowBox[{"Integrate", "[", 
         RowBox[{"1", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "qlH", ",", "qhH"}], "}"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"(", "1", ")"}]}], ")"}], "r", " ", 
        RowBox[{"Integrate", "[", 
         RowBox[{"1", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "qlH", ",", "ph"}], "}"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", "1", ")"}], "r", " ", 
        RowBox[{"Integrate", "[", 
         RowBox[{"1", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "qlH", ",", "ph"}], "}"}]}], "]"}]}]}], "//", 
      " ", "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lDAL", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"(", "c", ")"}]}], ")"}], 
        RowBox[{"(", 
         RowBox[{"1", "-", "r"}], ")"}], 
        RowBox[{"Integrate", "[", 
         RowBox[{"1", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "qlL", ",", "1"}], "}"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", "c", ")"}], 
        RowBox[{"(", 
         RowBox[{"1", "-", "r"}], ")"}], 
        RowBox[{"Integrate", "[", 
         RowBox[{"1", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "qlL", ",", "qhL"}], "}"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"(", "c", ")"}]}], ")"}], "r", " ", 
        RowBox[{"Integrate", "[", 
         RowBox[{"1", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "qlL", ",", "ph"}], "}"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", "c", ")"}], "r", " ", 
        RowBox[{"Integrate", "[", 
         RowBox[{"1", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "qlL", ",", "qhL"}], "}"}]}], "]"}]}]}], "//", 
      " ", "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"qhH", "=", 
     RowBox[{
      RowBox[{"qhH", "/.", 
       RowBox[{"Solve", "[", 
        RowBox[{
         RowBox[{"cap", "==", 
          RowBox[{"hpreAccH", "+", "hDAH"}]}], ",", "qhH"}], "]"}]}], "//", 
      " ", "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"qhL", "=", 
     RowBox[{
      RowBox[{"qhL", "/.", 
       RowBox[{"Solve", "[", 
        RowBox[{
         RowBox[{"cap", "==", 
          RowBox[{"hpreAccL", "+", "hDAL"}]}], ",", "qhL"}], "]"}]}], "//", 
      " ", "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"qlH", "=", 
     RowBox[{
      RowBox[{"qlH", "/.", 
       RowBox[{"Solve", "[", 
        RowBox[{
         RowBox[{"cap", "==", 
          RowBox[{"lpreAccH", "+", "lDAH"}]}], ",", "qlH"}], "]"}]}], "//", 
      " ", "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"qlL", "=", 
     RowBox[{
      RowBox[{"qlL", "/.", 
       RowBox[{"Solve", "[", 
        RowBox[{
         RowBox[{"cap", "==", 
          RowBox[{"lpreAccL", "+", "lDAL"}]}], ",", "qlL"}], "]"}]}], "//", 
      " ", "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"UhpreAccH", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"(", "1", ")"}], " ", "r", " ", 
       RowBox[{"Integrate", "[", 
        RowBox[{"x", ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "ph", ",", "1"}], "}"}]}], "]"}]}], "//", " ", 
      "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"UhpreAccL", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"(", "c", ")"}], " ", "r", " ", 
       RowBox[{"Integrate", "[", 
        RowBox[{"x", ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "ph", ",", "1"}], "}"}]}], "]"}]}], "//", " ", 
      "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"UlpreAccH", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", "c"}], ")"}], " ", "r", " ", 
        RowBox[{"Integrate", "[", 
         RowBox[{"x", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "pl", ",", "1"}], "}"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", "1", ")"}], "r", " ", 
        RowBox[{"Integrate", "[", 
         RowBox[{"x", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "pl", ",", "ph"}], "}"}]}], "]"}]}]}], "//", " ",
       "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"UlsigAccL", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", "1"}], ")"}], " ", "r", " ", 
        RowBox[{"Integrate", "[", 
         RowBox[{"x", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "pl", ",", "1"}], "}"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", "c", ")"}], " ", "r", " ", 
        RowBox[{"Integrate", "[", 
         RowBox[{"x", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "pl", ",", "ph"}], "}"}]}], "]"}]}]}], "//", " ",
       "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"UhDAH", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"(", "1", ")"}], 
       RowBox[{"(", 
        RowBox[{"1", "-", "r"}], ")"}], 
       RowBox[{"Integrate", "[", 
        RowBox[{"x", ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "qhH", ",", "1"}], "}"}]}], "]"}]}], "//", " ", 
      "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"UhDAL", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", "c", ")"}], 
        RowBox[{"(", 
         RowBox[{"1", "-", "r"}], ")"}], 
        RowBox[{"Integrate", "[", 
         RowBox[{"x", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "qhL", ",", "1"}], "}"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", "c", ")"}], "r", " ", 
        RowBox[{"Integrate", "[", 
         RowBox[{"x", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "qhL", ",", "ph"}], "}"}]}], "]"}]}]}], "//", 
      " ", "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"UlDAH", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"(", "1", ")"}]}], ")"}], 
        RowBox[{"(", 
         RowBox[{"1", "-", "r"}], ")"}], 
        RowBox[{"Integrate", "[", 
         RowBox[{"x", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "qlH", ",", "1"}], "}"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", "1", ")"}], 
        RowBox[{"(", 
         RowBox[{"1", "-", "r"}], ")"}], 
        RowBox[{"Integrate", "[", 
         RowBox[{"x", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "qlH", ",", "qhH"}], "}"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"(", "1", ")"}]}], ")"}], "r", " ", 
        RowBox[{"Integrate", "[", 
         RowBox[{"x", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "qlH", ",", "ph"}], "}"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", "1", ")"}], "r", " ", 
        RowBox[{"Integrate", "[", 
         RowBox[{"x", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "qlH", ",", "ph"}], "}"}]}], "]"}]}]}], "//", 
      " ", "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"UlDAL", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"(", "c", ")"}]}], ")"}], 
        RowBox[{"(", 
         RowBox[{"1", "-", "r"}], ")"}], 
        RowBox[{"Integrate", "[", 
         RowBox[{"x", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "qlL", ",", "1"}], "}"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", "c", ")"}], 
        RowBox[{"(", 
         RowBox[{"1", "-", "r"}], ")"}], 
        RowBox[{"Integrate", "[", 
         RowBox[{"x", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "qlL", ",", "qhL"}], "}"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"(", "c", ")"}]}], ")"}], "r", " ", 
        RowBox[{"Integrate", "[", 
         RowBox[{"x", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "qlL", ",", "ph"}], "}"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", "c", ")"}], "r", " ", 
        RowBox[{"Integrate", "[", 
         RowBox[{"x", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "qlL", ",", "qhL"}], "}"}]}], "]"}]}]}], "//", 
      " ", "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"uh", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"1", "/", "2"}], 
        RowBox[{"(", 
         RowBox[{"UhpreAccH", " ", "+", " ", "UhDAH"}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"1", "/", "2"}]}], ")"}], 
        RowBox[{"(", 
         RowBox[{"UhpreAccL", " ", "+", " ", "UhDAL"}], ")"}]}]}], " ", "//", 
      " ", "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ul", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"1", "/", "2"}], 
        RowBox[{"(", 
         RowBox[{"UlpreAccH", " ", "+", " ", "UlDAH"}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"1", "/", "2"}]}], ")"}], 
        RowBox[{"(", 
         RowBox[{"UlsigAccL", " ", "+", " ", "UlDAL"}], ")"}]}]}], "//", " ", 
      "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pl", " ", "=", " ", "plEQ"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Reduce", "[", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"D", "[", 
         RowBox[{"uh", ",", "ph"}], "]"}], ",", "ph"}], "]"}], " ", "<=", 
      "0"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"FullSimplify", "[", 
    RowBox[{"%", ",", 
     RowBox[{"Assumptions", "->", 
      RowBox[{
       RowBox[{"0", "<=", "r", "<=", "1"}], "&&", 
       RowBox[{"0", "<", "cap", "<=", 
        RowBox[{"1", "/", "2"}]}]}]}]}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"phDEV2OPT", "=", " ", 
     RowBox[{
      RowBox[{"ph", " ", "/.", " ", 
       RowBox[{"Solve", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"D", "[", 
           RowBox[{"uh", ",", "ph"}], "]"}], "==", "0"}], ",", "ph"}], 
        "]"}]}], " ", "//", " ", "FullSimplify"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Reduce", "[", 
     RowBox[{"phDEV2OPT", ">=", "pl"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"FullSimplify", "[", 
    RowBox[{"%", ",", 
     RowBox[{"Assumptions", "->", 
      RowBox[{
       RowBox[{"0", "<=", "r", "<=", "1"}], "&&", 
       RowBox[{"0", "<", "cap", "<=", 
        RowBox[{"1", "/", "2"}]}]}]}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.893250726702169*^9, 3.893250727696227*^9}, 
   3.893251882671105*^9, {3.893252182718021*^9, 3.893252211259466*^9}, {
   3.89325224389738*^9, 3.89325232701434*^9}, {3.89325247189955*^9, 
   3.8932525046308327`*^9}, {3.893252545346942*^9, 3.8932525580723457`*^9}, {
   3.893253024608306*^9, 3.893253057592958*^9}, {3.8932532080211153`*^9, 
   3.893253223505982*^9}, {3.893353859485915*^9, 3.893353861783348*^9}, {
   3.893354104140408*^9, 3.893354252991898*^9}, {3.893354544518464*^9, 
   3.893354570411977*^9}, {3.893355402420402*^9, 3.8933554025352583`*^9}, {
   3.893426920374172*^9, 3.893426923033608*^9}, {3.893427248105012*^9, 
   3.8934273747541533`*^9}, {3.8934275739914207`*^9, 3.893427600913644*^9}, {
   3.893427670875392*^9, 3.8934276716614733`*^9}, {3.89342780326196*^9, 
   3.893427808042829*^9}, {3.893427863296311*^9, 3.893427874405046*^9}, {
   3.893428071352285*^9, 3.893428145748062*^9}, {3.8934281801581907`*^9, 
   3.893428185588605*^9}, {3.893428238385028*^9, 3.89342824903652*^9}, {
   3.893428287529448*^9, 3.893428362918317*^9}, {3.893428402874621*^9, 
   3.893428404847521*^9}, {3.8934297110544453`*^9, 3.893429724193593*^9}, {
   3.893429978684424*^9, 3.893430035902643*^9}, {3.893430078897469*^9, 
   3.8934301096039467`*^9}, {3.893430179191736*^9, 3.893430180638345*^9}, {
   3.893430210914372*^9, 3.893430216308117*^9}, {3.893430249494802*^9, 
   3.8934302509023037`*^9}, 3.893430285273294*^9, {3.893430319701894*^9, 
   3.893430394150258*^9}, {3.8934304642030773`*^9, 3.893430465164618*^9}, {
   3.893430505848363*^9, 3.893430508641963*^9}, {3.893432497745886*^9, 
   3.893432506921197*^9}, {3.893432636055934*^9, 3.893432636312796*^9}, {
   3.893432690970578*^9, 3.893432692797762*^9}, 3.893433550922237*^9, {
   3.893433594300624*^9, 3.8934336182481947`*^9}, {3.893433665953457*^9, 
   3.893433680435268*^9}, {3.894798679406261*^9, 3.8947986800935287`*^9}, {
   3.894962680291831*^9, 3.894962680679323*^9}, {3.894962893572052*^9, 
   3.894962897144824*^9}, {3.895053718766465*^9, 3.895053961865839*^9}, {
   3.895055230763699*^9, 3.895055232302677*^9}, {3.8950552706080847`*^9, 
   3.895055271602557*^9}, {3.895055412632154*^9, 3.8950554331503773`*^9}, {
   3.8950555102361794`*^9, 3.895055513570139*^9}, {3.89505556364152*^9, 
   3.895055686613093*^9}, {3.8950557943563232`*^9, 3.895055796256302*^9}, 
   3.895055850709361*^9, {3.8950560398143997`*^9, 3.895056042224794*^9}, {
   3.89505613212658*^9, 3.895056134891212*^9}, {3.895075574200712*^9, 
   3.895075578040916*^9}, {3.895086262646791*^9, 3.8950862950356617`*^9}, {
   3.895086489258629*^9, 3.8950864934521646`*^9}, {3.895086587499337*^9, 
   3.8950866402767677`*^9}, {3.895086884720704*^9, 3.8950869317315207`*^9}, {
   3.89508698530285*^9, 3.8950869873230963`*^9}, {3.895136444346285*^9, 
   3.895136474144619*^9}, {3.89513661788076*^9, 3.895136667321432*^9}, {
   3.8951367881545553`*^9, 3.895136807214141*^9}, {3.895136839312613*^9, 
   3.895136844193955*^9}, {3.8951370403849287`*^9, 3.895137045781986*^9}, {
   3.895137138880783*^9, 3.895137163011045*^9}, {3.895137254687129*^9, 
   3.8951372868511143`*^9}, {3.895144808946046*^9, 3.895144862922593*^9}, {
   3.895145086768084*^9, 3.895145250393029*^9}, {3.895145366564521*^9, 
   3.895145402415546*^9}, {3.895145520935286*^9, 3.895145572443262*^9}, {
   3.895145614197535*^9, 3.8951456862127657`*^9}, {3.8951458927284603`*^9, 
   3.8951458989171963`*^9}, {3.895146007038231*^9, 3.895146008017041*^9}, {
   3.895146038208035*^9, 3.8951460390650177`*^9}, {3.895146117611821*^9, 
   3.895146247964242*^9}, {3.895146293479494*^9, 3.895146330764559*^9}, {
   3.895146377738454*^9, 3.895146503280859*^9}, {3.895146635420465*^9, 
   3.895146662874845*^9}, {3.89514679033258*^9, 3.8951468850684423`*^9}, {
   3.895149790901894*^9, 3.895149791890954*^9}, {3.895155384867364*^9, 
   3.8951553870734663`*^9}, {3.895155499329648*^9, 3.895155499579063*^9}, {
   3.8951607953105288`*^9, 3.895160797062757*^9}, {3.8951608345577917`*^9, 
   3.8951608943358*^9}, {3.8951633614122963`*^9, 3.895163370720613*^9}, 
   3.89523462513752*^9},
 CellLabel->"In[70]:=",ExpressionUUID->"0476a6bd-b7e2-4cd7-9e92-1680b576c35d"],

Cell[BoxData[
 RowBox[{"r", "<", "1"}]], "Output",
 CellChangeTimes->{3.9540040155674667`*^9},
 CellLabel->"Out[96]=",ExpressionUUID->"7a8160e8-0246-4211-81a4-c8a5435f42ed"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.954004015978348*^9},
 CellLabel->"Out[99]=",ExpressionUUID->"46fe2161-833d-4bd8-ac9d-7da2e5aeb1ab"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
    "ALTERNATE", " ", "EQUILIBRIUM", " ", "BEST", " ", "RESPONSE", " ", 
     "\[IndentingNewLine]", "q_L", 
     RowBox[{"(", 
      RowBox[{"\[Pi]", "|", "\[Omega]_L"}], ")"}]}], " ", "=", 
    RowBox[{
     RowBox[{"q_H", 
      RowBox[{"(", 
       RowBox[{"\[Pi]", "|", "\[Omega]_L"}], ")"}]}], "=", 
     RowBox[{
      RowBox[{"\[Pi]_L", "\[IndentingNewLine]", "<", 
       RowBox[{"q_L", 
        RowBox[{"(", 
         RowBox[{"\[Pi]", "|", "\[Omega]_H"}], ")"}]}], "\[IndentingNewLine]",
        "<", " ", "\[Pi]_H", " ", "\[IndentingNewLine]", "<", 
       RowBox[{"q_H", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"\[Pi]", "|", "\[Omega]_H"}], ")"}], "\[IndentingNewLine]",
           "--"}], "--"}], 
        RowBox[{
         RowBox[{"or", "--"}], "--"}], "\[IndentingNewLine]", "q_L", 
        RowBox[{"(", 
         RowBox[{"\[Pi]", "|", "\[Omega]_L"}], ")"}]}]}], " ", "=", 
      RowBox[{
       RowBox[{"q_H", 
        RowBox[{"(", 
         RowBox[{"\[Pi]", "|", "\[Omega]_L"}], ")"}]}], "=", 
       RowBox[{
       "\[Pi]_L", "\[IndentingNewLine]", "<", " ", "\[Pi]_H", " ", 
        "\[IndentingNewLine]", "<=", 
        RowBox[{"q_L", 
         RowBox[{"(", 
          RowBox[{"\[Pi]", "|", "\[Omega]_H"}], ")"}]}], 
        "\[IndentingNewLine]", "<", 
        RowBox[{"q_H", 
         RowBox[{"(", 
          RowBox[{"\[Pi]", "|", "\[Omega]_H"}], ")"}]}]}]}]}]}]}], 
   "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"ClearAll", "[", "\[IndentingNewLine]", 
    RowBox[{
    "hpreAccH", ",", "hpreAccL", ",", "lpreAccH", ",", "lpreAccL", ",", 
     "\[IndentingNewLine]", "hDAH", ",", "hDAL", ",", "lDAH", ",", "lDAL", 
     ",", "\[IndentingNewLine]", "qhH", ",", "qhL", ",", "qlH", ",", "qlL", 
     ",", "\[IndentingNewLine]", "UhpreAccH", ",", "UhpreAccH", ",", 
     "UlpreAccH", ",", "UlsigAccL", ",", "\[IndentingNewLine]", "UhDAH", ",", 
     "UhDAL", ",", "UlDAH", ",", "UlDAL", ",", "\[IndentingNewLine]", "uh", 
     ",", "ul", ",", "ph", ",", "pl", ",", "\[IndentingNewLine]", "c", ",", 
     "r", ",", "cap"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"c", " ", "=", " ", 
     RowBox[{"1", "/", "2"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pl", " ", "=", " ", 
     RowBox[{"1", "-", 
      RowBox[{"2", "cap"}]}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"hpreAccH", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"(", "1", ")"}], " ", "r", " ", 
       RowBox[{"Integrate", "[", 
        RowBox[{"1", ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "ph", ",", "1"}], "}"}]}], "]"}]}], "//", " ", 
      "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"hpreAccL", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"(", "c", ")"}], " ", "r", " ", 
       RowBox[{"Integrate", "[", 
        RowBox[{"1", ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "ph", ",", "1"}], "}"}]}], "]"}]}], "//", " ", 
      "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lpreAccH", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"(", "1", ")"}]}], ")"}], " ", "r", " ", 
        RowBox[{"Integrate", "[", 
         RowBox[{"1", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "pl", ",", "1"}], "}"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", "1", ")"}], "r", " ", 
        RowBox[{"Integrate", "[", 
         RowBox[{"1", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "pl", ",", "ph"}], "}"}]}], "]"}]}]}], "//", " ",
       "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lpreAccL", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"(", "c", ")"}]}], ")"}], " ", "r", " ", 
        RowBox[{"Integrate", "[", 
         RowBox[{"1", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "pl", ",", "1"}], "}"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", "c", ")"}], " ", "r", " ", 
        RowBox[{"Integrate", "[", 
         RowBox[{"1", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "pl", ",", "ph"}], "}"}]}], "]"}]}]}], "//", " ",
       "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"hDAH", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"(", "1", ")"}], 
       RowBox[{"(", 
        RowBox[{"1", "-", "r"}], ")"}], 
       RowBox[{"Integrate", "[", 
        RowBox[{"1", ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "qhH", ",", "1"}], "}"}]}], "]"}]}], "//", " ", 
      "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"hDAL", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", "c", ")"}], 
        RowBox[{"(", 
         RowBox[{"1", "-", "r"}], ")"}], 
        RowBox[{"Integrate", "[", 
         RowBox[{"1", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "qhL", ",", "1"}], "}"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"(", "c", ")"}]}], ")"}], 
        RowBox[{"(", 
         RowBox[{"1", "-", "r"}], ")"}], 
        RowBox[{"Integrate", "[", 
         RowBox[{"1", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "qhL", ",", "qlL"}], "}"}]}], "]"}]}]}], "//", 
      " ", "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lDAH", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"(", "1", ")"}]}], ")"}], 
        RowBox[{"(", 
         RowBox[{"1", "-", "r"}], ")"}], 
        RowBox[{"Integrate", "[", 
         RowBox[{"1", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "qlH", ",", "1"}], "}"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", "1", ")"}], 
        RowBox[{"(", 
         RowBox[{"1", "-", "r"}], ")"}], 
        RowBox[{"Integrate", "[", 
         RowBox[{"1", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "qlH", ",", "qhH"}], "}"}]}], "]"}]}]}], "//", 
      " ", "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lDAL", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"(", "c", ")"}]}], ")"}], 
       RowBox[{"(", 
        RowBox[{"1", "-", "r"}], ")"}], 
       RowBox[{"Integrate", "[", 
        RowBox[{"1", ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "qlL", ",", "1"}], "}"}]}], "]"}]}], "//", " ", 
      "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"qhH", "=", 
     RowBox[{
      RowBox[{"qhH", "/.", 
       RowBox[{"Solve", "[", 
        RowBox[{
         RowBox[{"cap", "==", 
          RowBox[{"hpreAccH", "+", "hDAH"}]}], ",", "qhH"}], "]"}]}], "//", 
      " ", "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"qhL", "=", 
      RowBox[{
       RowBox[{"qhL", "/.", 
        RowBox[{"Solve", "[", 
         RowBox[{
          RowBox[{"cap", "==", 
           RowBox[{"hpreAccL", "+", "hDAL"}]}], ",", "qhL"}], "]"}]}], "//", 
       " ", "FullSimplify"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"qlH", "=", 
      RowBox[{
       RowBox[{"qlH", "/.", 
        RowBox[{"Solve", "[", 
         RowBox[{
          RowBox[{"cap", "==", 
           RowBox[{"lpreAccH", "+", "lDAH"}]}], ",", "qlH"}], "]"}]}], "//", 
       " ", "FullSimplify"}]}], ";"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"qlL", "=", 
     RowBox[{
      RowBox[{"qlL", "/.", 
       RowBox[{"Solve", "[", 
        RowBox[{
         RowBox[{"cap", "==", 
          RowBox[{"lpreAccL", "+", "lDAL"}]}], ",", "qlL"}], "]"}]}], "//", 
      " ", "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"qhL", " ", "=", " ", 
     RowBox[{"1", "-", 
      RowBox[{"2", "Cap"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"qlH", " ", "=", " ", 
     RowBox[{"1", "-", 
      RowBox[{"2", "Cap"}]}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"UhpreAccH", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"(", "1", ")"}], " ", "r", " ", 
       RowBox[{"Integrate", "[", 
        RowBox[{"x", ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "ph", ",", "1"}], "}"}]}], "]"}]}], "//", " ", 
      "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"UhpreAccL", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"(", "c", ")"}], " ", "r", " ", 
       RowBox[{"Integrate", "[", 
        RowBox[{"x", ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "ph", ",", "1"}], "}"}]}], "]"}]}], "//", " ", 
      "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"UlpreAccH", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", "c"}], ")"}], " ", "r", " ", 
        RowBox[{"Integrate", "[", 
         RowBox[{"x", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "pl", ",", "1"}], "}"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", "1", ")"}], "r", " ", 
        RowBox[{"Integrate", "[", 
         RowBox[{"x", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "pl", ",", "ph"}], "}"}]}], "]"}]}]}], "//", " ",
       "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"UlsigAccL", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", "1"}], ")"}], " ", "r", " ", 
        RowBox[{"Integrate", "[", 
         RowBox[{"x", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "pl", ",", "1"}], "}"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", "c", ")"}], " ", "r", " ", 
        RowBox[{"Integrate", "[", 
         RowBox[{"x", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "pl", ",", "ph"}], "}"}]}], "]"}]}]}], "//", " ",
       "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"UhDAH", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"(", "1", ")"}], 
       RowBox[{"(", 
        RowBox[{"1", "-", "r"}], ")"}], 
       RowBox[{"Integrate", "[", 
        RowBox[{"x", ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "qhH", ",", "1"}], "}"}]}], "]"}]}], "//", " ", 
      "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"UhDAL", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", "c", ")"}], 
        RowBox[{"(", 
         RowBox[{"1", "-", "r"}], ")"}], 
        RowBox[{"Integrate", "[", 
         RowBox[{"x", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "qhL", ",", "1"}], "}"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"(", "c", ")"}]}], ")"}], 
        RowBox[{"(", 
         RowBox[{"1", "-", "r"}], ")"}], 
        RowBox[{"Integrate", "[", 
         RowBox[{"x", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "qhL", ",", "qlL"}], "}"}]}], "]"}]}]}], "//", 
      " ", "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"UlDAH", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"(", "1", ")"}]}], ")"}], 
        RowBox[{"(", 
         RowBox[{"1", "-", "r"}], ")"}], 
        RowBox[{"Integrate", "[", 
         RowBox[{"x", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "qlH", ",", "1"}], "}"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", "1", ")"}], 
        RowBox[{"(", 
         RowBox[{"1", "-", "r"}], ")"}], 
        RowBox[{"Integrate", "[", 
         RowBox[{"x", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "qlH", ",", "qhH"}], "}"}]}], "]"}]}]}], "//", 
      " ", "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"UlDAL", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"(", "c", ")"}]}], ")"}], 
       RowBox[{"(", 
        RowBox[{"1", "-", "r"}], ")"}], 
       RowBox[{"Integrate", "[", 
        RowBox[{"x", ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "qlL", ",", "1"}], "}"}]}], "]"}]}], "//", " ", 
      "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"uh", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"1", "/", "2"}], 
        RowBox[{"(", 
         RowBox[{"UhpreAccH", " ", "+", " ", "UhDAH"}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"1", "/", "2"}]}], ")"}], 
        RowBox[{"(", 
         RowBox[{"UhpreAccL", " ", "+", " ", "UhDAL"}], ")"}]}]}], " ", "//", 
      " ", "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ul", "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"1", "/", "2"}], 
        RowBox[{"(", 
         RowBox[{"UlpreAccH", " ", "+", " ", "UlDAH"}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"1", "/", "2"}]}], ")"}], 
        RowBox[{"(", 
         RowBox[{"UlsigAccL", " ", "+", " ", "UlDAL"}], ")"}]}]}], "//", " ", 
      "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]",
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Reduce", "[", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"D", "[", 
         RowBox[{"uh", ",", "ph"}], "]"}], ",", "ph"}], "]"}], " ", "<=", 
      "0"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"FullSimplify", "[", 
    RowBox[{"%", ",", 
     RowBox[{"Assumptions", "->", 
      RowBox[{
       RowBox[{"0", "<=", "r", "<=", "1"}], "&&", 
       RowBox[{"0", "<", "cap", "<=", 
        RowBox[{"1", "/", "2"}]}]}]}]}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"ph", " ", "=", 
    RowBox[{
     RowBox[{"ph", " ", "/.", " ", 
      RowBox[{"Solve", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{"uh", ",", "ph"}], "]"}], "==", "0"}], ",", "ph"}], "]"}]}],
      " ", "//", " ", "FullSimplify"}]}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Reduce", "[", 
     RowBox[{"ph", " ", "!=", " ", 
      RowBox[{"1", "-", 
       RowBox[{"2", "cap"}]}]}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"FullSimplify", "[", 
    RowBox[{"%", ",", 
     RowBox[{"Assumptions", "->", 
      RowBox[{
       RowBox[{"0", "<=", "r", "<=", "1"}], "&&", 
       RowBox[{"0", "<", "cap", "<=", 
        RowBox[{"1", "/", "2"}]}]}]}]}], "]"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.895161686274166*^9, 3.895161716114699*^9}, {
   3.895162427708096*^9, 3.8951624626432953`*^9}, {3.895162672232476*^9, 
   3.8951626863255568`*^9}, {3.8951627456356707`*^9, 
   3.8951627989379787`*^9}, {3.895162845225672*^9, 3.895162859202332*^9}, {
   3.895162934564262*^9, 3.895162943777378*^9}, {3.8951631270827837`*^9, 
   3.895163288873814*^9}, {3.895163459511986*^9, 3.895163473923818*^9}, 
   3.8951635641807404`*^9, {3.8952347242024117`*^9, 3.895234724812359*^9}},
 CellLabel->
  "In[100]:=",ExpressionUUID->"c2d8f372-5660-455c-8591-93d563fee487"],

Cell[BoxData[
 RowBox[{"r", "<", "1"}]], "Output",
 CellChangeTimes->{3.954004038881372*^9},
 CellLabel->
  "Out[126]=",ExpressionUUID->"0befc01d-7766-429f-8e37-add729a18450"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", "+", 
   RowBox[{"2", " ", "cap", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      FractionBox["1", 
       RowBox[{"3", "-", 
        RowBox[{"2", " ", "r"}]}]]}], ")"}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.95400403891665*^9},
 CellLabel->
  "Out[127]=",ExpressionUUID->"daf7c1ac-6f5c-4986-822f-147137f059ee"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9540040389367723`*^9},
 CellLabel->
  "Out[129]=",ExpressionUUID->"f32fd1fb-0f94-4918-a1e7-d9c6999de0b8"]
}, Open  ]]
},
WindowSize->{Full, Full},
WindowMargins->{{4, Automatic}, {Automatic, 4}},
Visible->True,
FrontEndVersion->"13.2 for Mac OS X x86 (64-bit) (January 30, 2023)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"442ee7e3-3ab7-45d8-ad01-2ff750e8a940"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 3146, 44, 30, "Input",ExpressionUUID->"68d78e95-469d-4969-ab89-063ca38d2ad6"],
Cell[CellGroupData[{
Cell[3729, 68, 22646, 584, 1543, "Input",ExpressionUUID->"855c4674-ffd6-4a54-8a25-c6ede463b5b5"],
Cell[26378, 654, 171, 3, 34, "Output",ExpressionUUID->"ff3eceb6-8740-4936-8fbc-48f9db14f606"],
Cell[26552, 659, 171, 3, 34, "Output",ExpressionUUID->"c63da2fc-7601-44d6-bd87-6a614f39a84d"],
Cell[26726, 664, 295, 8, 50, "Output",ExpressionUUID->"042580ed-4cdc-46c7-a6b3-bb01283a5d32"],
Cell[27024, 674, 152, 2, 34, "Output",ExpressionUUID->"42183097-7146-4b09-aabf-ea94cea86e57"]
}, Open  ]],
Cell[CellGroupData[{
Cell[27213, 681, 713, 19, 73, "Input",ExpressionUUID->"a0724a26-ab35-4486-9966-489e22ca2caf"],
Cell[27929, 702, 152, 2, 34, "Output",ExpressionUUID->"c899acb4-3341-4267-b990-eaaaa0dde302"]
}, Open  ]],
Cell[CellGroupData[{
Cell[28118, 709, 17340, 495, 1270, "Input",ExpressionUUID->"b8ab0b78-ea91-45d4-a717-783e7e41accf"],
Cell[45461, 1206, 171, 3, 34, "Output",ExpressionUUID->"d4825ac7-d7e4-4680-a666-2233187e026c"],
Cell[45635, 1211, 151, 2, 34, "Output",ExpressionUUID->"5d88218e-9bed-47d0-bca4-055463a9d20a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[45823, 1218, 20402, 531, 1249, "Input",ExpressionUUID->"0476a6bd-b7e2-4cd7-9e92-1680b576c35d"],
Cell[66228, 1751, 173, 3, 34, "Output",ExpressionUUID->"7a8160e8-0246-4211-81a4-c8a5435f42ed"],
Cell[66404, 1756, 152, 2, 34, "Output",ExpressionUUID->"46fe2161-833d-4bd8-ac9d-7da2e5aeb1ab"]
}, Open  ]],
Cell[CellGroupData[{
Cell[66593, 1763, 15526, 447, 1333, "Input",ExpressionUUID->"c2d8f372-5660-455c-8591-93d563fee487"],
Cell[82122, 2212, 175, 4, 34, "Output",ExpressionUUID->"0befc01d-7766-429f-8e37-add729a18450"],
Cell[82300, 2218, 388, 12, 50, "Output",ExpressionUUID->"daf7c1ac-6f5c-4986-822f-147137f059ee"],
Cell[82691, 2232, 158, 3, 57, "Output",ExpressionUUID->"f32fd1fb-0f94-4918-a1e7-d9c6999de0b8"]
}, Open  ]]
}
]
*)

