function subtree = child(tree,left_or_right);
% child -- returns the left or right subtree of a Chirplet Tree
%  Usage
%    subtree = child(tree,left_or_right)
%  Input
%    tree     		a Chirplet Tree
%    left_or_right	a string with value 'l' or 'r', for
%			the left or right subtree respectively.
%  Outputs
%    subtree		the left or right subtree of tree,
%			based on the parameter left_or_right

n = length(tree);
J = log2(n+1);

if(n == 1)
  fprintf('This tree does not have any children');
end

lindex = zeros(1,0);
for j = 1:(J-1),  
  ix = 0:(2^(j-1) -1);
  ix = 2^j + ix;
  lindex = [lindex ix];
end

if strcmp(left_or_right,'l') 
  subtree = tree(lindex);
elseif strcmp(left_or_right,'r') 
  subtree = tree(setdiff(2:n,lindex));
else
  fprintf('Input argument must be ''l'' or ''r')
end

% $RCSfile: child.m,v $
% $Date: 2006/05/01 17:44:15 $
% $Revision: 1.2 $
%
% Copyright (c) Emmanuel J. Candes, Hannes Helgason, California Institute of Technology, 2003
