% An example showing how one can analyze simulated
% data and estimate and plot detection rates

disp('--Running AnalyzeDataDemo.m--');

% name of a file with simulations with pure noise
nullSimsFname = 'nullsimsN1024.mat'; 

% name of files with simulations with noisy cubic phase signal
altSimsFname = {...
'CubicPhase2signal-BP16-slevel0_15N1024'...
'CubicPhase2signal-BP16-slevel0_2N1024'...
'CubicPhase2signal-BP16-slevel0_25N1024'...
'CubicPhase2signal-BP16-slevel0_275N1024'...
'CubicPhase2signal-BP16-slevel0_3N1024'...
'CubicPhase2signal-BP16-slevel0_35N1024'...
};

% the path lengths for the BP statistic 
bpPathLengths = [1 2 4 8 16];

% load the null distribution
load(nullSimsFname);
nullT = -T; % minus to change to positive costs

% estimate minimum p-values for the null distribution
disp('Estimating minimum p-values under null...');
pmin = EstimateMinPvalues(nullT,[],bpPathLengths);

% Choose 5% as type I error and find threshold
alpha = 0.05;
thresh = GetThreshold(pmin,alpha,0);

% find detection rates
nAlts = length(altSimsFname);
detRateArray = zeros(1,nAlts);
snrArray = zeros(1,nAlts);
for k=1:length(altSimsFname),
  load(altSimsFname{k});
  snrArray(k) = expSetup.snr;
  signalT = -T; % minus to change to positive costs, reject the null for large values
  disp(sprintf('Estimating detection rate for data in %s...',altSimsFname{k}));  
  detRateArray(k) = EstimateDetRate(nullT,signalT,thresh,bpPathLengths);
end
disp('Done!');

% Plot the detection rates versus signal to noise ratios
figure;
plot(snrArray,detRateArray,'-*');
xlabel('SNR');ylabel('Detection Rate');
axis([xlim 0 1]);
