% A script for generating the plots in the Chirp Estimation chapter

J = 9;          % dyadic length of signal
N =  2^J;       % length of signal

% Settings for test statistic
maxLength = 32;              % Calculates BP for lengths 1,...,maxLength
graphparam = GetChirpletGraphParam(N);

vals = [0.01 0.03 0.05 0.07 0.09];
for bla=1:length(vals),
sigma = vals(bla);
theAxis = [0 N -0.11 0.11];
theAxisIF = [0 N 0 110];

lambda = 4*sigma^2*log(N);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% GENERATE A SIGNAL
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
disp('Generating chirp...');
[y,omega]= MakeChirp('CosinePhaseModulatedAmplitude',N);
y = y/norm(y); % normalize so the signal has l2-norm 1
noise = (randn(1,N)+i*randn(1,N))*sigma/sqrt(2);
noisy = y+noise;
yorig = y;
y = noisy;

cc = ChirpletTransform(y,graphparam); 
[costpath,bestpaths] = BPDirect(cc,graphparam,maxLength);

MSE = zeros(1,maxLength);
R = zeros(1,maxLength);
K = zeros(1,maxLength);
for k=1:maxLength,
  pp = bestpaths{k};
  yhat = GenerateSignalFromPath(pp,graphparam,noisy);
  MSE(k) = norm(yhat-yorig)^2;
  R(k)   = norm(yhat-y)^2;
  K(k)   = R(k) + lambda*k;
end

% TBCF estimation
yhatTBF = ThreshChirplet(noisy,sigma);

% Best Path estimation
[allYhat, nChirplets, omegahat, phihat, amphat, phi0hat] = BPDenoiseWithSpline(noisy,sigma,graphparam,maxLength);

close all;
% plot MSE and \|y - \hat{y}\|^2 versus complexity
figure(1);
L = 1:maxLength;
semilogy(L, MSE,'-o');
xlabel('L : number of chirplets in path');
ylabel('Sum of Squared Errors')
sigmaLevelStr = sprintf('%0.3f',sigma);
fname = sprintf('MSEvsL-sigma%s.eps',strrep(sigmaLevelStr,'.','_'));
print(fname,'-deps');


figure(2);
L = 1:maxLength;
semilogy(L, R,'-o');
xlabel('L : number of chirplets in path');
ylabel('RSS');
sigmaLevelStr = sprintf('%0.3f',sigma);
fname = sprintf('RSSvsL-sigma%s.eps',strrep(sigmaLevelStr,'.','_'));
print(fname,'-deps');

figure(3);
L = 1:maxLength;
semilogy(L, K,'-o');
xlabel('L : number of chirplets in path');
ylabel('K');
sigmaLevelStr = sprintf('%0.3f',sigma);
fname = sprintf('KvsL-sigma%s.eps',strrep(sigmaLevelStr,'.','_'));
print(fname,'-deps');


% plot original signal
figure(4);
plot(real(yorig))
ylabel('Real part of signal');
xlabel('time');
axis(theAxis);
fname = sprintf('OriginalSignal.eps');
print(fname,'-deps');


%print(sprintf('cubic-orig.eps',k'),'-deps');

% plot noisy signal
figure(5);
plot(real(noisy))
ylabel('Real part of signal');
xlabel('time');
axis(theAxis);
SNRdb = 10*log10(1/(norm(noisy - yorig)^2));
title(sprintf('SNR_{db} = %0.3f db',SNRdb));
sigmaLevelStr = sprintf('%0.3f',sigma);
fname = sprintf('NoisySignal-sigma%s.eps',strrep(sigmaLevelStr,'.','_'));
print(fname,'-deps');


%print(sprintf('cubic-noisy.eps',k'),'-deps');


% plot estimates

% constant amplitude BP
figure(61);
plot(real(allYhat(1,:)));
ylabel('Real part of signal');
xlabel('time');
SNRdb = 10*log10(1/(norm(allYhat(1,:) - yorig)^2));
title(sprintf('SNR_{db} = %0.3f db',SNRdb));
axis(theAxis);
sigmaLevelStr = sprintf('%0.3f',sigma);
fname = sprintf('BPEst-sigma%s.eps',strrep(sigmaLevelStr,'.','_'));
print(fname,'-deps');

% BPGA
figure(62);
plot(real(allYhat(2,:)));
ylabel('Real part of signal');
xlabel('time');
SNRdb = 10*log10(1/(norm(allYhat(2,:) - yorig)^2));
title(sprintf('SNR_{db} = %0.3f db',SNRdb));
axis(theAxis);
sigmaLevelStr = sprintf('%0.3f',sigma);
fname = sprintf('BPGAEst-sigma%s.eps',strrep(sigmaLevelStr,'.','_'));
print(fname,'-deps');

% BPGA
figure(63);
plot(real(yhatTBF));
ylabel('Real part of signal');
xlabel('time');
axis(theAxis);
SNRdb = 10*log10(1/(norm(yhatTBF - yorig)^2));
title(sprintf('SNR_{db} = %0.3f db',SNRdb));
axis(theAxis);
sigmaLevelStr = sprintf('%0.3f',sigma);
fname = sprintf('TBCFEst-sigma%s.eps',strrep(sigmaLevelStr,'.','_'));
print(fname,'-deps');

figure(7);
plot(omega,'r--');
hold on;plot(omegahat);
ylabel('frequency');
xlabel('time');
legend('true IF','estimated IF','Location','East');
axis(theAxisIF);
sigmaLevelStr = sprintf('%0.3f',sigma);
fname = sprintf('IFest-sigma%s.eps',strrep(sigmaLevelStr,'.','_'));
print(fname,'-deps');

end
