% An example showing how to set up ChirpLab to run
% a certain number of simulations under the alternative.
disp('--Running RunSimsAltDemo.m--');

% signal length
N = 2^6;

% initialize chirplet graph using the default settings
disp('Initializing chirplet graph...');
graphparam = GetChirpletGraphParam(N);

% Use the best path statistic with lengths 1,2,3,4
statType = 'BP';
statParam = 4;

% number of simulations
numSims = 10;

sig = MakeChirp('CubicPhase',N);
snr = 0.5;

% wrap the experiment setup
expSetup = ExperimentSetup(graphparam,statType,statParam,numSims,sig,snr);

% the random seed to use
randseed = 4321;

% run the simulations
disp('Running the simulations (this might take awhile)...');
T = RunSimulations(expSetup,[],randseed)
disp('Done!');
